C:::::      ,,,,,VEM500...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM500(T,ALPHA,OWN,NK,NGROUP,GINFO1,GINFO,
     &                  MOUNT1,MOUNT,DIM,NN,NOD,NOP1,NOP,NOPARM,
     &                  LOCU,LOCUT,NEK,RPARM,IPARM,
     &                  MATRIX,SYM,MASKL,USERL,
     &                  USERK,NRHS,MASKF,USERF,LEM,EM,
     &                  LBIG,RBIG,IBIG,MYPROC,MYTID,OUTCNT,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM500   controls the computation of the element matrices  ***
C**               for the matrix ALPHA*K+L and NRHS right hand      ***
C**               sides. the array of the element EM is not         ***
C**               initilized.                                       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"

      INTEGER           NK,NGROUP,GINFO1,MOUNT1,DIM,NN,NOP,NOP1,
     &                  LEM,MATRIX,NRHS,OUTCNT,LOUT,ERR,OWN,LBIG,
     &                  MYPROC,MYTID

      INTEGER           GINFO(GINFO1,NGROUP),IBIG(LBIG*RPI),
     &                  MOUNT(MOUNT1,NGROUP),NEK(*),IPARM(*)

      DOUBLE PRECISION  ALPHA,T,NOD(NN,DIM),LOCU(*),NOPARM(NOP1,NOP),
     &                  LOCUT(*),RPARM(*),RBIG(LBIG),EM(LEM)

      LOGICAL           SYM,MASKL(NK,NK,NGROUP),MASKF(NK,NRHS,NGROUP)

      EXTERNAL          USERF,USERL,USERK
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I current time step
C--------I------I-----I-----------------------------------------------
C ALPHA  I  R   I in  I weight for mass matrix K
C--------I------I-----I-----------------------------------------------
C OWN    I  I   I in  I number of proposal functions
C        I      I     I =0 isoparametric elements
C--------I------I-----I-----------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I-----------------------------------------------
C GINFO  I  I   I in  I element info        array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C MOUNT  I  I   I in  I element infos for mounting (set in vem63X)
C        I      I     I 1 = SLICE - size of element matrix 
C        I      I     I 2 = PILE  - size of rhs element matrix
C        I      I     I 3 = STORRS- real scalar storage
C        I      I     I 4 = STORRV- real vector storage
C        I      I     I 5 = STORIS- integer scalar storage
C        I      I     I 6 = STORIV- integer vector storage
C        I      I     I 7 = ORDER - order of integration formula
C        I      I     I 8 = NQMAX - number of integration nodes 
C        I      I     I 9 = LEAD - leading dimension of element matrices
C        I      I     I                     array: MOUNT(MOUNT1,NGROUP)
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension 
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I node coordinates             array: NOD(NN,DIM)
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C NOPARM I  R   I in  I node parameters         array: NOPARM(NOP1,NOP)
C--------I------I-----I------------------------------------------------
C LOCU   I  R   I in  I solution at the local element nodes
C        I      I     I                                  array: LOCU(*)
C--------I------I-----I------------------------------------------------
C LOCUT  I  R   I in  I derivative of solution with respect to time
C        I      I     I at the local element nodes      array: LOCUT(*)
C        I      I     I (only defined if for MATRIX=1,-1,11)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                     array: NEK(*)
C--------I------I-----I------------------------------------------------
C RPARM  I  I   I in  I real element parameters         array: RPARM(*)
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I in  I integer element parameters      array: IPARM(*)
C--------I------I-----I------------------------------------------------
C MATRIX I  I   I in  I specify the matrix type
C        I      I     I =0 global matrix (L,F) with ALPHA=0
C        I      I     I =-1 global matrices (L,F) with T-derivative of U
C        I      I     I =1 sum of global matrices ALPHA<>0 (L+ALPHA*K,F)
C        I      I     I =10 error estimation (L,F)
C        I      I     I =11 error estimation (L,F) with T-derivative of U 
C--------I------I-----I------------------------------------------------
C SYM    I  L   I in  I symmetry flag
C--------I------I-----I------------------------------------------------
C MASKL  I   L  I in  I masks of matrix couplings in L and K
C        I      I     I                      array: MASKL(NK,NK,NGROUP)
C--------I------I-----I------------------------------------------------
C USERL  I  EX  I in  I routine specify bilinear form L
C--------I------I-----I------------------------------------------------
C USERK  I  EX  I in  I routine specify bilinear form K
C--------I------I-----I------------------------------------------------
C NRHS   I  I   I in  I number of right hand side F
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I mask of right hand side
C        I      I     I                    array: MASKF(NK,NRHS,NGROUP)
C--------I------I-----I------------------------------------------------
C USERF  I  EX  I in  I routine specify right hand side F
C--------I------I-----I------------------------------------------------
C EM     I  R   I i/o I the element matrices             array: EM(LEM)
C--------I------I-----I------------------------------------------------
C RBIG   I  R   I -   I real work array               array: RBIG(LBIG)
C--------I------I-----I------------------------------------------------
C IBIG   I  I   I -   I integer work array        array: IBIG(LBIG*RPI)
C        I      I     I warning: ibig and rbig are equivalence !
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C MYTID  I  I   I in  I task id
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I  IN I output control
C        I      I     I (=0 only error messages are print)
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I  IN I message unit
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I ERROR NUMBER
C        I      I     I =5000 LBIG is too small
C        I      I     I =5002 there is an empty stripe 
C        I      I     I =5003 illegal group informations
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NQ,WQ,Q,S,DSDV,IWORK,RWORK,ELM1,ELM1T,ELM1TK,
     &                  X,UU,UUT,ENOP,DNTEDX,DUDX,
     &                  DUTDX,DNOPDX,JACOBI,DA,DL,TAU,VRBIG,VRB2,
     &                  N,DNDV,NTE,DNTEDV,NE,NELTYP,FORM,CLASS,
     &                  ADRSP,NRSP,ADRVP,U1,U2,
     &                  NIVP,IVP1,ADIVP,NISP,ADISP,NRVP,RVP1,
     &                  SLICE,PILE,STORIV,STORRV,LEAD,
     &                  STORIS,STORRS,NQMAX,ORDER,TOTNT,
     &                  NK2,GEO1,GEOTYP,ADDGEO,PRFLIB,SETME,
     &                  G,GLOCU,GEM,GRHS,STRIPS,IERR2,NBIG
      include 'archi.h'
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      GLOCU=1
      GEM=1
      ERR=0
      NBIG=0
      NK2=MAX(1,OWN)

      IF (OUTCNT.NE.0) WRITE(LOUT,9010)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of group loop :                                         ***
C**   --------------------                                          ***
C**                                                                 ***
      DO 10 G=1,NGROUP
C**                                                                 ***
C****** Current group informations:                                 ***
C**                                                                 ***
        STRIPS=0

        NE     = GINFO( 1,G)
        GEOTYP = GINFO( 2,G)
        FORM   = GINFO( 3,G)
        CLASS  = GINFO( 4,G)
        ADDGEO = GINFO( 5,G)
        GEO1   = GINFO( 6,G)

        ADRSP  = GINFO( 8,G)
        NRSP   = GINFO( 9,G)
        ADRVP  = GINFO(10,G)
        RVP1   = GINFO(11,G)
        NRVP   = GINFO(12,G)

        ADISP  = GINFO(13,G)
        NISP   = GINFO(14,G)
        ADIVP  = GINFO(15,G)
        IVP1   = GINFO(16,G)
        NIVP   = GINFO(17,G)

        TOTNT  = GINFO(23,G)
        NELTYP = 24
        PRFLIB = 24+NK

        SLICE  = MOUNT(1,G)
        PILE   = MOUNT(2,G)
        STORRS = MOUNT(3,G)
        STORRV = MOUNT(4,G)
        STORIS = MOUNT(5,G)
        STORIV = MOUNT(6,G)
        ORDER  = MOUNT(7,G)
        NQMAX  = MOUNT(8,G)
	LEAD   = MOUNT(9,G)

	U2=TOTNT*(NK-NK2+1)
	U1=NE
	GRHS=GEM+SLICE*LEAD
	
        IF (NE*(PILE+SLICE).EQ.0) THEN
          ELM1=0
          STRIPS=0
          NQ=NQMAX
        ELSE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute shape and proposal functions at quadrture nodes:    ***
C**     -------------------------------------------------------     ***
C**                                                                 ***
C**   start addresses:                                              ***
C**                                                                 ***
C**     WQ-integration weights (NQ)                                 ***
C**      Q-Intgration nodes    (CLASS,NQ)                           ***
C**      S-shape functions at nodes (GEOTYP,NQ)                     ***
C**   DSDV-derivatives of shape functions at nodes (GEOTYP,CLASS,NQ)***
C**      N-proposal functions at nodes (TOTNT,NQ)                   ***
C**   DNDV-derivatives of proposal functions at nodes               ***
C**                                        (TOTNT,CLASS,NQ)         ***
C**    NTE-test functions at nodes (TOTNT,NQ)                       ***
C** DNTEDV-derivatives of test functions at nodes                   ***
C**                                        (TOTNT,CLASS,NQ)         ***
C**  RWORK-real work space for VEMPRF (STORRS)                      ***
C**  IWORK-integer work space for VEMPRF  (STORIS)                  ***
C**                                                                 ***
        WQ   =1
        Q    =WQ  +1*NQMAX
        S    =Q   +CLASS*NQMAX
        DSDV =S   +GEOTYP*NQMAX
        IF (OWN.EQ.0) THEN
          N    =S
        ELSE
          N    =DSDV+GEOTYP*CLASS*NQMAX
        ENDIF
        DNDV =N   +TOTNT*NQMAX
        IF ((MATRIX.EQ.10).OR.(MATRIX.EQ.11)) THEN
          SETME=1
          NTE  =DNDV+TOTNT*CLASS*NQMAX
        ELSE
          SETME=0
          NTE  =N
        ENDIF
        DNTEDV =NTE  +TOTNT*NQMAX
        RWORK=DNTEDV+TOTNT*CLASS*NQMAX
        IWORK=(RWORK+STORRS-1)*RPI+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** check storage :                                             ***
C**     ---------------                                             ***
C**                                                                 ***
        NBIG=MAX(NBIG,STORRS+(STORIS+RPI-1)/RPI)
        IF (NBIG.GT.LBIG) THEN
          WRITE(LOUT,9630) MYPROC,MYTID
          ERR=5000
          GOTO 9999
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** set shape and proposal functions :                          ***
C**     --------------------------------                            ***
C**                                                                 ***
        CALL VEMPRF(SETME,G,CLASS,FORM,OWN,ORDER,NQ,NQMAX,RBIG(WQ),
     &              RBIG(Q),GEOTYP,RBIG(S),RBIG(DSDV),
     &              GINFO(NELTYP,G),GINFO(PRFLIB,G),
     &              TOTNT,RBIG(N),RBIG(DNDV),RBIG(NTE),RBIG(DNTEDV),
     &              STORRS-RWORK+1,RBIG(RWORK),STORIS,IBIG(IWORK),
     &              MYPROC,MYTID,LOUT,IERR2)
        IF (IERR2.NE.0) THEN
          ERR=5003
          GOTO 9999
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute stripe length (elm1) :                              ***
C**     ----------------------------                                ***
C**                                                                 ***
        ELM1=MIN(MV,NE)

        IF ((MATRIX.EQ.1).OR.(MATRIX.EQ.-1).OR.(MATRIX.EQ.11)) THEN
          ELM1T=ELM1
        ELSE
          ELM1T=0
        ENDIF
        IF (MATRIX.EQ.1) THEN
          ELM1TK=ELM1
        ELSE
          ELM1TK=0
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** inner elments :                                             ***
C**     --------------                                              ***
C**                                                                 ***
        IF (CLASS.EQ.DIM) THEN
          X     =RWORK
          UU    =X     +ELM1 *DIM
          UUT   =UU    +ELM1 *NK
          ENOP  =UUT   +ELM1T*NK
          DNTEDX=ENOP  +ELM1 *NOP
          DUDX  =DNTEDX+ELM1 *TOTNT*DIM
          DUTDX =DUDX  +ELM1 *NK*DIM
          DNOPDX=DUTDX +ELM1T*NK*DIM
          JACOBI=DNOPDX+ELM1 *NOP*DIM
          VRBIG =JACOBI+ELM1 *1

          IF (SLICE.EQ.0) THEN
            VRB2=MAX(DIM*DIM+MAX(NK,NOP)*DIM,DIM+1)
          ELSE
            IF (MATRIX.EQ.1) THEN
              VRB2=MAX(DIM*DIM+MAX(NK,NOP)*DIM,2*(DIM*DIM+2*DIM+1))
            ELSE
              VRB2=MAX(DIM*DIM+MAX(NK,NOP)*DIM,DIM*DIM+2*DIM+1)
            ENDIF
          ENDIF

          NBIG=MAX(NBIG,VRBIG-1+VRB2*ELM1)
          IF (NBIG.GT.LBIG) THEN
            WRITE(LOUT,9630) MYPROC,MYTID
            ERR=5000
            GOTO 9999
          ENDIF

          CALL VEM520(T,ALPHA,G,NE,NK,NK2,GINFO(NELTYP,G),
     &                TOTNT,GEO1,GEOTYP,NEK(ADDGEO),
     &                NRSP,RPARM(ADRSP),NRVP,RVP1,RPARM(ADRVP),
     &                NISP,IPARM(ADISP),NIVP,IVP1,IPARM(ADIVP),
     &                NOP1,NOP,NOPARM,DIM,NN,NOD,
     &                U1,U2,LOCU(GLOCU),LOCUT(GLOCU),
     &                SYM,MASKL(1,1,G),USERL,USERK,
     &                NRHS,MASKF(1,1,G),USERF,
     &                ELM1,LEAD,SLICE,EM(GEM),PILE,EM(GRHS),
     &                NQ,RBIG(WQ),RBIG(S),RBIG(DSDV),
     &                RBIG(N),RBIG(DNDV),RBIG(NTE),RBIG(DNTEDV),
     &                RBIG(X),RBIG(UU),ELM1T,RBIG(UUT),RBIG(ENOP),
     &                RBIG(DNTEDX),RBIG(DUDX),RBIG(DUTDX),
     &                RBIG(DNOPDX),RBIG(JACOBI),ELM1TK,
     &                VRB2,RBIG(VRBIG),STRIPS)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** area boundary elements :                                    ***
C**     ----------------------                                      ***
C**                                                                 ***
        IF ((CLASS.EQ.2).AND.(DIM.EQ.3)) THEN
          X     =RWORK
          UU    =X     +ELM1 *DIM
          UUT   =UU    +ELM1 *NK
          ENOP  =UUT   +ELM1T*NK
          TAU   =ENOP  +ELM1 *NOP
          DNTEDX=TAU   +ELM1 *DIM*2
          DUDX  =DNTEDX+ELM1 *TOTNT*2
          DUTDX =DUDX  +ELM1 *NK*2
          DNOPDX=DUTDX +ELM1T*NK*2
          DA    =DNOPDX+ELM1 *NOP*2
          VRBIG =DA    +ELM1 *1

          IF (SLICE.EQ.0) THEN
            VRB2=3
          ELSE
            IF (MATRIX.EQ.1) THEN
              VRB2=18
            ELSE
              VRB2=9
            ENDIF
          ENDIF

          NBIG=MAX(NBIG,VRBIG-1+VRB2*ELM1)
          IF (NBIG.GT.LBIG) THEN
            WRITE(LOUT,9630) MYPROC,MYTID
            ERR=5000
            GOTO 9999
          ENDIF

          CALL VEM522(T,ALPHA,G,NE,NK,NK2,GINFO(NELTYP,G),
     &                TOTNT,GEO1,GEOTYP,NEK(ADDGEO),
     &                NRSP,RPARM(ADRSP),NRVP,RVP1,RPARM(ADRVP),
     &                NISP,IPARM(ADISP),NIVP,IVP1,IPARM(ADIVP),
     &                NOP1,NOP,NOPARM,NN,NOD,
     &                U1,U2,LOCU(GLOCU),LOCUT(GLOCU),
     &                SYM,MASKL(1,1,G),USERL,USERK,
     &                NRHS,MASKF(1,1,G),USERF,
     &                ELM1,LEAD,SLICE,EM(GEM),PILE,EM(GRHS),
     &                NQ,RBIG(WQ),RBIG(S),RBIG(DSDV),
     &                RBIG(N),RBIG(DNDV),RBIG(NTE),RBIG(DNTEDV),
     &                RBIG(X),RBIG(UU),ELM1T,RBIG(UUT),RBIG(ENOP),
     &                RBIG(TAU),RBIG(DNTEDX),RBIG(DUDX),RBIG(DUTDX),
     &                RBIG(DNOPDX),RBIG(DA),ELM1TK,
     &                VRB2,RBIG(VRBIG),STRIPS)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** line elements :                                             ***
C**     -------------                                               ***
C**                                                                 ***
        IF ((CLASS.EQ.1).AND.(DIM.GT.1)) THEN

          X     =RWORK
          UU    =X     +ELM1 *DIM
          UUT   =UU    +ELM1 *NK
          ENOP  =UUT   +ELM1T*NK
          TAU   =ENOP  +ELM1 *NOP
          DNTEDX=TAU  +ELM1 *DIM
          DUDX  =DNTEDX+ELM1 *TOTNT
          DUTDX =DUDX  +ELM1 *NK
          DNOPDX=DUTDX +ELM1T*NK
          DL    =DNOPDX+ELM1 *NOP
          VRBIG =DL    +ELM1 *1

          IF (SLICE.EQ.0) THEN
            VRB2=2
          ELSE
            IF (MATRIX.EQ.1) THEN
              VRB2=8
            ELSE
              VRB2=4
            ENDIF
          ENDIF

          NBIG=MAX(NBIG,VRBIG-1+VRB2*ELM1)
          IF (NBIG.GT.LBIG) THEN
            WRITE(LOUT,9630) MYPROC,MYTID
            ERR=5000
            GOTO 9999
          ENDIF

          CALL VEM523(T,ALPHA,G,NE,NK,NK2,GINFO(NELTYP,G),
     &                TOTNT,GEO1,GEOTYP,NEK(ADDGEO),
     &                NRSP,RPARM(ADRSP),NRVP,RVP1,RPARM(ADRVP),
     &                NISP,IPARM(ADISP),NIVP,IVP1,IPARM(ADIVP),
     &                NOP1,NOP,NOPARM,DIM,NN,NOD,
     &                U1,U2,LOCU(GLOCU),LOCUT(GLOCU),
     &                SYM,MASKL(1,1,G),USERL,USERK,
     &                NRHS,MASKF(1,1,G),USERF,
     &                ELM1,LEAD,SLICE,EM(GEM),PILE,EM(GRHS),
     &                NQ,RBIG(WQ),RBIG(S),RBIG(DSDV),
     &                RBIG(N),RBIG(DNDV),RBIG(NTE),RBIG(DNTEDV),
     &                RBIG(X),RBIG(UU),ELM1T,RBIG(UUT),RBIG(ENOP),
     &                RBIG(TAU),RBIG(DNTEDX),RBIG(DUDX),RBIG(DUTDX),
     &                RBIG(DNOPDX),RBIG(DL),ELM1TK,
     &                VRB2,RBIG(VRBIG),STRIPS)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** nodal elements :                                            ***
C**     ---------------                                             ***
C**                                                                 ***
        IF (CLASS.EQ.0) THEN
          X     =RWORK
          UU    =X     +ELM1 *DIM
          UUT   =UU    +ELM1 *NK
          ENOP  =UUT   +ELM1T*NK
          VRBIG =ENOP  +ELM1 *NOP

          IF (MATRIX.EQ.1) THEN
            VRB2=1
          ELSE
            VRB2=0
          ENDIF

          NBIG=MAX(NBIG,VRBIG-1+VRB2*ELM1)
          IF (NBIG.GT.LBIG) THEN
            WRITE(LOUT,9630) MYPROC,MYTID
            WRITE(LOUT,9630)
            ERR=5000
            GOTO 9999
          ENDIF

          CALL VEM524(T,ALPHA,G,NE,NK,NK2,GINFO(NELTYP,G),
     &                GEO1,NEK(ADDGEO),
     &                NRSP,RPARM(ADRSP),NRVP,RVP1,RPARM(ADRVP),
     &                NISP,IPARM(ADISP),NIVP,IVP1,IPARM(ADIVP),
     &                NOP1,NOP,NOPARM,DIM,NN,NOD,
     &                U1,U2,LOCU(GLOCU),LOCUT(GLOCU),
     &                SYM,MASKL(1,1,G),USERL,USERK,
     &                NRHS,MASKF(1,1,G),USERF,
     &                ELM1,LEAD,SLICE,EM(GEM),PILE,EM(GRHS),
     &                RBIG(X),RBIG(UU),ELM1T,RBIG(UUT),RBIG(ENOP),
     &                ELM1TK,RBIG(VRBIG),STRIPS)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of group loop :                                           ***
C**   ------------------                                            ***
C**                                                                 ***
        ENDIF
        IF (OUTCNT.NE.0) WRITE(LOUT,9020) G,NE,ELM1,STRIPS,NQ,ORDER
	GLOCU=GLOCU+U1*U2
	GEM=GRHS+PILE*LEAD
 10   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9010  FORMAT(/'      group |     NE    |    ELM1   | '
     &        ,' stripes  |  points   | order |'/6X,63('-'))
9020  FORMAT(9X,I2,4(' | ',I9),' | ',I5,' |')
9630  FORMAT('>>VEMCD:30:0001'
     &      /'>>error in VEM500: process ',I10,' (TID=',I10,')'
     &      /'>>too small work space !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
9999  CONTINUE
      R E T U R N
C-----End of VEM500----------------------------------------------------
      E    N    D
