C:::::      ,,,,,VEM511...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM511(NK,OWN,NRHS,NGROUP,GINFO1,GINFO,NEK,BLKLST,BLK,
     &                  MOUNT1,MOUNT,ADD,EM,SBT,PTRMAT,LMAT,MAT,MASKF,
     &                  LM,F,NJUMP,JUMP,LMATBK,PTRMBK,
     &                  MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM511   adds the element matrices to the global matrix    ***
C**               and the right hand side.                          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NK,OWN,NRHS,NGROUP,GINFO1,MOUNT1,LMAT,LM,
     &                  NJUMP,MYPROC,NPROC,NMSG,SBT
      INTEGER           GINFO(GINFO1,NGROUP),NEK(*),BLKLST(NGROUP),
     &                  BLK(*),MOUNT(MOUNT1,NGROUP),ADD(*),JUMP(NJUMP),
     &                  LMATBK(NPROC),PTRMBK(NPROC),TIDS(NPROC),
     &                  PTRMAT(SBT)
      DOUBLE PRECISION  EM(*),MAT(*),F(LM,NRHS,SBT)
      LOGICAL           MASKF(NK,NRHS,NGROUP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I mesh type
C--------I------I-----I------------------------------------------------
C NRHS   I  I   I in  I number of right hand sides
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos         array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                     array: NEK(*)
C--------I------I-----I------------------------------------------------
C BLKLST I  I   I in  I number of blocks in groups 
C        I      I     I                           array: BLKLST(NGROUP)
C--------I------I-----I------------------------------------------------
C BLK    I  I   I in  I block lengths                array: BLK(BLKLST)
C--------I------I-----I------------------------------------------------
C MOUNT  I  I   I in  I information vector for mounting of the matrix
C        I      I     I (see vem620)        array: MOUNT(MOUNT1,NGROUP)
C--------I------I-----I------------------------------------------------
C ADD    I  I   I in  I address array                     array: ADD(*)
C--------I------I-----I------------------------------------------------
C EM     I  R   I in  I element matrices                   array: EM(*)
C--------I------I-----I------------------------------------------------
C SBT    I  I   I in  I =1 no switching buffer technique
C        I      I     I =2 use switching buffer technique
C--------I------I-----I------------------------------------------------
C PTRMAT I  I   I in  I PTRMAT(1) - pointer to the matrix of length LMAT
C        I      I     I             which is mounted
C        I      I     I PTRMAT(SBT) pointer to a buffer of length 
C        I      I     I             LMAT
C--------I------I-----I------------------------------------------------
C LMAT   I  R   I in  I maximal length of the matrix stripes over      
C        I      I     I all processors
C--------I------I-----I------------------------------------------------
C MAT    I  R   I out I matrix array                      array: MAT(*)
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I mask of right hand sides
C        I      I     I                    array: MASKF(NK,NRHS,NGROUP)
C--------I------I-----I------------------------------------------------
C F      I  R   I in  I right hand sides          array: F(LM,NRHS,SBT)
C        I      I     I F(.,.,1) is the mounted RHS and
C        I      I     I F(.,.,SBT) is the buffer.
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                              array: JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I                            array: LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I                            array: PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           BB,NK2,START0,PROC,TOTID,LL9MAP,
     &                  FRTID,M1,M01,P,I,Z,MIDS1,MIDR1,INFO,SB,EM0,G,
     &                  SLICE,PILE,LEAD,ADDNEK,NEK1,SL,L,SK,
     &                  J,NK3,SZ,K,NH,MIDS2,MIDR2,ADD0,NE,
     &                  SWPBUF,RCVBUF,SNDBUF
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      BB=NK-MAX(OWN,1)+1
      NK2=MAX(OWN,1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the buffer are selected so that SNDBUF=1 at the end of        ***
C**   the processor loop:                                           ***
C**                                                                 ***
      IF (MOD(NJUMP,2).EQ.0) THEN
        SNDBUF=1
        RCVBUF=SNDBUF+(SBT-1)
      ELSE
        RCVBUF=1
        SNDBUF=RCVBUF+(SBT-1)
      ENDIF
      START0=0
      PROC=MYPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of processor loop:                                      ***
C**   -----------------------                                       ***
C**                                                                 ***
      DO 10 P=1,NJUMP
       PROC=LL9MAP(PROC-JUMP(P),NPROC)
       M1=LMATBK(PROC)
       M01=PTRMBK(PROC)
       IF (NRHS.GT.0) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** first the right hand side is considered :                   ***
C**     ---------------------------------------                     ***
C**                                                                 ***
C**     for the first cycle the right hand side is initialized:     ***
C**                                                                 ***
	IF (P.EQ.1) THEN
	  DO 2000 I=1,NRHS
	    DO 2000 Z=1,LM
	     F(Z,I,RCVBUF)=0
2000      CONTINUE
	ELSE
          TOTID=TIDS(LL9MAP(MYPROC+JUMP(P),NPROC))
          FRTID=TIDS(LL9MAP(MYPROC-JUMP(P),NPROC))
	  CALL MPRCVA(FRTID,NMSG+P,IREAL*LM*NRHS,F(1,1,RCVBUF),
     &                                                     MIDR1,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IREAL*LM*NRHS,F(1,1,SNDBUF),
     &                                                     MIDS1,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IREAL*LM*NRHS,F(1,1,RCVBUF),
     &                                                     MIDR1,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IREAL*LM*NRHS,F(1,1,SNDBUF),
     &                                                     MIDS1,INFO)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** open the group loop:                                        ***
C**     -------------------                                         ***
C**                                                                 ***
	SB=0
	EM0=0
        DO 2010 G=1,NGROUP
          SLICE=MOUNT(1,G)
          PILE=MOUNT(2,G)
	  LEAD=MOUNT(9,G)
          NE=GINFO(1,G)
          ADDNEK=GINFO(21,G)
          NEK1  =GINFO(22,G)
	  EM0=EM0+SLICE*LEAD
C**                                                                 ***
C******** now the addition starts:                                  ***
C**                                                                 ***
	  SL=0
	  DO 2030 L=1,NRHS
  	    SK=0
	    DO 2030 J=1,NK
	      NK3=MIN(NK2,J)

              IF ((MASKF(J,L,G)).AND.(NE*GINFO(23+NK3,G).GT.0)) THEN
	        SZ=0
	        DO 2040 I=SB+1,SB+BLKLST(G)
	          DO 2050 K=1,GINFO(23+NK3,G)
                    include "norec.h"
	            dO 2050 Z=1,BLK(I)
	              NH=BB*NEK(ADDNEK-1+SZ+Z+NEK1*(SK+K-1))
     &                                            +MIN(J-BB,0)-M01
	              IF ((0.LT.NH).AND.(NH.LE.M1)) THEN
	                F(NH,L,RCVBUF)=
     &                     F(NH,L,RCVBUF)+EM(EM0+SZ+Z+LEAD*(SL+K-1))
                      ENDIF
 2050             CONTINUE
	          SZ=SZ+BLK(I)
 2040           CONTINUE
	        SL=SL+GINFO(23+NK3,G)
	      ENDIF
	      IF (NK3.LT.NK2) SK=SK+GINFO(23+NK3,G)
 2030     CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** close the group loop:                                       ***
C**     --------------------                                        ***
C**                                                                 ***
  	  SB=SB+BLKLST(G)
  	  EM0=EM0+PILE*LEAD
2010    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
       ENDIF
       IF (LMAT.GT.0) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** then we look to the global matrix:                          ***
C**     ---------------------------------                           ***
C**                                                                 ***
C**     for the first cycle the matrix is initialized.              ***
C**                                                                 ***
	IF (P.EQ.1) THEN
	  DO 3000 Z=1,LMAT
	    MAT(PTRMAT(RCVBUF)-1+Z)=0
3000      CONTINUE
	ELSE
          TOTID=TIDS(LL9MAP(MYPROC+JUMP(P),NPROC))
          FRTID=TIDS(LL9MAP(MYPROC-JUMP(P),NPROC))
	  CALL MPRCVA(FRTID,NMSG+NJUMP+P,IREAL*LMAT,
     &                               MAT(PTRMAT(RCVBUF)),MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+NJUMP+P,IREAL*LMAT,
     &                               MAT(PTRMAT(SNDBUF)),MIDS2,INFO)
	  CALL MPRCVW(FRTID,NMSG+NJUMP+P,IREAL*LMAT,
     &                               MAT(PTRMAT(RCVBUF)),MIDR2,INFO)
	  CALL MPSNDW(TOTID,NMSG+NJUMP+P,IREAL*LMAT,
     &                               MAT(PTRMAT(SNDBUF)),MIDS2,INFO)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** open the group loop:                                        ***
C**     -------------------                                         ***
C**                                                                 ***
	SB=0
	EM0=0
	ADD0=0
        DO 3010 G=1,NGROUP
          NE=GINFO(1,G)
          SLICE=MOUNT(1,G)
          PILE=MOUNT(2,G)
	  LEAD=MOUNT(9,G)
	  IF (NE*SLICE.GT.0) THEN
C**                                                                 ***
C******** now the addition starts:                                  ***
C**                                                                 ***
	  SZ=0
	  DO 3020 I=SB+1,SB+BLKLST(G)
           IF (BLK(I).GE.SLICE) THEN
             DO 3030 J=1,SLICE
               include "norec.h"
               DO 3030 Z=1,BLK(I)
	         NH=ADD(ADD0+SZ+Z+LEAD*(J-1))-START0
	         IF ((0.LT.NH).AND.(NH.LE.LMAT)) THEN
                   MAT(NH+PTRMAT(RCVBUF)-1)=
     &               MAT(NH+PTRMAT(RCVBUF)-1)+EM(EM0+SZ+Z+LEAD*(J-1))
                 ENDIF
 3030        CONTINUE
           ELSE
             DO 3040 Z=1,BLK(I)
               include "norec.h"
               DO 3040 J=1,SLICE
	         NH=ADD(ADD0+SZ+Z+LEAD*(J-1))-START0
	         IF ((0.LT.NH).AND.(NH.LE.LMAT)) THEN
                   MAT(NH+PTRMAT(RCVBUF)-1)=
     &              MAT(NH+PTRMAT(RCVBUF)-1)+EM(EM0+SZ+Z+LEAD*(J-1))
                 ENDIF
 3040        CONTINUE
           ENDIF
	   SZ=SZ+BLK(I)
 3020     CONTINUE
	  ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** close the group loop:                                       ***
C**     --------------------                                        ***
C**                                                                 ***
  	  SB=SB+BLKLST(G)
  	  EM0=EM0+(PILE+SLICE)*LEAD
  	  ADD0=ADD0+SLICE*LEAD
3010    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** send mounted and recieve new matrix stripe :                ***
C**     -------------------------------------------                 ***
C**                                                                 ***
       ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of processor loop:                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
	START0=START0+LMAT
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
10    CONTINUE
      NMSG=NMSG+2*NJUMP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM511----------------------------------------------------
      E    N    D
