C:::::      ,,,,,VEM517...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM517(OWN,NK,NGROUP,GINFO1,GINFO,
     &                  MOUNT1,MOUNT,DIM,NN,NOD,NEK,LEM,EM,
     &                  LBIG,RBIG,IBIG,MYPROC,MYTID,OUTCNT,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM517   controls the computation of the element matrices  ***
C**               for the computation of the norm of the defects    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"

      INTEGER           NK,NGROUP,GINFO1,MOUNT1,DIM,NN,
     &                  LEM,OUTCNT,LOUT,ERR,OWN,LBIG,MYPROC,MYTID

      INTEGER           GINFO(GINFO1,NGROUP),IBIG(LBIG*RPI),
     &                  MOUNT(MOUNT1,NGROUP),NEK(*)

      DOUBLE PRECISION  NOD(NN,DIM),RBIG(LBIG),EM(LEM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I number of proposal functions
C        I      I     I =0 isoparametric elements
C--------I------I-----I-----------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I-----------------------------------------------
C GINFO  I  I   I in  I element info         array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C MOUNT  I  I   I in  I info vector for mounting (see in vem63X)
C        I      I     I                     array: MOUNT(MOUNT1,NGROUP)
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I node coordinates             array: NOD(NN,DIM)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                     array: NEK(*)
C--------I------I-----I------------------------------------------------
C EM     I  R   I i/o I the element matrices             array: EM(LEM)
C--------I------I-----I------------------------------------------------
C RBIG   I  R   I -   I real work array               array: RBIG(LBIG)
C--------I------I-----I------------------------------------------------
C IBIG   I  I   I -   I integer work array        array: IBIG(LBIG*RPI)
C        I      I     I warning: IBIG and RBIG are equivalence!
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C MYTID  I  I   I in  I task id
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I output control
C        I      I     I (=0 only error messages are print)
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I message unit
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number (local)
C        I      I     I =5170 LBIG is too small
C        I      I     I =5172 there is an empty stripe (lbig too small)
C        I      I     I =5173 illegal group information
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NQ,WQ,Q,S,DSDV,IWORK,RWORK,ELM1,
     &                  JAC,N,DNDV,NE,NELTYP,FORM,CLASS,
     &                  PILE,STORIV,STORRV,LEAD,NEK1,ADDNEK,
     &                  STORIS,STORRS,NQMAX,ORDER,TOTNT,DXDV,
     &                  NK2,GEO1,GEOTYP,ADDGEO,PRFLIB,SETME,
     &                  G,GEM,STRIPS,IERR2,NBIG
      include 'archi.h'
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      GEM=1
      ERR=0
      NBIG=0
      NK2=MAX(1,OWN)
      IF (OUTCNT.NE.0) WRITE(LOUT,9010)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of GROUP LOOP :                                         ***
C**   --------------------                                          ***
C**                                                                 ***
      DO 10 G=1,NGROUP
C**                                                                 ***
C****** group informations :                                        ***
C**     ------------------                                          ***
C**                                                                 ***
        STRIPS=0

        NE     = GINFO( 1,G)
        GEOTYP = GINFO( 2,G)
        FORM   = GINFO( 3,G)
        CLASS  = GINFO( 4,G)
        ADDGEO = GINFO( 5,G)
        GEO1   = GINFO( 6,G)
        ADDNEK = GINFO(21,G)
        NEK1   = GINFO(22,G)
        TOTNT  = GINFO(23,G)
        NELTYP = 24
        PRFLIB = 24+NK

        PILE   = MOUNT(2,G)
        STORRS = MOUNT(3,G)
        STORRV = MOUNT(4,G)
        STORIS = MOUNT(5,G)
        STORIV = MOUNT(6,G)
        ORDER  = MOUNT(7,G)
        NQMAX  = MOUNT(8,G)
	LEAD   = MOUNT(9,G)

        IF (NE*PILE.EQ.0) THEN
          ELM1=0
          STRIPS=0
          NQ=NQMAX
        ELSE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute shape function at quadrature nodes:                 ***
C**     ------------------------------------------                  ***
C**                                                                 ***
C**   start addresses:                                              ***
C**                                                                 ***
C**     WQ-integration weights (NQ)                                 ***
C**      Q-intgration nodes    (CLASS,NQ)                           ***
C**      S-shape functions at nodes (GEOTYP,NQ)                     ***
C**   DSDV-derivatives of shape functions at nodes (GEOTYP,CLASS,NQ)***
C**      N-proposal functions at nodes (TOTNT,NQ)                   ***
C**   DNDV-derivatives of proposal functions at nodes               ***
C**                                        (TOTNT,CLASS,NQ)         ***
C**  RWORK-real work space for vemprf (STORRS)                      ***
C**  IWORK-integer work space for vemprf  (STORIS)                  ***
C**                                                                 ***
        WQ   =1
        Q    =WQ  +1*NQMAX
        S    =Q   +CLASS*NQMAX
        DSDV =S   +GEOTYP*NQMAX
        IF (OWN.EQ.0) THEN
          N    =S
        ELSE
          N    =DSDV+GEOTYP*CLASS*NQMAX
        ENDIF
        DNDV =N   +TOTNT*NQMAX
        RWORK=DNDV+TOTNT*CLASS*NQMAX
        IWORK=(RWORK+STORRS-1)*RPI+1
        SETME=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** check storage :                                             ***
C**     ---------------                                             ***
C**                                                                 ***
        NBIG=MAX(NBIG,RWORK+STORRS+(STORIS+RPI-1)/RPI)
        IF (NBIG.GT.LBIG) THEN
          WRITE(LOUT,9630) MYPROC,MYTID
          ERR=5170
          GOTO 9999
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** set proposal functions :                                    ***
C**     ----------------------                                      ***
C**                                                                 ***
        CALL VEMPRF(SETME,G,CLASS,FORM,OWN,ORDER,NQ,NQMAX,RBIG(WQ),
     &              RBIG(Q),GEOTYP,RBIG(S),RBIG(DSDV),
     &              GINFO(NELTYP,G),GINFO(PRFLIB,G),
     &              TOTNT,RBIG(N),RBIG(DNDV),RBIG(N),RBIG(DNDV),
     &              STORRS,RBIG(RWORK),STORIS,IBIG(IWORK),
     &              MYPROC,MYTID,LOUT,IERR2)
        IF (IERR2.NE.0) THEN
          ERR=5173
          GOTO 9999
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute stripe length (ELM1) :                              ***
C**     ----------------------------                                ***
C**                                                                 ***
        ELM1  = MIN(MV,NE)
	JAC=RWORK
	DXDV=JAC+ELM1
        NBIG=MAX(NBIG,DXDV-1+CLASS*DIM*ELM1)
        IF (NBIG.GT.LBIG) THEN
          WRITE(LOUT,9630) MYPROC,MYTID
          ERR=5170
          GOTO 9999
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** call routine to calculate element matrices:                 ***
C**     ------------------------------------------                  ***
C**                                                                 ***
        CALL VEM539(NE,CLASS,GEOTYP,GEO1,NEK(ADDGEO),TOTNT,NEK1,
     &              NEK(ADDNEK),DIM,NN,NOD,LEAD,PILE,EM(GEM),
     &              NQ,RBIG(WQ),RBIG(DSDV),RBIG(N),
     &              ELM1,RBIG(DXDV),RBIG(JAC),STRIPS)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
        ENDIF
        IF (OUTCNT.NE.0) WRITE(LOUT,9020) G,NE,ELM1,STRIPS,NQ,ORDER
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of group loop :                                           ***
C**   ------------------                                            ***
C**                                                                 ***
	GEM=GEM+PILE*LEAD
 10   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9010  FORMAT (/'      group |     NE    |    ELM1   | '
     &        ,' stripes  |  points   | order |'/6X,63('-'))
9020  FORMAT (9X,I2,4(' | ',I9),' | ',I5,' |')

9630  FORMAT('>>VEMCD:30:0001'
     &      /'>>error in VEM517: process ',I10,' (TID=',I10,')'
     &      /'>>too small work space !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
9999  CONTINUE
      R E T U R N
C-----End of VEM517----------------------------------------------------
      E    N    D
