C:::::      ,,,,,VEM518...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM518(OWN,T,NK,DINFO1,DINFO,NRHS,M0,LM,DIM,NN,NOD,
     &                  NOP1,NOP,NOPARM,DNOD,RDPARM,IDPARM,
     &                  B,LDC,X,DNOPRM,WORK,USERB)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM518  set the values of the Dirichlet conditions at the    ***
C**            global nodes. The output vector B is set to the      ***
C**            values of the Dirichlet conditions at the global     ***
C**            nodes, where Dirichlet conditions are prescribed.    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           OWN,NK,DINFO1,NRHS,M0,LM,DIM,NN,NOP,NOP1,LDC

      DOUBLE PRECISION  T,NOD(NN,DIM),B(LM,NRHS),RDPARM(*),
     &                  X(LDC*DIM),DNOPRM(LDC*NOP),
     &                  NOPARM(NOP1,NOP),WORK(LDC)

      INTEGER           DINFO(DINFO1,NK),DNOD(*),IDPARM(*)

      EXTERNAL          USERB
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I NUMBER OF COMPONENTS WITH OWN TEST/PROPOSAL
C        I      I     I FUNCTIONS
C        I      I     I =0 ISOPARAMETRIC ELEMENTS
C--------I------I-----I-----------------------------------------------
C T      I  R   I in  I current time
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I info vector for Dirichlet conditions
C        I      I     I                         array: DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C NRHS   I  I   I in  I number of right hand sides
C--------I------I-----I------------------------------------------------
C M0     I  I   I in  I first-1 of first node on processor
C--------I------I-----I------------------------------------------------
C LM     I  I   I in  I maximal number of unknowns on a process
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I node coordinates             array: NOD(NN,DIM)
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C NOPARM I  R   I in  I node parameters         array: NOPARM(NOP1,NOP)
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I in  I node id numbers of Dirichlet conditions
C        I      I     I                                  array: DNOD(*)
C--------I------I-----I------------------------------------------------
C RDPARM I  R   I in  I real parameters for Dirichlet conditions
C        I      I     I                                array: RDPARM(*)
C--------I------I-----I------------------------------------------------
C IDPARM I  I   I in  I integer parameters for Dirichlet conditions
C        I      I     I                                array: IDPARM(*)
C--------I------I-----I------------------------------------------------
C X      I  R   I  -  I work array nodes coordinates  array: X(LDC*DIM)
C--------I------I-----I------------------------------------------------
C DNOPRM I  R   I  -  I work array for node parameters
C        I      I     I                          array: DNOPRM(LDC*NOP)
C--------I------I-----I------------------------------------------------
C B      I  R   I i/o I vector of the values of the Dirichlet
C        I      I     I conditions. values at global nodes with
C        I      I     I no Dirichlet condition are unchanged.
C        I      I     I                               array: B(LM,NRHS)
C--------I------I-----I------------------------------------------------
C WORK   I  R   I  -  I work array for the values of the Dirichlet
C        I      I     I conditions                     array: WORK(LDC)
C--------I------I-----I------------------------------------------------
C USERB  I  EX  I in  I routine defining the Dirichlet condtions
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NDC,ADDCG,ADRSDP,NRSDP,ADRVDP,RVDP1,NRVDP,
     &                  ADISDP,NISDP,ADIVDP,IVDP1,NIVDP,ADDCC,BB,BC
      INTEGER           Z,I,J,S1,S3,D
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch the node coordinates and node parameters:               ***
C**   ----------------------------------------------                ***
C**                                                                 ***
      S1=0
      S3=0
      DO 10 D=1,NK

        NDC= DINFO( 1,D)
        ADDCG=DINFO( 2,D)
        ADDCC=DINFO( 3,D)

        DO 30 J=1,DIM
          DO 30 Z=1,NDC
            X(S1+(J-1)*NDC+Z)=NOD(DNOD(ADDCG-1+Z),J)
 30     CONTINUE
        S1=S1+DIM*NDC

        DO 50 J=1,NOP
          DO 50 Z=1,NDC
            DNOPRM(S3+Z+(J-1)*NDC)=NOPARM(DNOD(ADDCG-1+Z),J)
 50     CONTINUE
        S3=S3+NOP*NDC
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of right hand side loop :                               ***
C**   -----------------------------                                 ***
C**                                                                 ***
      DO 60 I=1,NRHS
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** start of the component loop :                               ***
C**     ---------------------------                                 ***
C**                                                                 ***
        S1=1
        S3=1
        DO 80 D=1,NK
C**                                                                 ***
C******** compute the values of the Dirichlet conditions in WORK :  ***
C**       ------------------------------------------------------    ***
C**                                                                 ***
          NDC=DINFO( 1,D)
          ADDCG=DINFO( 2,D)
          ADDCC=DINFO( 3,D)

          ADRSDP = DINFO( 4,D)
          NRSDP  = DINFO( 5,D)
          ADRVDP = DINFO( 6,D)
          RVDP1  = DINFO( 7,D)
          NRVDP  = DINFO( 8,D)

          ADISDP = DINFO( 9,D)
          NISDP  = DINFO(10,D)
          ADIVDP = DINFO(11,D)
          IVDP1  = DINFO(12,D)
          NIVDP  = DINFO(13,D)

          DO 90  Z=1,NDC
            WORK(Z)=0.D0
 90       CONTINUE

          CALL USERB(T,D,I,
     &               NRSDP,RDPARM(ADRSDP),NRVDP,RVDP1,RDPARM(ADRVDP),
     &               NISDP,IDPARM(ADISDP),NIVDP,IVDP1,IDPARM(ADIVDP),
     &               NDC,DIM,X(S1),NOP,DNOPRM(S3),WORK)
C**                                                                 ***
C******** scatter the values into the output vector B:              ***
C**       -------------------------------------------               ***
C**                                                                 ***
          IF (D.GE.MAX(OWN,1)) THEN
            BB=NK-MAX(OWN,1)+1
            BC=D-NK
          ELSE
            BB=1
            BC=0
          ENDIF

          DO  100 Z=1,NDC
            B(BB*DNOD(ADDCC-1+Z)+BC-M0,I)= WORK(Z)
 100      CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** end of the component loop :                               ***
C**       ---------------------------                               ***
C**                                                                 ***
          S3=S3+NOP*NDC
          S1=S1+DIM*NDC

  80    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** end of right hand side loop :                               ***
C**     -----------------------------                               ***
C**                                                                 ***
 60     CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM518----------------------------------------------------
      E    N    D
