C:::::      ,,,,,VEM520...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM520(T,ALPHA,GROUP,NE,NK,NK2,NELTYP,
     &                  TOTNT,GEO1,GEOTYP,GEONEK,
     &                  NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  NOP1,NOP,NOPARM,DIM,NN,NOD,
     &                  U1,U2,U,UT,SYM,MASKL,USERL,USERK,
     &                  NRHS,MASKF,USERF,ELM1,LEAD,SLICE,EM,PILE,RHSEM,
     &                  NQ,WQ,S,DSDV,N,DNDV,NTE,DNTEDV,
     &                  X,UU,ELM1T,UUT,ENOP,
     &                  DNTEDX,DUDX,DUTDX,DNOPDX,JACOBI,ELM1TK,
     &                  VRB2,VRBIG,STRIPS)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM520   compute element matrices for inner elements         ***
C**             (CLASS=DIM).                                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           GROUP,NE,NK,NK2,GEO1,GEOTYP,
     &                  NRSP,NRVP,RVP1,TOTNT,LEAD,U1,U2,
     &                  NISP,NIVP,IVP1,DIM,NN,NRHS,ELM1,SLICE,
     &                  PILE,NQ,VRB2,STRIPS,NOP1,NOP,ELM1T,ELM1TK

      INTEGER           ISPARM(NISP),GEONEK(GEO1,GEOTYP),
     &                  IVPARM(IVP1,NIVP),NELTYP(NK2)

      DOUBLE PRECISION  T,ALPHA,RSPARM(NRSP),RVPARM(RVP1,NRVP),
     &                  NOD(NN,DIM),U(U1,U2),UT(U1,U2),
     &                  NOPARM(NOP1,NOP),
     &                  RHSEM(LEAD,PILE),EM(LEAD,SLICE),WQ(NQ),
     &                  S(GEOTYP,NQ),DSDV(GEOTYP,DIM,NQ),
     &                  N(TOTNT,NQ),DNDV(TOTNT,DIM,NQ),
     &                  NTE(TOTNT,NQ),DNTEDV(TOTNT,DIM,NQ),
     &                  X(ELM1,DIM),UU(ELM1,NK),UUT(ELM1T,NK),
     &                  DNTEDX(ELM1,TOTNT,DIM),DUDX(ELM1,NK,DIM),
     &                  DUTDX(ELM1T,NK,DIM),
     &                  ENOP(ELM1,NOP),DNOPDX(ELM1,NOP,DIM),
     &                  JACOBI(ELM1),VRBIG(ELM1,VRB2)

      LOGICAL           MASKL(NK,NK),MASKF(NK,NRHS),SYM

      EXTERNAL          USERF,USERK,USERL
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I current time step
C--------I------I-----I------------------------------------------------
C ALPHA  I  R   I in  I weight for bilinear form K
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I in  I id of current group
C--------I------I-----I------------------------------------------------
C NE     I  I   I in  I number of elements in group
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number solution components
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes for proposal functions
C        I      I     I                              array: NELTYP(NK2)
C--------I------I-----I------------------------------------------------
C TOTNT  I  I   I in  I total number of nodes for proposal functions
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of geometrical nodes
C--------I------I-----I------------------------------------------------
C GEONEK I  I   I in  I list of geometrical nodes in the element
C        I      I     I                      array: GEONEK(GEO1,GEOTYP)
C--------I------I-----I------------------------------------------------
C RSPARM I  R   I in  I real scalar parameters       array: RSPARM(NRSP)
C--------I------I-----I------------------------------------------------
C RVPARM I  R   I in  I real vector parameters  array: RVPARM(RVP1,NRVP)
C--------I------I-----I------------------------------------------------
C ISPARM I  I   I in  I integer scalar parameters    array: ISPARM(NISP)
C--------I------I-----I------------------------------------------------
C IVPARM I  I   I in  I integer vector parameters
C        I      I     I                         array: IVPARM(IVP1,NIVP)
C--------I------I-----I------------------------------------------------
C NOPARM I  R   I in  I node parameters          array: NOPARM(NOP1,NOP)
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I node coordinates              array: NOD(NN,DIM)
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I solution at element nodes        array: U(U1,U2)
C--------I------I-----I------------------------------------------------
C UT     I  R   I in  I T-derivative of solution at element nodes
C        I      I     I only defined if ELM1T>=ELM1     array: UT(U1,U2)
C--------I------I-----I------------------------------------------------
C SYM    I  L   I in  I symmetry flag
C--------I------I-----I------------------------------------------------
C MASKL  I  L   I in  I mask of couplings in bilinear forms L and K
C        I      I     I                             array: MASKL(NK,NK)
C--------I------I-----I------------------------------------------------
C USERL  I EX   I in  I routine to define bilinear form L
C--------I------I-----I------------------------------------------------
C USERK  I EX   I in  I routine to define bilinear form K
C--------I------I-----I------------------------------------------------
C NRHS   I  I   I in  I number of right hand sides
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I mask of contributions in functional F
C        I      I     I                           array: MASKF(NK,NRHS)
C--------I------I-----I------------------------------------------------
C USERF  I EX   I in  I routine to define functional F
C--------I------I-----I------------------------------------------------
C ELM1   I  I   I in  I maximal number of elements in a stripe
C--------I------I-----I------------------------------------------------
C EM     I  R   I i/o I element matrices          array: EM(LEAD,SLICE)
C--------I------I-----I------------------------------------------------
C RHSEM  I  R   I i/o I element matrices of right hand side
C        I      I     I                         array: RHSEM(LEAD,PILE)
C--------I------I-----I------------------------------------------------
C NQ     I  I   I in  I number of integration nodes
C--------I------I-----I------------------------------------------------
C WQ     I  R   I in  I integration weigth                array: WQ(NQ)
C--------I------I-----I------------------------------------------------
C S      I  R   I in  I shape functions at integration nodes
C        I      I     I                             array: S(GEOTYP,NQ)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I in  I derivatives of shape functions at integration 
C        I      I     I nodes                array: DSDV(GEOTYP,DIM,NQ)
C--------I------I-----I------------------------------------------------
C N      I  R   I in  I proposal functions at integration nodes
C        I      I     I                              array: N(TOTNT,NQ)
C--------I------I-----I------------------------------------------------
C DNDV   I  R   I in  I derivatives of proposal functions at integration 
C        I      I     I nodes                 array: DNDV(TOTNT,DIM,NQ)
C--------I------I-----I------------------------------------------------
C NTE    I  R   I in  I test functions at integration nodes
C        I      I     I                           array:  NTE(TOTNT,NQ)
C--------I------I-----I------------------------------------------------
C DNTEDV I  R   I in  I derivatives of test functions at integration
C        I      I     I nodes               array: DNTEDV(TOTNT,DIM,NQ)
C--------I------I-----I------------------------------------------------
C X      I  R   I  -  I coordinates in the elements  array: X(ELM1,DIM)
C--------I------I-----I------------------------------------------------
C UU     I  R   I  -  I solution in the elements     array: UU(ELM1,NK)
C--------I------I-----I------------------------------------------------
C ELM1T  I  I   I in  I ELM1T=ELM1 indicates T-dependend problems
C--------I------I-----I------------------------------------------------
C UUT    I  R   I  -  I T-derivative of the solution at elements
C        I      I     I                            array: UUT(ELM1T,NK)
C--------I------I-----I------------------------------------------------
C ENOP   I  R   I  -  I node parameters at the elements
C        I      I     I                           array: ENOP(ELM1,NOP)
C--------I------I-----I------------------------------------------------
C DNTEDX I  R   I  -  I derivatives of test functions at the elements
C        I      I     I                   array: DNTEDX(ELM1,TOTNT,DIM)
C--------I------I-----I------------------------------------------------
C DUDX   I  R   I  -  I derivatives of solution at elements
C        I      I     I                        array: DUDX(ELM1,NK,DIM)
C--------I------I-----I------------------------------------------------
C DUTDX  I  R   I  -  I derivatives of T-derivative of solution at 
C        I      I     I elements             array: DUTDX(ELM1T,NK,DIM)
C--------I------I-----I------------------------------------------------ 
C DNOPDX I  R   I  -  I derivatives of node parameters at elements
C        I      I     I                     array: DNOPDX(ELM1,NOP,DIM)
C--------I------I-----I------------------------------------------------ 
C JACOBI I  R   I  -  I jacobean determinantes of element
C        I      I     I representation              array: JACOBI(ELM1)
C--------I------I-----I------------------------------------------------ 
C ELM1TK I  I   I in  I ELM1TK=ELM1 indicates evaluation of K
C--------I------I-----I------------------------------------------------ 
C VRB2   I  R   I in  I SLICE=0    =>VRB2>=MAX(DIM*DIM+MAX(NOP,NK)*DIM,
C        I      I     I                                          DIM+1)
C        I      I     I ELM1TK=0   =>VRB2>=MAX(DIM*DIM+MAX(NOP,NK)*DIM,
C        I      I     I                            2*(DIM*DIM+2*DIM+1))
C        I      I     I ELM1TK=ELM1=>VRB2>=MAX(DIM*DIM+MAX(NOP,NK)*DIM,
C        I      I     I                            2*(DIM*DIM+2*DIM+1))
C--------I------I-----I------------------------------------------------ 
C VRBIG  I  R   I  -  I real work space         array: VRBIG(ELM1,VRB2)
C--------I------I-----I------------------------------------------------ 
C STRIPS I  I   I out I number of stripes
C--------I------I-----I------------------------------------------------ 
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,I,NELIS,LAST,
     &                  DXDV,DXDV1,DXDV2,DXDV3,DVDX,
     &                  DUDV,DUDV1,DUDV2,DUDV3,
     &                  DUTDV,DUTDV1,DUTDV2,DUTDV3,
     &                  DNPDV,DNPDV1,DNPDV2,DNPDV3,
     &                  L3,L2,L1,L0,K3,K2,K1,K0,F1,F0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LAST=0
      STRIPS=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start stripe loop:                                            ***
C**   ------------------                                            ***
C**                                                                 ***
C**  NELIS-number of elements in current stripe                     ***
C**  LAST -already processed elements                               ***
C**                                                                 ***
1000  CONTINUE
      NELIS=MIN(ELM1,NE-LAST)
      STRIPS=STRIPS+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of integration loop:                                    ***
C**   -------------------------                                     ***
C**                                                                 ***
      DO 10 I=1,NQ
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the element representation:                         ***
C**     ----------------------------------                          ***
C**                                                                 ***
C**     VRBIG(*,1),....,VRBIG(DIM*DIM) are the derivatives          ***
C**     of the representation at the reference element.             ***
C**                                                                 ***
        DXDV=1
        DXDV1=DXDV
        DXDV2=DXDV1+DIM
        DXDV3=DXDV2+DIM

        IF (DIM.EQ.3) THEN
          CALL VEM904(NELIS,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &                S(1,I),DSDV(1,1,I),DSDV(1,2,I),DSDV(1,3,I),
     &                X,VRBIG(1,DXDV1),VRBIG(1,DXDV2),VRBIG(1,DXDV3))
        ENDIF
        IF (DIM.EQ.2) THEN
          CALL VEM903(NELIS,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &                S(1,I),DSDV(1,1,I),DSDV(1,2,I),
     &                X,VRBIG(1,DXDV1),VRBIG(1,DXDV2))
        ENDIF
        IF (DIM.EQ.1) THEN
          CALL VEM902(NELIS,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &                S(1,I),DSDV(1,1,I),X,VRBIG(1,DXDV1))
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute jacobi detreminante of the representation and the   ***
C**     jacobi matrix of its invers mapping:                        ***
C**     ---------------------------------------------------------   ***
C**                                                                 ***
        CALL VEM910(NELIS,DIM,ELM1,VRBIG(1,DXDV),JACOBI)
C**                                                                 ***
C**     now VRBIG(*,1),...,VRBIG(*,DIM*DIM) are the derivatives     ***
C**     of the invers of the element representation.                ***
C**                                                                 ***
        DVDX=DXDV

        DO 100 Z=1,NELIS
          JACOBI(Z)=WQ(I)*JACOBI(Z)
 100    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute derivative of test functions on element :           ***
C**     -----------------------------------------------             ***
C**                                                                 ***
        CALL VEM920(NELIS,DIM,DIM,ELM1,VRBIG(1,1),
     &              TOTNT,DNTEDV(1,1,I),DNTEDX)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the solution and its derivatives on reference       ***
C**     element :                                                   ***
C**     -----------------------------------------------------       ***
C**                                                                 ***
C**     VRBIG(*,DUDV),....,VRBIG(*,DUDV-1+NK*DIM) are the           ***
C**     derivatives of the solution on the reference element        ***
C**                                                                 ***
        DUDV=DVDX+DIM*DIM

        DUDV1=DUDV
        DUDV2=DUDV1+NK
        DUDV3=DUDV2+NK

        IF (DIM.EQ.3) THEN
         CALL VEM909(NELIS,LAST+1,NK,U1,U2,U,NK2,NELTYP,TOTNT,ELM1,
     &               N(1,I),DNDV(1,1,I),DNDV(1,2,I),DNDV(1,3,I),
     &               UU,VRBIG(1,DUDV1),VRBIG(1,DUDV2),VRBIG(1,DUDV3))
        ENDIF
        IF (DIM.EQ.2) THEN
         CALL VEM908(NELIS,LAST+1,NK,U1,U2,U,NK2,NELTYP,TOTNT,ELM1,
     &               N(1,I),DNDV(1,1,I),DNDV(1,2,I),
     &               UU,VRBIG(1,DUDV1),VRBIG(1,DUDV2))
        ENDIF
        IF (DIM.EQ.1) THEN
         CALL VEM907(NELIS,LAST+1,NK,U1,U2,U,NK2,NELTYP,TOTNT,ELM1,
     &               N(1,I),DNDV(1,1,I),UU,VRBIG(1,DUDV1))
        ENDIF
C**                                                                 ***
C****** compute derivatives of solution on element :                ***
C**                                                                 ***
        CALL VEM922(NELIS,DIM,DIM,ELM1,VRBIG(1,DVDX),NK,
     &              VRBIG(1,DUDV),DUDX)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the t-derivative of the solution and its            ***
C**                     its derivatives on the reference element :  ***
C**     --------------------------------------------------------    ***
C**                                                                 ***
        IF (ELM1T.GE.ELM1) THEN
C**                                                                 ***
C**     VRBIG(*,DUTDV),....,VRBIG(*,DUTDV-1+NK*DIM) are the         ***
C**     derivatives of the T-derivative of the solution on the      ***
C**     reference element.                                          ***
C**                                                                 ***
          DUTDV=DVDX+DIM*DIM

          DUTDV1=DUTDV
          DUTDV2=DUTDV1+NK
          DUTDV3=DUTDV2+NK

          IF (DIM.EQ.3) THEN
            CALL VEM909(NELIS,LAST+1,NK,U1,U2,UT,
     &                  NK2,NELTYP,TOTNT,ELM1,
     &                  N(1,I),DNDV(1,1,I),DNDV(1,2,I),DNDV(1,3,I),
     &                  UUT,VRBIG(1,DUTDV1),VRBIG(1,DUTDV2),
     &                  VRBIG(1,DUTDV3))
          ENDIF
          IF (DIM.EQ.2) THEN
            CALL VEM908(NELIS,LAST+1,NK,U1,U2,UT,
     &                  NK2,NELTYP,TOTNT,ELM1,
     &                  N(1,I),DNDV(1,1,I),DNDV(1,2,I),
     &                  UUT,VRBIG(1,DUTDV1),VRBIG(1,DUTDV2))
          ENDIF
          IF (DIM.EQ.1) THEN
            CALL VEM907(NELIS,LAST+1,NK,U1,U2,UT,
     &                  NK2,NELTYP,TOTNT,ELM1,
     &                  N(1,I),DNDV(1,1,I),UUT,VRBIG(1,DUTDV1))
          ENDIF
C**                                                                 ***
C**                                                                 ***
C******** compute derivatives of T-derivative of solution           ***
C**                                             on elements :       ***
C**                                                                 ***
          CALL VEM922(NELIS,DIM,DIM,ELM1,VRBIG(1,DVDX),NK,
     &                VRBIG(1,DUTDV),DUTDX)

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the node parameters and                             ***
C**                     their derivatives on reference element :    ***
C**     ------------------------------------------------------      ***
C**                                                                 ***
        IF (NOP.GT.0) THEN
C**                                                                 ***
C**     VRBIG(*,DNPV),....,VRBIG(*,DNPDV-1+NOP*DIM) are the         ***
C**     derivatives of the node parameters on the reference element.***
C**                                                                 ***
          DNPDV=DVDX+DIM*DIM

          DNPDV1=DNPDV
          DNPDV2=DNPDV1+NOP
          DNPDV3=DNPDV2+NOP

          IF (DIM.EQ.3) THEN
          CALL VEM904(NELIS,LAST+1,NOP,NOP1,NOPARM,GEO1,GEOTYP,GEONEK,
     &                ELM1,S(1,I),DSDV(1,1,I),DSDV(1,2,I),DSDV(1,3,I),
     &                ENOP,VRBIG(1,DNPDV1),
     &                VRBIG(1,DNPDV2),VRBIG(1,DNPDV3))
          ENDIF

          IF (DIM.EQ.2) THEN
          CALL VEM903(NELIS,LAST+1,NOP,NOP1,NOPARM,GEO1,GEOTYP,GEONEK,
     &                ELM1,S(1,I),DSDV(1,1,I),DSDV(1,2,I),
     &                ENOP,VRBIG(1,DNPDV1),VRBIG(1,DNPDV2))
          ENDIF

          IF (DIM.EQ.1) THEN
          CALL VEM902(NELIS,LAST+1,NOP,NOP1,NOPARM,GEO1,GEOTYP,GEONEK,
     &                ELM1,S(1,I),DSDV(1,1,I),ENOP,VRBIG(1,DNPDV1))
          ENDIF
C**                                                                 ***
C******** compute derivatives of node parameters on elements :      ***
C**                                                                 ***
          CALL VEM922(NELIS,DIM,DIM,ELM1,VRBIG(1,DVDX),NOP,
     &                VRBIG(1,DNPDV),DNOPDX)

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** add element matrix :                                        ***
C**     --------------------                                        ***
C**                                                                 ***
        IF (SLICE.GT.0) THEN

          L3=1
          L2=L3+DIM*DIM
          L1=L2+DIM
          L0=L1+DIM
          IF (ELM1TK.GE.ELM1) THEN
            K3=L0+1
            K2=K3+DIM*DIM
            K1=K2+DIM
            K0=K1+DIM
          ELSE
            K3=L0
            K2=K3
            K1=K2
            K0=K1
          ENDIF

          IF (SYM) THEN
            CALL VEM535(T,ALPHA,GROUP,DIM,NK,NK2,NELTYP,TOTNT,
     &                  NELIS,LAST,NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  MASKL,USERL,USERK,ELM1,LEAD,SLICE,EM,
     &                  NTE(1,I),DIM,X,UU,ELM1T,UUT,NOP,ENOP,
     &                  DNTEDX,VRBIG(1,DXDV),DUDX,DUTDX,DNOPDX,JACOBI,
     &                  VRBIG(1,L3),VRBIG(1,L2),VRBIG(1,L1),VRBIG(1,L0),
     &                  ELM1TK,
     &                  VRBIG(1,K3),VRBIG(1,K2),VRBIG(1,K1),VRBIG(1,K0))
          ELSE
            CALL VEM534(T,ALPHA,GROUP,DIM,NK,NK2,NELTYP,TOTNT,
     &                  NELIS,LAST,NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  MASKL,USERL,USERK,ELM1,LEAD,SLICE,EM,
     &                  NTE(1,I),DIM,X,UU,ELM1T,UUT,NOP,ENOP,
     &                  DNTEDX,VRBIG(1,DXDV),DUDX,DUTDX,DNOPDX,JACOBI,
     &                  VRBIG(1,L3),VRBIG(1,L2),VRBIG(1,L1),VRBIG(1,L0),
     &                  ELM1TK,
     &                  VRBIG(1,K3),VRBIG(1,K2),VRBIG(1,K1),VRBIG(1,K0))
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** add rhs element matrix:                                     ***
C**     ----------------------                                      ***
C**                                                                 ***
        IF (PILE.GT.0) THEN
          F1=1
          F0=F1+DIM

          CALL VEM530(T,GROUP,DIM,NK,NK2,NELTYP,TOTNT,NELIS,LAST,
     &                NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                NRHS,MASKF,USERF,ELM1,LEAD,PILE,RHSEM,
     &                NTE(1,I),DIM,X,UU,ELM1T,UUT,NOP,ENOP,
     &                DNTEDX,VRBIG(1,DXDV),DUDX,DUTDX,DNOPDX,JACOBI,
     &                VRBIG(1,F1),VRBIG(1,F0))
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of integration loop :                                     ***
C**   ----------------------                                        ***
C**                                                                 ***
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** next stripe :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      LAST=LAST+NELIS
      IF (LAST.LT.NE) GOTO 1000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM520----------------------------------------------------
      E    N    D
