C:::::      ,,,,,VEM522...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM522(T,ALPHA,GROUP,NE,NK,NK2,NELTYP,
     &                  TOTNT,GEO1,GEOTYP,GEONEK,
     &                  NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  NOP1,NOP,NOPARM,NN,NOD,
     &                  U1,U2,U,UT,SYM,MASKL,USERL,USERK,
     &                  NRHS,MASKF,USERF,ELM1,LEAD,SLICE,EM,PILE,RHSEM,
     &                  NQ,WQ,S,DSDV,N,DNDV,NTE,DNTEDV,
     &                  X,UU,ELM1T,UUT,ENOP,
     &                  TAU,DNTEDX,DUDX,DUTDX,DNOPDX,DA,ELM1TK,
     &                  VRB2,VRBIG,STRIPS)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM522       compute element matrices of area elements     ***
C**                   (CLASS=2,DIM=3).                              ***
C**                   derivative means derivative with respect to   ***
C**                   the tangential unit vectors.                  ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           GROUP,NE,NK,NK2,NRSP,NRVP,RVP1,
     &                  TOTNT,GEOTYP,GEO1,U1,U2,
     &                  NISP,NIVP,IVP1,NN,NRHS,ELM1,SLICE,LEAD,
     &                  PILE,NQ,VRB2,STRIPS,NOP1,NOP,ELM1T,ELM1TK

      INTEGER           ISPARM(NISP),GEONEK(GEO1,GEOTYP),
     &                  IVPARM(IVP1,NIVP),NELTYP(NK2)

      DOUBLE PRECISION  T,ALPHA,RSPARM(NRSP),RVPARM(RVP1,NRVP),
     &                  NOD(NN,3),U(U1,U2),UT(U1,U2),NOPARM(NOP1,NOP),
     &                  RHSEM(LEAD,PILE),EM(LEAD,SLICE),WQ(NQ),
     &                  S(GEOTYP,NQ),DSDV(GEOTYP,2,NQ),
     &                  N(TOTNT,NQ),DNDV(TOTNT,2,NQ),
     &                  NTE(TOTNT,NQ),DNTEDV(TOTNT,2,NQ),
     &                  X(ELM1,3),TAU(ELM1,3,2),
     &                  UU(ELM1,NK),UUT(ELM1T,NK),
     &                  DNTEDX(ELM1,TOTNT,2),DUDX(ELM1,NK,2),
     &                  DUTDX(ELM1T,NK,2),
     &                  ENOP(ELM1,NOP),DNOPDX(ELM1,NOP,2),
     &                  DA(ELM1),VRBIG(ELM1,VRB2)

      LOGICAL           MASKL(NK,NK),MASKF(NK,NRHS),SYM

      EXTERNAL          USERF,USERK,USERL
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I current time step
C--------I------I-----I------------------------------------------------
C ALPHA  I  R   I in  I weight for bilinear form K
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I in  I id of current group
C--------I------I-----I------------------------------------------------
C NE     I  I   I in  I number of elements in group
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number solution components
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes for proposal functions
C        I      I     I                              array: NELTYP(NK2)
C--------I------I-----I------------------------------------------------
C TOTNT  I  I   I in  I total number of nodes for proposal functions
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of geometrical nodes
C--------I------I-----I------------------------------------------------
C GEONEK I  I   I in  I list of geometrical nodes in the element
C        I      I     I                      array: GEONEK(GEO1,GEOTYP)
C--------I------I-----I------------------------------------------------
C RSPARM I  R   I in  I real scalar parameters       array: RSPARM(NRSP)
C--------I------I-----I------------------------------------------------
C RVPARM I  R   I in  I real vector parameters  array: RVPARM(RVP1,NRVP)
C--------I------I-----I------------------------------------------------
C ISPARM I  I   I in  I integer scalar parameters    array: ISPARM(NISP)
C--------I------I-----I------------------------------------------------
C IVPARM I  I   I in  I integer vector parameters
C        I      I     I                         array: IVPARM(IVP1,NIVP)
C--------I------I-----I------------------------------------------------
C NOPARM I  R   I in  I node parameters          array: NOPARM(NOP1,NOP)
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I node coordinates                array: NOD(NN,3)
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I solution at element nodes        array: U(U1,U2)
C--------I------I-----I------------------------------------------------
C UT     I  R   I in  I T-derivative of solution at element nodes
C        I      I     I only defined if ELM1T>=ELM1     array: UT(U1,U2)
C--------I------I-----I------------------------------------------------
C SYM    I  L   I in  I symmetry flag
C--------I------I-----I------------------------------------------------
C MASKL  I  L   I in  I mask of couplings in bilinear forms L and K
C        I      I     I                             array: MASKL(NK,NK)
C--------I------I-----I------------------------------------------------
C USERL  I EX   I in  I routine to define bilinear form L
C--------I------I-----I------------------------------------------------
C USERK  I EX   I in  I routine to define bilinear form K
C--------I------I-----I------------------------------------------------
C NRHS   I  I   I in  I number of right hand sides
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I mask of contributions in functional F
C        I      I     I                           array: MASKF(NK,NRHS)
C--------I------I-----I------------------------------------------------
C USERF  I EX   I in  I routine to define functional F
C--------I------I-----I------------------------------------------------
C ELM1   I  I   I in  I maximal number of elements in a stripe
C--------I------I-----I------------------------------------------------
C EM     I  R   I i/o I element matrices          array: EM(LEAD,SLICE)
C--------I------I-----I------------------------------------------------
C RHSEM  I  R   I i/o I element matrices of right hand side
C        I      I     I                         array: RHSEM(LEAD,PILE)
C--------I------I-----I------------------------------------------------
C NQ     I  I   I in  I number of integration nodes
C--------I------I-----I------------------------------------------------
C WQ     I  R   I in  I integration weigth                array: WQ(NQ)
C--------I------I-----I------------------------------------------------
C S      I  R   I in  I shape functions at integration nodes
C        I      I     I                             array: S(GEOTYP,NQ)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I in  I derivatives of shape functions at integration 
C        I      I     I nodes                  array: DSDV(GEOTYP,2,NQ)
C--------I------I-----I------------------------------------------------
C N      I  R   I in  I proposal functions at integration nodes
C        I      I     I                              array: N(TOTNT,NQ)
C--------I------I-----I------------------------------------------------
C DNDV   I  R   I in  I derivatives of proposal functions at integration 
C        I      I     I nodes                   array: DNDV(TOTNT,2,NQ)
C--------I------I-----I------------------------------------------------
C NTE    I  R   I in  I test functions at integration nodes
C        I      I     I                           array:  NTE(TOTNT,NQ)
C--------I------I-----I------------------------------------------------
C DNTEDV I  R   I in  I derivatives of test functions at integration
C        I      I     I nodes                 array: DNTEDV(TOTNT,2,NQ)
C--------I------I-----I------------------------------------------------
C X      I  R   I  -  I coordinates in the elements    array: X(ELM1,3)
C--------I------I-----I------------------------------------------------
C UU     I  R   I  -  I solution in the elements     array: UU(ELM1,NK)
C--------I------I-----I------------------------------------------------
C ELM1T  I  I   I in  I ELM1T=ELM1 indicates T-dependend problems
C--------I------I-----I------------------------------------------------
C UUT    I  R   I  -  I T-derivative of the solution at elements
C        I      I     I                            array: UUT(ELM1T,NK)
C--------I------I-----I------------------------------------------------
C ENOP   I  R   I  -  I node parameters at the elements
C        I      I     I                           array: ENOP(ELM1,NOP)
C--------I------I-----I------------------------------------------------
C TAU    I  R   I -   I directions in the tangential hyperspace =
C        I      I     I =normalized derivative of element representation
C        I      I     I                            array: TAU(ELM1,3,2)
C--------I------I-----I------------------------------------------------
C DNTEDX I  R   I  -  I derivatives of test functions at the elements
C        I      I     I                     array: DNTEDX(ELM1,TOTNT,2)
C--------I------I-----I------------------------------------------------
C DUDX   I  R   I  -  I derivatives of solution at elements
C        I      I     I                          array: DUDX(ELM1,NK,2)
C--------I------I-----I------------------------------------------------
C DUTDX  I  R   I  -  I derivatives of T-derivative of solution at 
C        I      I     I elements               array: DUTDX(ELM1T,NK,2)
C--------I------I-----I------------------------------------------------ 
C DNOPDX I  R   I  -  I derivatives of node parameters at elements
C        I      I     I                       array: DNOPDX(ELM1,NOP,2)
C--------I------I-----I------------------------------------------------ 
C JACOBI I  R   I  -  I jacobean determinantes of element
C        I      I     I representation              array: JACOBI(ELM1)
C--------I------I-----I------------------------------------------------ 
C ELM1TK I  I   I in  I ELM1TK=ELM1 indicates evaluation of K
C--------I------I-----I------------------------------------------------ 
C VRB2   I  R   I in  I SLICE=0    =>VRB2>=3
C        I      I     I ELM1TK=0   =>VRB2>=9
C        I      I     I ELM1TK=ELM1=>VRB2>=18
C--------I------I-----I------------------------------------------------ 
C VRBIG  I  R   I  -  I real work space         array: VRBIG(ELM1,VRB2)
C--------I------I-----I------------------------------------------------ 
C STRIPS I  I   I out I number of stripes
C--------I------I-----I------------------------------------------------ 
C**                                                                 ***
C**   LOCAL VARIABLES :                                             ***
C**   ------------------                                            ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,I,J,NELIS,LAST,CLASS,DIM
      INTEGER           NORM1,NORM2,L3,L2,L1,L0,K3,K2,K1,K0,F1,F0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LAST=0
      STRIPS=0
      CLASS=2
      DIM=3
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of stripe loop:                                         ***
C**   --------------------                                          ***
C**                                                                 ***
C**  NELIS    number of elements in current stripe                  ***
C**  LAST     last element in last stripe                           ***
C**                                                                 ***
C**                                                                 ***
1000  CONTINUE
      NELIS=MIN(ELM1,NE-LAST)
      STRIPS=STRIPS+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of integration loop:                                    ***
C**   -------------------------                                     ***
C**                                                                 ***
      DO 10 I=1,NQ
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the representation of the elements:                 ***
C**     ------------------------------------------                  ***
C**                                                                 ***
        CALL VEM903(NELIS,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &              S(1,I),DSDV(1,1,I),DSDV(1,2,I),
     &              X,TAU(1,1,1),TAU(1,1,2))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the area element and the tagential unit vectors:    ***
C**     -------------------------------------------------------     ***
C**                                                                 ***
        NORM1=1
        NORM2=NORM1+1

        CALL VEM915(NELIS,ELM1,TAU(1,1,1),VRBIG(1,NORM1),
     &              TAU(1,1,2),VRBIG(1,NORM2),DA)

        DO 100 Z=1,NELIS
          DA(Z)=WQ(I)*DA(Z)
 100    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** derivative of test function on elements:                    ***
C**     ---------------------------------------                     ***
C**                                                                 ***
        DO 101 J=1,TOTNT
          DO 101 Z=1,NELIS
            DNTEDX(Z,J,1)=VRBIG(Z,NORM1)*DNTEDV(J,1,I)
            DNTEDX(Z,J,2)=VRBIG(Z,NORM2)*DNTEDV(J,2,I)
 101    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the solution and its derivatives on elements :      ***
C**     ----------------------------------------------------        ***
C**                                                                 ***
        CALL VEM908(NELIS,LAST+1,NK,U1,U2,U,NK2,NELTYP,TOTNT,ELM1,
     &              N(1,I),DNDV(1,1,I),DNDV(1,2,I),
     &              UU,DUDX(1,1,1),DUDX(1,1,2))

        DO 201 J=1,NK
          DO 201 Z=1,NELIS
            DUDX(Z,J,1)=VRBIG(Z,NORM1)*DUDX(Z,J,1)
            DUDX(Z,J,2)=VRBIG(Z,NORM2)*DUDX(Z,J,2)
 201    CONTINUE
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the T-derivative of the solution and                ***
C**                             its derivatives on element :        ***
C**     --------------------------------------------------          ***
C**                                                                 ***
        IF (ELM1T.GE.ELM1) THEN

          CALL VEM908(NELIS,LAST+1,NK,U1,U2,UT,NK2,NELTYP,TOTNT,ELM1,
     &                N(1,I),DNDV(1,1,I),DNDV(1,2,I),
     &                UUT,DUTDX(1,1,1),DUTDX(1,1,2))

          DO 301 J=1,NK
            DO 301 Z=1,NELIS
              DUTDX(Z,J,1)=VRBIG(Z,NORM1)*DUTDX(Z,J,1)
              DUTDX(Z,J,2)=VRBIG(Z,NORM2)*DUTDX(Z,J,2)
 301      CONTINUE

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the node parameters and                             ***
C**                              their derivatives on elements :    ***
C**     ------------------------------------------------------      ***
C**                                                                 ***
        IF (NOP.GT.0) THEN

          CALL VEM903(NELIS,LAST+1,NOP,NOP1,NOPARM,GEO1,GEOTYP,GEONEK,
     &                ELM1,S(1,I),DSDV(1,1,I),DSDV(1,2,I),
     &                ENOP,DNOPDX(1,1,1),DNOPDX(1,1,2))

          DO 401 J=1,NOP
            DO 401 Z=1,NELIS
              DNOPDX(Z,J,1)=VRBIG(Z,NORM1)*DNOPDX(Z,J,1)
              DNOPDX(Z,J,2)=VRBIG(Z,NORM2)*DNOPDX(Z,J,2)
 401      CONTINUE

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** add element matrix :                                        ***
C**     --------------------                                        ***
C**                                                                 ***
        IF (SLICE.GT.0) THEN

          L3=1
          L2=L3+CLASS*CLASS
          L1=L2+CLASS
          L0=L1+CLASS
          IF (ELM1TK.GE.ELM1) THEN
            K3=L0+1
            K2=K3+CLASS*CLASS
            K1=K2+CLASS
            K0=K1+CLASS
          ELSE
            K3=L0
            K2=K3
            K1=K2
            K0=K1
          ENDIF

          IF (SYM) THEN
            CALL VEM535(T,ALPHA,GROUP,CLASS,NK,NK2,NELTYP,TOTNT,
     &                  NELIS,LAST,NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  MASKL,USERL,USERK,ELM1,LEAD,SLICE,EM,
     &                  NTE(1,I),DIM,X,UU,ELM1T,UUT,NOP,ENOP,
     &                  DNTEDX,TAU,DUDX,DUTDX,DNOPDX,DA,
     &                  VRBIG(1,L3),VRBIG(1,L2),VRBIG(1,L1),VRBIG(1,L0),
     &                  ELM1TK,
     &                  VRBIG(1,K3),VRBIG(1,K2),VRBIG(1,K1),VRBIG(1,K0))
          ELSE
            CALL VEM534(T,ALPHA,GROUP,CLASS,NK,NK2,NELTYP,TOTNT,
     &                  NELIS,LAST,NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  MASKL,USERL,USERK,ELM1,LEAD,SLICE,EM,
     &                  NTE(1,I),DIM,X,UU,ELM1T,UUT,NOP,ENOP,
     &                  DNTEDX,TAU,DUDX,DUTDX,DNOPDX,DA,
     &                  VRBIG(1,L3),VRBIG(1,L2),VRBIG(1,L1),VRBIG(1,L0),
     &                  ELM1TK,
     &                  VRBIG(1,K3),VRBIG(1,K2),VRBIG(1,K1),VRBIG(1,K0))
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** add RHS element matrices:                                   ***
C**     ------------------------                                    ***
C**                                                                 ***
        IF (PILE.GT.0) THEN
          F1=1
          F0=F1+CLASS

          CALL VEM530(T,GROUP,CLASS,NK,NK2,NELTYP,TOTNT,NELIS,LAST,
     &                NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                NRHS,MASKF,USERF,ELM1,LEAD,PILE,RHSEM,
     &                NTE(1,I),DIM,X,UU,ELM1T,UUT,NOP,ENOP,
     &                DNTEDX,TAU,DUDX,DUTDX,DNOPDX,DA,
     &                VRBIG(1,F1),VRBIG(1,F0))
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of integration loop:                                      ***
C**   -----------------------                                       ***
C**                                                                 ***
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** next stripe :                                                 ***
C**   -------------                                                 ***
C**                                                                 ***
      LAST=LAST+NELIS
      IF (LAST.LT.NE) GOTO 1000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM522----------------------------------------------------
      E    N    D
