C:::::      ,,,,,VEM524...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM524(T,ALPHA,GROUP,NE,NK,NK2,NELTYP,GEO1,GEONEK,
     &                  NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  NOP1,NOP,NOPARM,DIM,NN,NOD,
     &                  U1,U2,U,UT,SYM,MASKL,USERL,USERK,
     &                  NRHS,MASKF,USERF,ELM1,LEAD,SLICE,EM,PILE,RHSEM,
     &                  X,UU,ELM1T,UUT,ENOP,ELM1TK,
     &                  VRBIG,STRIPS)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM524       compute element matrices for nodal elements   ***
C**                   (CLASS=0).                                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           GROUP,NE,NK,NRSP,NRVP,RVP1,NK2,
     &                  NISP,NIVP,IVP1,DIM,NN,NRHS,LEAD,ELM1,SLICE,
     &                  GEO1,PILE,STRIPS,NOP1,NOP,ELM1T,ELM1TK,U1,U2

      INTEGER           ISPARM(NISP),IVPARM(IVP1,NIVP),
     &                  NELTYP(NK2),GEONEK(GEO1)

      DOUBLE PRECISION  T,ALPHA,RSPARM(NRSP),RVPARM(RVP1,NRVP),
     &                  NOPARM(NOP1,NOP),NOD(NN,DIM),U(U1,U2),
     &                  UT(U1,U2),RHSEM(LEAD,PILE),EM(LEAD,SLICE),
     &                  X(ELM1,DIM),UU(ELM1,NK),UUT(ELM1T,NK),
     &                  ENOP(ELM1,NOP),VRBIG(ELM1T)

      LOGICAL           MASKL(NK,NK),MASKF(NK,NRHS),SYM

      EXTERNAL          USERF,USERL,USERK
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I current time step
C--------I------I-----I------------------------------------------------
C ALPHA  I  R   I in  I weight for bilinear form K
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I in  I id of current group
C--------I------I-----I------------------------------------------------
C NE     I  I   I in  I number of elements in group
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number solution components
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes for proposal functions
C        I      I     I                              array: NELTYP(NK2)
C--------I------I-----I------------------------------------------------
C TOTNT  I  I   I in  I total number of nodes for proposal functions
C--------I------I-----I------------------------------------------------
C GEONEK I  I   I in  I list of geometrical nodes in the element
C        I      I     I                             array: GEONEK(GEO1)
C--------I------I-----I------------------------------------------------
C RSPARM I  R   I in  I real scalar parameters       array: RSPARM(NRSP)
C--------I------I-----I------------------------------------------------
C RVPARM I  R   I in  I real vector parameters  array: RVPARM(RVP1,NRVP)
C--------I------I-----I------------------------------------------------
C ISPARM I  I   I in  I integer scalar parameters    array: ISPARM(NISP)
C--------I------I-----I------------------------------------------------
C IVPARM I  I   I in  I integer vector parameters
C        I      I     I                         array: IVPARM(IVP1,NIVP)
C--------I------I-----I------------------------------------------------
C NOPARM I  R   I in  I node parameters          array: NOPARM(NOP1,NOP)
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I node coordinates              array: NOD(NN,DIM)
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I solution at element nodes        array: U(U1,U2)
C--------I------I-----I------------------------------------------------
C UT     I  R   I in  I T-derivative of solution at element nodes
C        I      I     I only defined if ELM1T>=ELM1     array: UT(U1,U2)
C--------I------I-----I------------------------------------------------
C SYM    I  L   I in  I symmetry flag
C--------I------I-----I------------------------------------------------
C MASKL  I  L   I in  I mask of couplings in bilinear forms L and K
C        I      I     I                             array: MASKL(NK,NK)
C--------I------I-----I------------------------------------------------
C USERL  I EX   I in  I routine to define bilinear form L
C--------I------I-----I------------------------------------------------
C USERK  I EX   I in  I routine to define bilinear form K
C--------I------I-----I------------------------------------------------
C NRHS   I  I   I in  I number of right hand sides
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I mask of contributions in functional F
C        I      I     I   i                       array: MASKF(NK,NRHS)
C--------I------I-----I------------------------------------------------
C USERF  I EX   I in  I routine to define functional F
C--------I------I-----I------------------------------------------------
C ELM1   I  I   I in  I maximal number of elements in a stripe
C--------I------I-----I------------------------------------------------
C EM     I  R   I i/o I element matrices          array: EM(LEAD,SLICE)
C--------I------I-----I------------------------------------------------
C RHSEM  I  R   I i/o I element matrices of right hand side
C        I      I     I   array: RHSEM(LEAD,PILE)
C--------I------I-----I------------------------------------------------
C X      I  R   I  -  I coordinates in the elements  array: X(ELM1,DIM)
C--------I------I-----I------------------------------------------------
C UU     I  R   I  -  I solution in the elements     array: UU(ELM1,NK)
C--------I------I-----I------------------------------------------------
C ELM1T  I  I   I in  I ELM1T=ELM1 indicates T-dependend problems
C--------I------I-----I------------------------------------------------
C UUT    I  R   I  -  I T-derivative of the solution at elements
C        I      I     I                            array: UUT(ELM1T,NK)
C--------I------I-----I------------------------------------------------
C ENOP   I  R   I  -  I node parameters at the elements
C        I      I     I                           array: ENOP(ELM1,NOP)
C--------I------I-----I------------------------------------------------
C ELM1TK I  I   I in  I ELM1TK=ELM1 indicates evaluation of K
C--------I------I-----I------------------------------------------------ 
C VRB2   I  R   I in  I SLICE=0    =>VRB2=0
C        I      I     I ELM1TK=0   =>VRB2=0
C        I      I     I ELM1TK=ELM1=>VRB2=1
C--------I------I-----I------------------------------------------------ 
C VRBIG  I  R   I  -  I real work space         array: VRBIG(ELM1,VRB2)
C--------I------I-----I------------------------------------------------ 
C STRIPS I  I   I out I number of stripes
C--------I------I-----I------------------------------------------------ 
C**                    >                                            ***
      INTEGER           NELIS,LAST,GEOTYP,CLASS
      INTEGER           Z,J,I,S
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LAST=0
      STRIPS=0
      GEOTYP=1
      CLASS=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of stripe loop:                                         ***
C**   --------------------                                          ***
C**                                                                 ***
C**  NELIS    number of elements in current stripe                  ***
C**  LAST     last element in last stripe                           ***
C**                                                                 ***
1000  CONTINUE
      NELIS=MIN(ELM1,NE-LAST)
      STRIPS=STRIPS+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch coordinates of nodes :                                  ***
C**   ---------------------------                                   ***
C**                                                                 ***
      DO 10 I=1,DIM
        DO 10 Z=1,NELIS
          X(Z,I)=NOD(GEONEK(LAST+Z),I)
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch solution at nodes :                                     ***
C**   -----------------------                                       ***
C**                                                                 ***
      S=0
      DO 20 I=1,NK
	IF (NELTYP(MIN(I,NK2)).GT.0) THEN
          DO 21 Z=1,NELIS
            UU(Z,I)=U(LAST+Z,S+1)
  21      CONTINUE
        ENDIF
        S=NELTYP(MIN(I,NK2))+S
20    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch T-derivative of solution at nodes :                     ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      IF (ELM1T.GE.ELM1) THEN
        S=0
        DO 30 I=1,NK
	  IF (NELTYP(MIN(I,NK2)).GT.0) THEN
            DO 31 Z=1,NELIS
              UUT(Z,I)=UT(LAST+Z,S+1)
  31        CONTINUE
          ENDIF
          S=NELTYP(MIN(I,NK2))+S
30      CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch node parameters at nodes:                               ***
C**   ------------------------------                                ***
C**                                                                 ***
      DO 40 I=1,NOP
        DO 40 Z=1,NELIS
          ENOP(Z,I)=NOPARM(GEONEK(LAST+Z),I)
40    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set upper triangle element matrix :                           ***
C**   ---------------------------------                             ***
C**                                                                 ***
      S=0
      DO 50 I=1,NK
        DO 50 J=1,I
          IF (MASKL(J,J-I+NK)) THEN
            S=S+1

            DO 57 Z=1,NELIS
              VRBIG(Z)=0.0
  57        CONTINUE

            CALL USERL(T,GROUP,CLASS,J,J-I+NK,LAST,
     &                  NELIS,ELM1,DIM,X,X,NK,UU,UU,
     &                  ELM1T,UUT,UUT,NOP,ENOP,ENOP,
     &                  NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  VRBIG,VRBIG,VRBIG,VRBIG)
            DO 56 Z=1,NELIS
              EM(LAST+Z,S)=EM(LAST+Z,S)+VRBIG(Z)
  56        CONTINUE

            IF (ELM1TK.GE.ELM1) THEN

              DO 51 Z=1,NELIS
                VRBIG(Z)=0.0
  51          CONTINUE

              CALL USERK(T,GROUP,CLASS,J,J-I+NK,LAST,
     &                    NELIS,ELM1,DIM,X,X,NK,UU,UU,
     &                    ELM1T,UUT,UUT,NOP,ENOP,ENOP,
     &                    NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                    NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                    VRBIG,VRBIG,VRBIG,VRBIG)
	      DO 55 Z=1,NELIS
                EM(LAST+Z,S)=EM(LAST+Z,S)+ALPHA*VRBIG(Z)
  55          CONTINUE

            ENDIF

          ENDIF
50    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set lower triangle element matrix :                           ***
C**   ---------------------------------                             ***
C**                                                                 ***
      IF (.NOT.SYM) THEN
        DO 60 I=1,NK-1
          DO 60 J=1,NK-I
            IF (MASKL(J+I,J)) THEN
              S=S+1

              DO 67 Z=1,NELIS
                VRBIG(Z)=0.0
  67          CONTINUE

              CALL USERL(T,GROUP,CLASS,J+I,J,LAST,
     &                   NELIS,ELM1,DIM,X,X,NK,UU,UU,
     &                   ELM1T,UUT,UUT,NOP,ENOP,ENOP,
     &                   NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                   NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                   VRBIG,VRBIG,VRBIG,VRBIG)
	       DO 66 Z=1,NELIS
                 EM(LAST+Z,S)=EM(LAST+Z,S)+VRBIG(Z)
  66           CONTINUE

              IF (ELM1TK.GE.ELM1) THEN

                DO 61 Z=1,NELIS
                  VRBIG(Z)=0.0
  61            CONTINUE

                CALL USERK(T,GROUP,CLASS,J+I,J,LAST,
     &                      NELIS,ELM1,DIM,X,X,NK,UU,UU,
     &                      ELM1T,UUT,UUT,NOP,ENOP,ENOP,
     &                      NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                      NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                      VRBIG,VRBIG,VRBIG,VRBIG)
                DO 65 Z=1,NELIS
                  EM(LAST+Z,S)=EM(LAST+Z,S)+ALPHA*VRBIG(Z)
  65            CONTINUE

              ENDIF

            ENDIF
60      CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set rhs element matrix :                                      ***
C**   ----------------------                                        ***
C**                                                                 ***
      S=0
      DO 70 I=1,NRHS
        DO 70 J=1,NK
          IF (MASKF(J,I)) THEN
            S=S+1
	
            DO 77 Z=1,NELIS
              VRBIG(Z)=0.0
  77        CONTINUE

            CALL USERF(T,GROUP,CLASS,J,I,LAST,
     &                  NELIS,ELM1,DIM,X,X,NK,UU,UU,
     &                  ELM1T,UUT,UUT,NOP,ENOP,ENOP,
     &                  NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  VRBIG,VRBIG)
	     DO 76 Z=1,NELIS
               RHSEM(LAST+Z,S)=RHSEM(LAST+Z,S)+VRBIG(Z)
  76         CONTINUE
          ENDIF
70      CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** next stripe :                                                 ***
C**   -----------                                                   ***
C**                                                                 ***
      LAST=LAST+NELIS
      IF (LAST.LT.NE) GOTO 1000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM524----------------------------------------------------
      E    N    D
