C:::::      ,,,,,VEM530...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM530(T,GROUP,CLASS,NK,NK2,NELTYP,TOTNT,NELIS,LAST,
     &                  NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  NRHS,MASKF,USERF,ELM1,LEAD,PILE,RHSEM,
     &                  NTE,DIM,X,U,ELM1T,UT,NOP,ENOP,
     &                  DNTEDX,TAU,DUDX,DUTDX,DNOPDX,JACOBI,F1,F0)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM530  add the evaluation of linear functionals at one    ***
C**              integration node to the element matrices           ***
C**              for one stripe.                                    ***
C**              ELM1T>=ELM1 marks the parabolic case.              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           GROUP,CLASS,NK,NK2,TOTNT,NELIS,LAST,
     &                  NRSP,NRVP,RVP1,NISP,NIVP,IVP1,DIM,NRHS,
     &                  ELM1,ELM1T,PILE,NOP,LEAD

      INTEGER           NELTYP(NK2),ISPARM(NISP),IVPARM(IVP1,NIVP)

      DOUBLE PRECISION  T,RSPARM(NRSP),RVPARM(RVP1,NRVP),
     &                  RHSEM(LEAD,PILE),NTE(TOTNT),X(ELM1,DIM),
     &                  U(ELM1,NK),UT(ELM1T,NK),
     &                  ENOP(ELM1,NOP),TAU(ELM1,DIM,CLASS),
     &                  DNTEDX(ELM1,TOTNT,CLASS),
     &                  DNOPDX(ELM1,NOP,CLASS),
     &                  DUDX(ELM1,NK,CLASS),DUTDX(ELM1T,NK,DIM),
     &                  JACOBI(ELM1),F0(ELM1),F1(ELM1,CLASS)

      LOGICAL           MASKF(NK,NRHS)

      EXTERNAL          USERF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I current time
C--------I------I-----I-----------------------------------------------
C GROUP  I  I   I in  I current group
C--------I------I-----I-----------------------------------------------
C CLASS  I  I   I in  I current element class
C--------I------I-----I-----------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes of the proposal functions
C        I      I     I                              array: NELTYP(NK2)
C--------I------I-----I------------------------------------------------
C NELIS  I  I   I in  I number of elements in the current stripe
C--------I------I-----I------------------------------------------------
C LAST   I  I   I in  I last element in last stripe
C--------I------I-----I------------------------------------------------
C NRSP   I  I   I in  I number of real scalar parameters
C--------I------I-----I------------------------------------------------
C RSPARM I  R   I in  I set of real scalar parameters
C        I      I     I                             array: RVPARM(NRSP)
C--------I------I-----I------------------------------------------------
C NRVP   I  I   I in  I number of real vector parameters
C--------I------I-----I------------------------------------------------
C RVPARM I  R   I in  I set of real vector Parameters
C        I      I     I                        array: RVPARM(RVP1,NRVP)
C--------I------I-----I------------------------------------------------
C NISP   I  I   I in  I number of integer scalar parameters
C--------I------I-----I------------------------------------------------
C ISPARM I  I   I in  I set of integer scalar parameters
C        I      I     I                             array: ISPARM(NISP)
C--------I------I-----I------------------------------------------------
C NIVP   I  I   I in  I number of integer vector Parameters
C--------I------I-----I------------------------------------------------
C IVPARM I  I   I in  I set of integer vector parameters :
C        I      I     I                         array: IPARM(IVP1,NIVP)
C--------I------I-----I------------------------------------------------
C NRHS   I  I   I in  I number of linear functional
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I mask of linear functionals array: MASKF(NK,NRHS)
C--------I------I-----I------------------------------------------------
C USERF  I EX   I in  I routine defining linear functionals
C--------I------I-----I------------------------------------------------
C RHSEM  I  R   I i/o I element matrices of linear functionals
C        I      I     I                         array: RHSEM(LEAD,PILE)
C--------I------I-----I------------------------------------------------
C NTE    I  R   I in  I test functions at the integration node
C        I      I     I                               array: NTE(TOTNT)
C--------I------I-----I------------------------------------------------
C X      I  R   I in  I integration node in the elements
C        I      I     I                              array: X(ELM1,DIM)
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I solution at the integration node
C        I      I     I the elements                  array: U(ELM1,NK)
C--------I------I-----I------------------------------------------------
C UT     I  R   I in  I derivative of the solution with respect to
C        I      I     I T at the integration node in the elements
C        I      I     I                            array:  UT(ELM1T,NK)
C--------I------I-----I------------------------------------------------
C ENOP   I  R   I in  I node parameters interpolated to integration node
C        I      I     I in the elements          array:  ENOP(ELM1,NOP)
C--------I------I-----I------------------------------------------------
C DNTEDX I  R   I in  I derivative of the test functions with
C        I      I     I respect of X / TAU at the elements
C        I      I     I                 array: DNTEDX(ELM1,TOTNT,CLASS)
C--------I------I-----I------------------------------------------------
C TAU    I  R   I in  I directions in the tangential hyperspace
C        I      I     I at the integration node in the elements
C        I      I     I                      array: TAU(ELM1,DIM,CLASS)
C--------I------I-----I------------------------------------------------
C DUDX   I  R   I in  I derivative of the solution with respect of
C        I      I     I X / TAU at the elements
C        I      I     I                      array: DUDX(ELM1,NK,CLASS)
C--------I------I-----I------------------------------------------------
C DUTDX  I  R   I in  I derivative of the T-derivative of the solution
C        I      I     I with respect of X / TAU at the elements
C        I      I     I                    array: DUTDX(ELM1T,NK,CLASS)
C--------I------I-----I------------------------------------------------
C DNOPDX I  R   I in  I derivative of the node parameters with
C        I      I     I respect of X / TAU at the elements
C        I      I     I                   array: DNOPDX(ELM1,NOP,CLASS)
C--------I------I-----I------------------------------------------------
C JACOBI I  R   I in  I integration weights         array: JACOBI(ELM1)
C--------I------I-----I------------------------------------------------
C F0,F1  I  R   I  -  I arrays for the evaluation of the linear
C        I      I     I functionals    arrays: F0(ELM1),F1(ELM1,CLASS)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I,J,K,Z,R,NT,C,CC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      R=0
      DO 501 I=1,NRHS

        CC=0
        DO 500 J=1,NK

          IF (MASKF(J,I)) THEN

            C=MIN(J,NK2)
            NT=NELTYP(C)

            DO 30 Z=1,NELIS
30            F0(Z)=0.D0
            DO 35 K=1,CLASS
              DO 35 Z=1,NELIS
35             F1(Z,K)=0.D0

              CALL USERF(T,GROUP,CLASS,J,I,LAST,
     &                   NELIS,ELM1,DIM,X,TAU,NK,U,DUDX,
     &                   ELM1T,UT,DUTDX,NOP,ENOP,DNOPDX,
     &                   NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                   NISP,ISPARM,NIVP,IVP1,IVPARM,F1,F0)

            DO 40  Z=1,NELIS
 40           F0(Z)=F0(Z)*JACOBI(Z)
            DO 45 K=1,CLASS
              DO 45 Z=1,NELIS
 45             F1(Z,K)=F1(Z,K)*JACOBI(Z)

            IF (CLASS.EQ.3) THEN

              DO 310 K=1,NT
                DO 320 Z=1,NELIS
                  RHSEM(LAST+Z,K+R)=RHSEM(LAST+Z,K+R)+
     &                              F0(Z)*NTE(CC+K)          +
     &                              F1(Z,1)*DNTEDX(Z,CC+K,1) +
     &                              F1(Z,2)*DNTEDX(Z,CC+K,2) +
     &                              F1(Z,3)*DNTEDX(Z,CC+K,3)
 320            CONTINUE
310           CONTINUE
            ENDIF

            IF (CLASS.EQ.2) THEN
              DO 210 K=1,NT
                DO 220 Z=1,NELIS
                  RHSEM(LAST+Z,K+R)=RHSEM(LAST+Z,R+K)+
     &                              F0(Z)*NTE(CC+K)         +
     &                              F1(Z,1)*DNTEDX(Z,CC+K,1) +
     &                              F1(Z,2)*DNTEDX(Z,CC+K,2)
 220            CONTINUE
210           CONTINUE
            ENDIF

            IF (CLASS.EQ.1) THEN
              DO 110 K=1,NT
                DO 120 Z=1,NELIS
                  RHSEM(LAST+Z,K+R)=RHSEM(LAST+Z,K+R)+
     &                              F0(Z)*NTE(CC+K)         +
     &                              F1(Z,1)*DNTEDX(Z,CC+K,1)
 120            CONTINUE
110           CONTINUE
            ENDIF

            R=R+NT

          ENDIF

          IF (C.LT.NK2) CC=CC+NT

 500    CONTINUE

501   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM530----------------------------------------------------
      E    N    D
