C:::::      ,,,,,VEM534...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM534(T,ALPHA,GROUP,CLASS,NK,NK2,NELTYP,TOTNT,
     &                  NELIS,LAST,NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  MASKL,USERL,USERK,ELM1,LEAD,SLICE,EM,
     &                  NTE,DIM,X,U,ELM1T,UT,NOP,ENOP,
     &                  DNTEDX,TAU,DUDX,DUTDX,DNOPDX,JACOBI,
     &                  L3,L2,L1,L0,ELM1TK,K3,K2,K1,K0)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM534       add element matrices for bilinear form        ***
C**                   L+ALPHA*K for one stripe in the unsymmetric   ***
C**                   case.                                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           GROUP,CLASS,NK,NK2,NELIS,LAST,TOTNT,
     &                  NRSP,NRVP,RVP1,NISP,NIVP,IVP1,DIM,LEAD,
     &                  ELM1,ELM1T,ELM1TK,SLICE,NOP

      INTEGER           NELTYP(NK2),ISPARM(NISP),IVPARM(IVP1,NIVP)

      DOUBLE PRECISION  T,ALPHA,RSPARM(NRSP),RVPARM(RVP1,NRVP),
     &                  EM(LEAD,SLICE),NTE(TOTNT),X(ELM1,DIM),
     &                  U(ELM1,NK),UT(ELM1T,NK),
     &                  ENOP(ELM1,NOP),TAU(ELM1,DIM,CLASS),
     &                  DNTEDX(ELM1,TOTNT,CLASS),
     &                  DNOPDX(ELM1,NOP,CLASS),
     &                  DUDX(ELM1,NK,CLASS),DUTDX(ELM1T,NK,DIM),
     &                  JACOBI(ELM1),
     &                  L3(ELM1,CLASS,CLASS),L2(ELM1,CLASS),
     &                  L1(ELM1,CLASS),L0(ELM1),
     &                  K3(ELM1TK,CLASS,CLASS),K2(ELM1TK,CLASS),
     &                  K1(ELM1TK,CLASS),K0(ELM1TK)

      LOGICAL           MASKL(NK,NK)

      EXTERNAL          USERL,USERK
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I current time
C--------I------I-----I-----------------------------------------------
C ALPHA  I  R   I in  I weight for bilinear form K
C--------I------I-----I-----------------------------------------------
C GROUP  I  I   I in  I current group
C--------I------I-----I-----------------------------------------------
C CLASS  I  I   I in  I current element class
C--------I------I-----I-----------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes of the proposal functions
C        I      I     I                              array: NELTYP(NK2)
C--------I------I-----I------------------------------------------------
C NELIS  I  I   I in  I number of elements in the current stripe
C--------I------I-----I------------------------------------------------
C LAST   I  I   I in  I last element in last stripe
C--------I------I-----I------------------------------------------------
C NRSP   I  I   I in  I number of real scalar parameters
C--------I------I-----I------------------------------------------------
C RSPARM I  R   I in  I set of real scalar parameters
C        I      I     I                             array: RVPARM(NRSP)
C--------I------I-----I------------------------------------------------
C NRVP   I  I   I in  I number of real vector parameters
C--------I------I-----I------------------------------------------------
C RVPARM I  R   I in  I set of real vector Parameters
C        I      I     I                        array: RVPARM(RVP1,NRVP)
C--------I------I-----I------------------------------------------------
C NISP   I  I   I in  I number of integer scalar parameters
C--------I------I-----I------------------------------------------------
C ISPARM I  I   I in  I set of integer scalar parameters
C        I      I     I                             array: ISPARM(NISP)
C--------I------I-----I------------------------------------------------
C NIVP   I  I   I in  I number of integer vector Parameters
C--------I------I-----I------------------------------------------------
C IVPARM I  I   I in  I set of integer vector parameters :
C        I      I     I                         array: IPARM(IVP1,NIVP)
C--------I------I-----I------------------------------------------------
C MASKL  I  L   I in  I mask of bilinear forms      array: MASKL(NK,NK)
C--------I------I-----I------------------------------------------------
C USERL  I EX   I in  I routine defining bilnear form L
C--------I------I-----I------------------------------------------------
C USERK  I EX   I in  I routine defining bilnear form K
C--------I------I-----I------------------------------------------------
C EM     I  R   I i/o I element matrices          array: EM(LEAD,SLICE)
C--------I------I-----I------------------------------------------------
C NTE    I  R   I in  I test functions at the integration node
C        I      I     I                               array: NTE(TOTNT)
C--------I------I-----I------------------------------------------------
C X      I  R   I in  I integration node in the elements
C        I      I     I                              array: X(ELM1,DIM)
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I solution at the integration node
C        I      I     I the elements                  array: U(ELM1,NK)
C--------I------I-----I------------------------------------------------
C UT     I  R   I in  I derivative of the solution with respect to
C        I      I     I T at the integration node in the elements
C        I      I     I                            array:  UT(ELM1T,NK)
C--------I------I-----I------------------------------------------------
C ENOP   I  R   I in  I node parameters interpolated to integration node
C        I      I     I in the elements          array:  ENOP(ELM1,NOP)
C--------I------I-----I------------------------------------------------
C DNTEDX I  R   I in  I derivative of the proposal functions with
C        I      I     I respect of X / TAU at the elements
C        I      I     I                  array: DNTEDX(ELM1,TOTNT,CLASS)
C--------I------I-----I------------------------------------------------
C TAU    I  R   I in  I directions in the tangential hyperspace
C        I      I     I at the integration node in the elements
C        I      I     I                      array: TAU(ELM1,DIM,CLASS)
C--------I------I-----I------------------------------------------------
C DUDX   I  R   I in  I derivative of the solution with respect of
C        I      I     I X / TAU at the elements
C        I      I     I                      array: DUDX(ELM1,NK,CLASS)
C--------I------I-----I------------------------------------------------
C DUTDX  I  R   I in  I derivative of the T-derivative of the solution
C        I      I     I with respect of X / TAU at the elements
C        I      I     I                    array: DUTDX(ELM1T,NK,CLASS)
C--------I------I-----I------------------------------------------------
C DNOPDX I  R   I in  I derivative of the node parameters with
C        I      I     I respect of X / TAU at the elements
C        I      I     I                   array: DNOPDX(ELM1,NOP,CLASS)
C--------I------I-----I------------------------------------------------
C JACOBI I  R   I in  I integration weights         array: JACOBI(ELM1)
C--------I------I-----I------------------------------------------------
C L0,1,  I  R   I  -  I coefficients of bilinear form L        
C    2,3 I      I     I  array: L3(ELM1,DIM,DIM)
C        I      I     I         L2(ELM1,DIM)
C        I      I     I         L1(ELM1,DIM)
C        I      I     I         L0(ELM1)
C--------I------I-----I------------------------------------------------
C K0,1,  I  R   I  -  I coefficients of bilinear form K
C    2,3 I      I     I  array: K3(ELM1TK,DIM,DIM)
C        I      I     I         K2(ELM1TK,DIM)
C        I      I     I         K1(ELM1TK,DIM)
C        I      I     I         K0(ELM1TK)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,I1,I2,J1,J2,R,K,
     &                  ROW,COL,NTROW,NTCOL,CC,CR,CC0,CR0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      R=0
      CR0=0
      CC0=TOTNT-NELTYP(MIN(NK2,NK))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of outer component loop:                                ***
C**   -----------------------------                                 ***
C**                                                                 ***
      DO 500 I1=1,2*NK-1

        IF ((I1.GT.NK).AND.(I1-NK.LT.NK2)) CR0=CR0+NELTYP(I1-NK)
        IF ((I1.LE.NK).AND.(NK-I1+1.LT.NK2)) CC0=CC0-NELTYP(NK-I1+1)

        CR=CR0
        CC=CC0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** Start of inner component loop:                              ***
C**     -----------------------------                               ***
C**                                                                 ***
        DO 501 I2=1,NK-ABS(NK-I1)

          ROW=MAX(0,I1-NK)+I2
          COL=MAX(0,NK-I1)+I2

          NTROW=NELTYP(MIN(ROW,NK2))
          NTCOL=NELTYP(MIN(COL,NK2))

          IF (MASKL(ROW,COL).AND.(NTCOL*NTROW.GT.0)) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** evaluate L :                                            ***
C**         -----------                                             ***
C**                                                                 ***
            DO 400 J1=1,CLASS
              DO 400 J2=1,CLASS
                DO 400 Z=1,NELIS
                  L3(Z,J1,J2)=0.D0
  400       CONTINUE
            DO 401 J1=1,CLASS
              DO 401 Z=1,NELIS
               L2(Z,J1)=0.D0
               L1(Z,J1)=0.D0
  401       CONTINUE
            DO 402 Z=1,NELIS
               L0(Z)=0.D0
  402       CONTINUE

            CALL USERL(T,GROUP,CLASS,ROW,COL,LAST,
     &                 NELIS,ELM1,DIM,X,TAU,NK,U,DUDX,
     &                 ELM1T,UT,DUTDX,NOP,ENOP,DNOPDX,
     &                 NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                 NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                 L3,L2,L1,L0)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** evaluate K (only in nonsteady case):                    ***
C**         -----------------------------------                     ***
C**                                                                 ***
            IF (ELM1TK.GE.NELIS) THEN
              DO 410 J1=1,CLASS
                DO 410 J2=1,CLASS
                  DO 410 Z=1,NELIS
                    K3(Z,J1,J2)=0.D0
  410         CONTINUE
              DO 411 J1=1,CLASS
                DO 411 Z=1,NELIS
                  K2(Z,J1)=0.D0
                  K1(Z,J1)=0.D0
  411         CONTINUE
              DO 412 Z=1,NELIS
                 K0(Z)=0.D0
  412         CONTINUE

              CALL USERK(T,GROUP,CLASS,ROW,COL,LAST,
     &                   NELIS,ELM1,DIM,X,TAU,NK,U,DUDX,
     &                   ELM1T,UT,DUTDX,NOP,ENOP,DNOPDX,
     &                   NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                   NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                   K3,K2,K1,K0)
            ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********* add K to L and multiply with JACOBI :                    ***
C**        ------------------------------------                     ***
C**                                                                 ***
           IF (ELM1TK.GE.NELIS) THEN

              DO 420 J1=1,CLASS
                DO 420 J2=1,CLASS
                  DO 420 Z=1,NELIS
                    L3(Z,J1,J2)=JACOBI(Z)*
     &                          (ALPHA*K3(Z,J1,J2)+L3(Z,J1,J2))
  420         CONTINUE
              DO 421 J1=1,CLASS
                DO 421 Z=1,NELIS
                  L2(Z,J1)=JACOBI(Z)*(ALPHA*K2(Z,J1)+L2(Z,J1))
                  L1(Z,J1)=JACOBI(Z)*(ALPHA*K1(Z,J1)+L1(Z,J1))
  421         CONTINUE
              DO 422 Z=1,NELIS
                L0(Z)=JACOBI(Z)*(ALPHA*K0(Z)+L0(Z))
  422         CONTINUE

           ELSE

              DO 430 J1=1,CLASS
                DO 430 J2=1,CLASS
                  DO 430 Z=1,NELIS
                    L3(Z,J1,J2)=JACOBI(Z)*L3(Z,J1,J2)
  430         CONTINUE
              DO 431 J1=1,CLASS
                DO 431 Z=1,NELIS
                  L2(Z,J1)=JACOBI(Z)*L2(Z,J1)
                  L1(Z,J1)=JACOBI(Z)*L1(Z,J1)
  431         CONTINUE
              DO 432 Z=1,NELIS
                L0(Z)=JACOBI(Z)*L0(Z)
  432         CONTINUE

           ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********* Add L+ALPHA*K to element matrix:                         ***
C**        -------------------------------                          ***
C**                                                                 ***
C**                                                                 ***
C********* CLASS=3 :                                                ***
C**                                                                 ***
           IF (CLASS.EQ.3) THEN

            DO 310 J1=1,NTROW
             DO 310 J2=1,NTCOL

              K=R+NTCOL*(J1-1)+J2

              DO 320 Z=1,NELIS

               EM(LAST+Z,K)=EM(LAST+Z,K)+

     &                ( L3(Z,1,1)*DNTEDX(Z,CR+J1,1)
     &                + L3(Z,2,1)*DNTEDX(Z,CR+J1,2)
     &                + L3(Z,3,1)*DNTEDX(Z,CR+J1,3)
     &                + L1(Z,1)  *NTE(CR+J1)      )*DNTEDX(Z,CC+J2,1)

     &           +    ( L3(Z,1,2)*DNTEDX(Z,CR+J1,1)
     &                + L3(Z,2,2)*DNTEDX(Z,CR+J1,2)
     &                + L3(Z,3,2)*DNTEDX(Z,CR+J1,3)
     &                + L1(Z,2)  *NTE(CR+J1)      )*DNTEDX(Z,CC+J2,2)

     &           +    ( L3(Z,1,3)*DNTEDX(Z,CR+J1,1)
     &                + L3(Z,2,3)*DNTEDX(Z,CR+J1,2)
     &                + L3(Z,3,3)*DNTEDX(Z,CR+J1,3)
     &                + L1(Z,3)  *NTE(CR+J1)      )*DNTEDX(Z,CC+J2,3)

     &           +    (  L2(Z,1)  *DNTEDX(Z,CR+J1,1)
     &                +  L2(Z,2)  *DNTEDX(Z,CR+J1,2)
     &                +  L2(Z,3)  *DNTEDX(Z,CR+J1,3)
     &                +  L0(Z)    *NTE(CR+J1)      )*NTE(CC+J2)

 320          CONTINUE
310         CONTINUE

            ENDIF
C**                                                                 ***
C********* CLASS=2 :                                                ***
C**                                                                 ***
           IF (CLASS.EQ.2) THEN

            DO 210 J1=1,NTROW
             DO 210 J2=1,NTCOL

              K=R+NTCOL*(J1-1)+J2

              DO 220 Z=1,NELIS

               EM(LAST+Z,K)=EM(LAST+Z,K)+

     &                ( L3(Z,1,1)*DNTEDX(Z,CR+J1,1)
     &                + L3(Z,2,1)*DNTEDX(Z,CR+J1,2)
     &                + L1(Z,1)  *NTE(CR+J1)      )*DNTEDX(Z,CC+J2,1)

     &           +    ( L3(Z,1,2)*DNTEDX(Z,CR+J1,1)
     &                + L3(Z,2,2)*DNTEDX(Z,CR+J1,2)
     &                + L1(Z,2)  *NTE(CR+J1)      )*DNTEDX(Z,CC+J2,2)

     &           +    (  L2(Z,1)  *DNTEDX(Z,CR+J1,1)
     &                +  L2(Z,2)  *DNTEDX(Z,CR+J1,2)
     &                +  L0(Z)    *NTE(CR+J1)      )*NTE(CC+J2)


 220          CONTINUE
210         CONTINUE

            ENDIF
C**                                                                 ***
C********* CLASS=1 :                                                ***
C**                                                                 ***
           IF (CLASS.EQ.1) THEN

            DO 110 J1=1,NTROW
             DO 110 J2=1,NTCOL

              K=R+NTCOL*(J1-1)+J2

              DO 120 Z=1,NELIS

               EM(LAST+Z,K)=EM(LAST+Z,K)+

     &                ( L3(Z,1,1)*DNTEDX(Z,CR+J1,1)
     &                + L1(Z,1)  *NTE(CR+J1)      )*DNTEDX(Z,CC+J2,1)

     &           +    (  L2(Z,1)  *DNTEDX(Z,CR+J1,1)
     &                +  L0(Z)    *NTE(CR+J1)      )*NTE(CC+J2)


 120          CONTINUE
110         CONTINUE

            ENDIF

            R=R+NTROW*NTCOL

          ENDIF

          IF (ROW.LT.NK2) CR=CR+NTROW
          IF (COL.LT.NK2) CC=CC+NTCOL
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** end of inner component loop:                                ***
C**     ---------------------------                                 ***
C**                                                                 ***
 501    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of outer component loop:                                  ***
C**   ---------------------------                                   ***
C**                                                                 ***
500   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM534----------------------------------------------------
      E    N    D
