C:::::      ,,,,,VEM538...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM538(T,LAST,NELIS,GROUP,NK,NK2,NELTYP,
     &                  TOTNT,GEO1,GEOTYP,GEONEK,
     &                  NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  NOP1,NOP,NOPARM,DIM,NN,NOD,U1,U2,U,USERC,
     &                  S,DSDV,N,DNDV,ELM1,X,UU,ENOP,DVDX,UV2,DUDV,
     &                  DUDX,DNOPDX,JACOBI,NC,CU)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM538   evaluation of a function C depending on U           ***
C**             for a stripe of inner elements                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           GROUP,NK,NK2,GEO1,GEOTYP,U1,U2,
     &                  NRSP,NRVP,RVP1,TOTNT,NC,NELIS,ELM1,
     &                  NISP,NIVP,IVP1,DIM,NN,LAST,UV2,NOP1,NOP

      INTEGER           ISPARM(NISP),IVPARM(IVP1,NIVP),
     &                  NELTYP(NK2),GEONEK(GEO1,GEOTYP)

      DOUBLE PRECISION  T,RSPARM(NRSP),RVPARM(RVP1,NRVP),
     &                  NOD(NN,DIM),U(U1,U2),NOPARM(NOP1,NOP),
     &                  S(GEOTYP),DSDV(GEOTYP,DIM),
     &                  N(TOTNT),DNDV(TOTNT,DIM),
     &                  X(ELM1,DIM),UU(ELM1,NK),DUDX(ELM1,NK,DIM),
     &                  ENOP(ELM1,NOP),DNOPDX(ELM1,NOP,DIM),
     &                  DVDX(ELM1,DIM,DIM),JACOBI(ELM1),
     &                  DUDV(ELM1,UV2,DIM),CU(ELM1,NC)

      EXTERNAL          USERC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I current time step
C--------I------I-----I------------------------------------------------
C LAST   I  I   I in  I last element in last stripe
C--------I------I-----I-----------------------------------------------
C NELIS  I  I   I in  I number of elements in the current stripe
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I in  I current group
C--------I------I-----I-----------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes of the proposal functions
C        I      I     I                              array: NELTYP(NK2)
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes of the shape functions
C--------I------I-----I------------------------------------------------
C GEONEK I  I   I in  I node ids describing the element geometry
C        I      I     I                      array: GEONEK(GEO1,GEOTYP)
C--------I------I-----I------------------------------------------------
C NRSP   I  I   I in  I number of real scalar parameters
C--------I------I-----I------------------------------------------------
C RSPARM I  R   I in  I set of real scalar parameters
C        I      I     I                             array: RVPARM(NRSP)
C--------I------I-----I------------------------------------------------
C NRVP   I  I   I in  I number of real vector parameters
C--------I------I-----I------------------------------------------------
C RVPARM I  R   I in  I set of real vector Parameters
C        I      I     I                        array: RVPARM(RVP1,NRVP)
C--------I------I-----I------------------------------------------------
C NISP   I  I   I in  I number of integer scalar parameters
C--------I------I-----I------------------------------------------------
C ISPARM I  I   I in  I set of integer scalar parameters
C        I      I     I                             array: ISPARM(NISP)
C--------I------I-----I------------------------------------------------
C NIVP   I  I   I in  I number of integer vector Parameters
C--------I------I-----I------------------------------------------------
C IVPARM I  I   I in  I set of integer vector parameters :
C        I      I     I                         array: IPARM(IVP1,NIVP)
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C NOPARM I  R   I in  I node parameters at the geometrical nodes
C        I      I     I                         array: NOPARM(NOP1,NOP)
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I coordinates of the geometrical nodes
C        I      I     I                              array: NOD(NN,DIM)
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I solution at the nodes of the elements
C        I      I     I                                 array: U(U1,U2)
C--------I------I-----I------------------------------------------------
C USERC  I EX   I in  I routine defining function C
C--------I------I-----I------------------------------------------------
C S      I  R   I in  I shape functions a point in the reference
C        I      I     I element                        array: S(GEOTYP)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I in  I derivative of the shape functions a point in
C        I      I     I the reference element
C        I      I     I                       array: DSDV(GEOTYP,CLASS)
C--------I------I-----I------------------------------------------------
C N      I  R   I in  I proposal functions at a point in the reference
C        I      I     I element                         array: N(TOTNT)
C--------I------I-----I------------------------------------------------
C DNDV   I  R   I in  I derivative of the proposal functions a point in
C        I      I     I the reference element
C        I      I     I                       array: DNDV(TOTNT,CLASS)
C--------I------I-----I------------------------------------------------
C X      I  R   I out I map of point in the elements
C        I      I     I                              array: X(ELM1,DIM)
C--------I------I-----I------------------------------------------------
C UU     I  R   I out I solution at point in the elements
C        I      I     I                              array: UU(ELM1,U2)
C--------I------I-----I------------------------------------------------
C ENOP   I  R   I out I node parameter at point in the elements
C        I      I     I                           array: ENOP(ELM1,NOP)
C--------I------I-----I------------------------------------------------
C DVDX   I  R   I out I jacobean derivative of the invers of element
C        I      I     I parametrization
C        I      I     I                       array: DVDX(ELM1,DIM,DIM)
C--------I------I-----I------------------------------------------------
C DUDV   I  R   I  -  I derivative of solution and node parameters on
C        I      I     I the reference elements (UV2>=max(NOP,U2) !)
C        I      I     I                       array: DUDV(ELM1,UV2,DIM)
C--------I------I-----I------------------------------------------------
C DUDX   I  R   I out I derivative of the solution with respect of
C        I      I     I X at the elements
C        I      I     I                        array: DUDX(ELM1,U2,DIM)
C--------I------I-----I------------------------------------------------
C DNOPDX I  R   I out I derivative of the node parameters with
C        I      I     I respect of X at the elements
C        I      I     I                     array: DNOPDX(ELM1,NOP,DIM)
C--------I------I-----I------------------------------------------------
C JACOBI I  R   I out I integration weights         array: JACOBI(ELM1)
C--------I------I-----I------------------------------------------------
C NC     I  I   I in  I number of components of C
C--------I------I-----I------------------------------------------------
C CU     I  R   I out I values of the function C     array: CU(ELM1,NC)
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           Z,I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute coordinates in the elements :                         ***
C**   -----------------------------------                           ***
C**                                                                 ***
      IF (DIM.EQ.3) THEN
         CALL VEM904(NELIS,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &               S,DSDV(1,1),DSDV(1,2),DSDV(1,3),
     &               X,DVDX(1,1,1),DVDX(1,1,2),DVDX(1,1,3))
      ENDIF

      IF (DIM.EQ.2) THEN
        CALL VEM903(NELIS,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &              S,DSDV(1,1),DSDV(1,2),X,DVDX(1,1,1),DVDX(1,1,2))
      ENDIF

      IF (DIM.EQ.1) THEN
        CALL VEM902(NELIS,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &              S,DSDV(1,1),X,DVDX(1,1,1))
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute jacobi detreminante of parametrization and            ***
C**   jacobi matrix of invers parametrization:                      ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      CALL VEM910(NELIS,DIM,ELM1,DVDX,JACOBI)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the solution and its derivatives on                   ***
C**   the reference element:                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      IF (DIM.EQ.3) THEN
         CALL VEM909(NELIS,LAST+1,NK,U1,U2,U,NK2,NELTYP,TOTNT,
     &               ELM1,N,DNDV(1,1),DNDV(1,2),DNDV(1,3),
     &               UU,DUDV(1,1,1),DUDV(1,1,2),DUDV(1,1,3))
      ENDIF

      IF (DIM.EQ.2) THEN
         CALL VEM908(NELIS,LAST+1,NK,U1,U2,U,NK2,NELTYP,TOTNT,
     &               ELM1,N,DNDV(1,1),DNDV(1,2),
     &               UU,DUDV(1,1,1),DUDV(1,1,2))
      ENDIF

      IF (DIM.EQ.1) THEN
         CALL VEM907(NELIS,LAST+1,NK,U1,U2,U,NK2,NELTYP,TOTNT,
     &               ELM1,N,DNDV(1,1),UU,DUDV(1,1,1))
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute derivatives of solution on elements :                 ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      CALL VEM922(NELIS,DIM,DIM,ELM1,DVDX,NK,DUDV,DUDX)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the node parameters :                                 ***
C**   ---------------------------                                   ***
C**                                                                 ***
      IF (NOP.GT.0) THEN
C**                                                                 ***
C****** node parameters on the reference element :                  ***
C**                                                                 ***
        IF (DIM.EQ.3) THEN
          CALL VEM904(NELIS,LAST+1,NOP,NOP1,NOPARM,GEO1,GEOTYP,GEONEK,
     &                ELM1,S,DSDV(1,1),DSDV(1,2),DSDV(1,3),
     &                ENOP,DUDV(1,1,1),DUDV(1,1,2),DUDV(1,1,3))
        ENDIF
        IF (DIM.EQ.2) THEN
          CALL VEM903(NELIS,LAST+1,NOP,NOP1,NOPARM,GEO1,GEOTYP,GEONEK,
     &                ELM1,S,DSDV(1,1),DSDV(1,2),
     &                ENOP,DUDV(1,1,1),DUDV(1,1,2))
        ENDIF
        IF (DIM.EQ.1) THEN
          CALL VEM903(NELIS,LAST+1,NOP,NOP1,NOPARM,GEO1,GEOTYP,GEONEK,
     &                ELM1,S,DSDV(1,1),ENOP,DUDV(1,1,2))
        ENDIF
C**                                                                 ***
C****** node parameters on the element:                             ***
C**                                                                 ***
        CALL VEM922(NELIS,DIM,DIM,ELM1,DVDX,NOP,DUDV,DNOPDX)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** elvaluate function C :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 400 I=1,NC
        DO 400 Z=1,NELIS
         CU(Z,I)=0
 400  CONTINUE

      CALL USERC(T,GROUP,LAST,NELIS,
     &           NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &           NISP,ISPARM,NIVP,IVP1,IVPARM,
     &           ELM1,DIM,X,NK,UU,DUDX,NOP,ENOP,DNOPDX,NC,CU)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM538----------------------------------------------------
      E    N    D
