C:::::      ,,,,,VEM539...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM539(NE,CLASS,GEOTYP,GEO1,GEONEK,TOTNT,NEK1,NEK,
     &                  DIM,NN,NOD,LEAD,PILE,ELMW,
     &                  NQ,WQ,DSDV,NTE,ELM1,DXDV,JAC,STRIPS)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM539     computes the element matrices for the           ***
C**                 L1-norm of the proposal functions.              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           CLASS,NEK1,TOTNT,GEO1,GEOTYP,LEAD,PILE,
     &                  DIM,NN,ELM1,NQ,STRIPS,NE

      DOUBLE PRECISION  NOD(NN,DIM),WQ(NQ),ELMW(LEAD,PILE),
     &                  DSDV(GEOTYP,CLASS,NQ),NTE(TOTNT,NQ),
     &                  JAC(ELM1),DXDV(ELM1,DIM,CLASS)

      INTEGER           NEK(NEK1,TOTNT),GEONEK(GEO1,GEOTYP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NE     I  I   I in  I number of elements
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the elements
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of local geometrical nodes
C--------I------I-----I------------------------------------------------
C GEONEK I  I   I in  I geometrical mesh      array: GEONEK(GEO1,GEOTYP)
C--------I------I-----I------------------------------------------------
C TOTNT  I  I   I in  I number of proposal function
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I proposal mesh             array: NEK(NEK1,TOTNT)
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I node coordinates             array: NOD(NN,DIM)
C--------I------I-----I------------------------------------------------
C ELMW   I  R   I i/o I element matrices for the L1-norm of the
C        I      I     I proposal functions       array: ELMW(LEAD,PILE)
C--------I------I-----I------------------------------------------------
C NQ     I  I   I in  I number of quadrature nodes
C--------I------I-----I------------------------------------------------
C WQ     I  R   I in  I quadratur weights                 array: WQ(NQ)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I in  I derivative shape functions at quadratur nodes
C        I      I     I                   ARRAY : DSDV(GEOTYP,CLASS,NQ)
C--------I------I-----I------------------------------------------------
C NTE    I  R   I in  I test functions at quadratur nodes
C        I      I     I                            array: NTE(TOTNT,NQ)
C--------I------I-----I------------------------------------------------
C JAC    I  R   I  -  I volumes/area/line element      array: JAC(ELM1)
C--------I------I-----I------------------------------------------------
C DXDV   I  R   I -   I derivatives of element representation
C        I      I     I                     array: DXDV(ELM1,DIM,CLASS)
C--------I------I-----I------------------------------------------------
C STRIPS I  I   I out I needed stripes
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           LAST,NELIS,J,I,Z
      DOUBLE PRECISION  HILF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**                                                                 ***
      LAST=0
      STRIPS=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of element stripes :                                    ***
C**   ------------------------                                      ***
C**                                                                 ***
1000  CONTINUE
      NELIS=MIN(ELM1,NE-LAST)
      STRIPS=STRIPS+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of integration loop:                                    ***
C**   -------------------------                                     ***
C**                                                                 ***
      DO 2000 J=1,NQ
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute element representation:                             ***
C**     ------------------------------                              ***
C**                                                                 ***
        IF (CLASS.EQ.3) THEN
          CALL VEM903(NELIS,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &                DSDV(1,1,J),DSDV(1,2,J),DSDV(1,3,J),
     &                DXDV(1,1,1),DXDV(1,1,2),DXDV(1,1,3))
        ENDIF
        IF (CLASS.EQ.2) THEN
          CALL VEM902(NELIS,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &                DSDV(1,1,J),DSDV(1,2,J),
     &                DXDV(1,1,1),DXDV(1,1,2))
        ENDIF
        IF (CLASS.EQ.1) THEN
          CALL VEM901(NELIS,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &                DSDV(1,1,J),DXDV(1,1,1))
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute volume/ares/line element :                          ***
C**     --------------------------------                            ***
C**                                                                 ***
        IF (CLASS.EQ.DIM) THEN
          CALL VEM911(NELIS,DIM,ELM1,DXDV,JAC)
        ELSEIF ((CLASS.EQ.2).AND.(DIM.EQ.3)) THEN
          CALL VEM917(NELIS,ELM1,DXDV(1,1,1),DXDV(1,1,2),JAC)
        ELSEIF ((CLASS.EQ.1).AND.(DIM.GT.1)) THEN
          CALL VEM918(NELIS,DIM,ELM1,DXDV,JAC)
        ELSE
          DO 200 Z=1,NELIS
            JAC(Z)=1.
  200     CONTINUE
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** add to element matrices:                                      ***
C**   -----------------------                                       ***
C**                                                                 ***
        DO 30  I=1,TOTNT
	  HILF=WQ(J)*ABS(NTE(I,J))
          DO 30  Z=1,NELIS
            ELMW(LAST+Z,I)=ELMW(LAST+Z,I)+JAC(Z)*HILF
 30     CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of integration loop:                                      ***
C**   -----------------------                                       ***
C**                                                                 ***
2000  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fill the element matrices :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
        DO 130  I=TOTNT+1,PILE,TOTNT
          DO 130  J=1,TOTNT
            DO 130  Z=1,NELIS
              ELMW(LAST+Z,I-1+J)=ELMW(LAST+Z,J)
130     CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of stripe loop:                                           ***
C**   ------------------                                            ***
C**                                                                 ***
      LAST=LAST+NELIS
      IF (LAST.LT.NE) GOTO 1000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM539----------------------------------------------------
      E    N    D
