C:::::      ,,,,VEM590...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM590(DFDUT,DU,EPS,SYM,DIAM,
     &                  T,GROUP,U1,NK,NE,GEOTYP,GEO1,GEONEK,
     &                  NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  NOP1,NOP,NOPARM,DIM,NN,NOD,U,UT,MASKL,USERL,
     &                  MASKF,USERF,S,DSDV,ELM1,X,UU,ELM1T,UUT,ENOP,
     &                  DUDX,DUTDX,DNOPDX,
     &                  NVRB2,VRB2,VRBIG,LIST,OUTCNT,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM590       prepares the check of the Frechets on         ***
C**                   inner elements (CLASS=DIM).                   ***
C**                   ELM1T>=ELM1 marks the nonsteady case.         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           GROUP,U1,NK,GEOTYP,NE,GEO1,NRSP,NRVP,RVP1,
     &                  NISP,NIVP,IVP1,DIM,NN,ELM1,NVRB2,
     &                  VRB2,NOP1,NOP,ELM1T,OUTCNT,LOUT,ERR

      INTEGER           GEONEK(GEO1,GEOTYP),ISPARM(NISP),
     &                  IVPARM(IVP1,NIVP),LIST(NE)

      DOUBLE PRECISION  T,RSPARM(NRSP),RVPARM(RVP1,NRVP),
     &                  NOD(NN,DIM),U(U1,NK),UT(U1,NK),NOPARM(NOP1,NOP),
     &                  S(GEOTYP),DSDV(GEOTYP,DIM),
     &                  X(ELM1,DIM),UU(ELM1,NK),UUT(ELM1T,NK),
     &                  DUDX(ELM1,NK,DIM),DUTDX(ELM1T,NK,DIM),
     &                  ENOP(ELM1,NOP),DNOPDX(ELM1,NOP,DIM),
     &                  VRBIG(ELM1,VRB2),DIAM,EPS,DU

      LOGICAL           MASKL(NK,NK),MASKF(NK),SYM,DFDUT

      EXTERNAL          USERF,USERL
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DFDUT  I  L   I in  I perturbation in direction UT
C--------I------I-----I-----------------------------------------------
C DU     I  R   I in  I increment for U and DUDX
C        I      I     I =0 => no check
C--------I------I-----I-----------------------------------------------
C EPS    I  R   I in  I small positiv machine constant
C--------I------I-----I-----------------------------------------------
C SYM    I  L   I i/o I symmetrical case
C--------I------I-----I-----------------------------------------------
C DIAM   I  R   I in  I diameter of the mesh
C--------I------I-----I-----------------------------------------------
C T      I  R   I in  I current time
C--------I------I-----I-----------------------------------------------
C GROUP  I  I   I in  I current group
C--------I------I-----I-----------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C NE     I  I   I in  I number of elements
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I order of shape function
C--------I------I-----I------------------------------------------------
C GEONEK I  I   I in  I mesh array           array: GEONEK(GEO1,GEOTYP)
C--------I------I-----I------------------------------------------------
C NRSP   I  I   I in  I number of real scalar parameters
C--------I------I-----I------------------------------------------------
C RSPARM I  R   I in  I set of real scalar Parameters
C        I      I     I                             array: RVPARM(NRSP)
C--------I------I-----I------------------------------------------------
C NRVP   I  I   I in  I number of real vector parameters
C--------I------I-----I------------------------------------------------
C RVPARM I  R   I in  I set of real vector parameters
C        I      I     I                        array: RVPARM(RVP1,NRVP)
C--------I------I-----I------------------------------------------------
C NISP   I  I   I in  I number of integer scalar parameters
C--------I------I-----I------------------------------------------------
C ISPARM I  R   I in  I set of integer scalar parameters
C        I      I     I                             array: ISPARM(NISP)
C--------I------I-----I------------------------------------------------
C NIVP   I  I   I in  I number of integer vector parameters
C--------I------I-----I------------------------------------------------
C IVPARM I  R   I in  I set of integer vector parameters :
C        I      I     I                         array: IPARM(IVP1,NIVP)
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C NOPARM I  I   I in  I node parameters         array: NOPARM(NOP1,NOP)
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I node coordinates             array: NOD(NN,DIM)
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I solution at nodes               array: U(U1,NK)
C--------I------I-----I------------------------------------------------
C UT     I  R   I in  I derivative of solution with respect to t
C        I      I     I at nodes                       array: UT(U1,NK)
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I mask of linear form            array: MASKF(NK)
C--------I------I-----I------------------------------------------------
C USERF  I EX   I in  I routine defining linear form
C--------I------I-----I------------------------------------------------
C MASKL  I  L   I in  I mask of frechets            array: MASKL(NK,NK)
C--------I------I-----I------------------------------------------------
C USERL  I EX   I in  I routine defining the frechet
C--------I------I-----I------------------------------------------------
C S      I  R   I in  I shape functions at centre point
C        I      I     I                                array: S(GEOTYP)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I in  I derivative of shape functions at centre point
C        I      I     I                         array: DSDV(GEOTYP,DIM)
C--------I------I-----I------------------------------------------------
C X      I  R   I out I centre points of elements    array: X(ELM1,DIM)
C--------I------I-----I------------------------------------------------
C UU     I  R   I out I solution at centre points    array: UU(ELM1,NK)
C--------I------I-----I------------------------------------------------
C UUT    I  R   I out I derivative of the solution with respect of
C        I      I     I T at the centre points     array: UUT(ELM1T,NK)
C--------I------I-----I------------------------------------------------
C ENOP   I  R   I out I node parameters at centre points
C        I      I     I                           array: ENOP(ELM1,NOP)
C--------I------I-----I------------------------------------------------
C DUDX   I  R   I out I derivative of solution at centre points
C        I      I     I                        array: DUDX(ELM1,NK,DIM)
C--------I------I-----I------------------------------------------------
C DUTDX  I  R   I out I derivative of derivative of the solution with
C        I      I     I respect to t at centre points
C        I      I     I                      array: DUTDX(ELM1T,NK,DIM)
C--------I------I-----I------------------------------------------------
C DNOPDX I  R   I out I derivative of the node parameters at centre
C        I      I     I point              array: DNOPDX(ELM1T,NOP,DIM)
C--------I------I-----I------------------------------------------------
C NVRB2  I  I   I out I needed second dimension of VRBIG
C--------I------I-----I------------------------------------------------
C VRBIG  I  R   I -   I vector work array       array: VRBIG(ELM1,VRB2)
C--------I------I-----I------------------------------------------------
C LIST   I  I   I -   I list of failed elements         array: LIST(NE)
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I unit of line out
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I the first outcnt failed elements are printed
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number   =5920 => small storage
C        I      I     I                =5921 => illegal jacobean
C        I      I     I                =5922 => incorrect frechets
C        I      I     I                =5923 => incorrect mask
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,LAST,CLASS,LTAU,IERR,OUT2,NFAIL
      INTEGER           DXDV,DXDV1,DXDV2,DXDV3,DVDX,
     &                  DUDV,DUDV1,DUDV2,DUDV3,
     &                  DUTDV,DUTDV1,DUTDV2,DUTDV3,
     &                  DNPDV,DNPDV1,DNPDV2,DNPDV3,
     &                  L3,L2,L1,L0,F1,F0,JACOBI,
     &                  L3H,L2H,L1H,L0H,F1H,F0H,DUDX2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LAST=0
      CLASS=DIM
      LTAU =0
      NVRB2=0
      ERR=0
      OUT2=MIN(OUTCNT,NE)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the transformation and its derivatives :            ***
C**     ----------------------------------------------              ***
C**                                                                 ***
      JACOBI=1
      DXDV=JACOBI+1
      DXDV1=DXDV
      DXDV2=DXDV1+DIM
      DXDV3=DXDV2+DIM
      NVRB2=MAX(DXDV+DIM*DIM,NVRB2)

      IF (NVRB2.LE.VRB2) THEN

        IF (DIM.EQ.3) THEN
          CALL VEM904(NE,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &                S(1),DSDV(1,1),DSDV(1,2),DSDV(1,3),
     &                X,VRBIG(1,DXDV1),VRBIG(1,DXDV2),VRBIG(1,DXDV3))
        ENDIF
        IF (DIM.EQ.2) THEN
          CALL VEM903(NE,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &                S(1),DSDV(1,1),DSDV(1,2),
     &                X,VRBIG(1,DXDV1),VRBIG(1,DXDV2))
        ENDIF
        IF (DIM.EQ.1) THEN
          CALL VEM902(NE,LAST+1,DIM,NN,NOD,GEO1,GEOTYP,GEONEK,ELM1,
     &               S(1),DSDV(1,1),X,VRBIG(1,DXDV1))
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the jacobean determinante of trafo :                ***
C**     ------------------------------------------                  ***
C**                                                                 ***
        CALL VEM911(NE,DIM,ELM1,VRBIG(1,DXDV),VRBIG(1,JACOBI))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** check element value :                                       ***
C**     --------------------                                        ***
C**                                                                 ***
        NFAIL=0
        DO 100 Z=1,NE
          IF ( VRBIG(Z,JACOBI) .LT. 100 * EPS * DIAM**DIM ) THEN
            NFAIL=NFAIL+1
            LIST(NFAIL)=Z
          ENDIF
 100    CONTINUE

        IF (NFAIL.GT.0) THEN
          ERR=5901
          WRITE(LOUT,9070) NFAIL,NFAIL,GROUP
          WRITE(LOUT,9080) (LIST(Z),VRBIG(LIST(Z),JACOBI),
     &                                           Z=1,MIN(NFAIL,OUT2))
          GOTO 9999
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute invers trafo :                                      ***
C**     --------------------                                        ***
C**                                                                 ***
        CALL VEM912(NE,DIM,ELM1,VRBIG(1,DXDV))
      ELSE
         ERR=5900
      ENDIF
      DVDX=DXDV
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the solution and its derivatives on reference       ***
C**     element :                                                   ***
C**     -----------------------------------------------------       ***
C**                                                                 ***
      DUDV=DVDX+DIM*DIM
      NVRB2=MAX(DUDV+DIM*NK,NVRB2)

      IF (NVRB2.LE.VRB2) THEN

        DUDV1=DUDV
        DUDV2=DUDV1+NK
        DUDV3=DUDV2+NK

        IF (DIM.EQ.3) THEN
          CALL VEM904(NE,LAST+1,NK,U1,U,GEO1,GEOTYP,GEONEK,ELM1,
     &                S(1),DSDV(1,1),DSDV(1,2),DSDV(1,3),
     &                UU,VRBIG(1,DUDV1),VRBIG(1,DUDV2),VRBIG(1,DUDV3))
        ENDIF
        IF (DIM.EQ.2) THEN
          CALL VEM903(NE,LAST+1,NK,U1,U,GEO1,GEOTYP,GEONEK,ELM1,
     &                S(1),DSDV(1,1),DSDV(1,2),
     &                UU,VRBIG(1,DUDV1),VRBIG(1,DUDV2))
        ENDIF
        IF (DIM.EQ.1) THEN
          CALL VEM902(NE,LAST+1,NK,U1,U,GEO1,GEOTYP,GEONEK,ELM1,
     &                 S(1),DSDV(1,1),UU,VRBIG(1,DUDV1))
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the solution and its derivatives on element:        ***
C**     ---------------------------------------------------         ***
C**                                                                 ***
        CALL VEM922(NE,DIM,DIM,ELM1,VRBIG(1,DVDX),NK,
     &              VRBIG(1,DUDV),DUDX)

      ELSE
        ERR=5900
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the T-solution and                                  ***
C**                        its derivatives on reference element :   ***
C**     -------------------------------------------------------     ***
C**                                                                 ***
      IF (ELM1T.GE.ELM1) THEN

         DUTDV=DVDX+DIM*DIM
         NVRB2=MAX(DUTDV+DIM*NK,NVRB2)
         IF (NVRB2.LE.VRB2) THEN

           DUTDV1=DUTDV
           DUTDV2=DUTDV1+NK
           DUTDV3=DUTDV2+NK

           IF (DIM.EQ.3) THEN
             CALL VEM904(NE,LAST+1,NK,U1,UT,GEO1,GEOTYP,GEONEK,ELM1,
     &                   S(1),DSDV(1,1),DSDV(1,2),DSDV(1,3),
     &                   UUT,VRBIG(1,DUTDV1),VRBIG(1,DUTDV2),
     &                    VRBIG(1,DUTDV3))
           ENDIF
           IF (DIM.EQ.2) THEN
             CALL VEM903(NE,LAST+1,NK,U1,UT,GEO1,GEOTYP,GEONEK,ELM1,
     &                   S(1),DSDV(1,1),DSDV(1,2),
     &                   UUT,VRBIG(1,DUTDV1),VRBIG(1,DUTDV2))
           ENDIF
           IF (DIM.EQ.1) THEN
             CALL VEM902(NE,LAST+1,NK,U1,UT,GEO1,GEOTYP,GEONEK,ELM1,
     &                   S(1),DSDV(1,1),UUT,VRBIG(1,DUTDV1))
           ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******* compute derivatives of t-solution on elements :            ***
C**      ---------------------------------------------              ***
C**                                                                 ***
           CALL VEM922(NE,DIM,DIM,ELM1,VRBIG(1,DVDX),NK,
     &                 VRBIG(1,DUTDV),DUTDX)
         ELSE
           ERR=5900
         ENDIF
       ENDIF
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the node parameters and                             ***
C**                       their derivatives on reference element :  *** 
C**     --------------------------------------------------------    ***
C**                                                                 ***
       IF (NOP.GT.0) THEN

         DNPDV=DVDX+DIM*DIM
         NVRB2=MAX(DNPDV+DIM*NOP,NVRB2)
         IF (NVRB2.LE.VRB2) THEN

           DNPDV1=DNPDV
           DNPDV2=DNPDV1+NOP
           DNPDV3=DNPDV2+NOP

           IF (DIM.EQ.3) THEN
             CALL VEM904(NE,LAST+1,NOP,NOP1,NOPARM,GEO1,GEOTYP,GEONEK,
     &                   ELM1,S(1),DSDV(1,1),DSDV(1,2),DSDV(1,3),
     &                   ENOP,VRBIG(1,DNPDV1),
     &                   VRBIG(1,DNPDV2),VRBIG(1,DNPDV3))
           ENDIF
           IF (DIM.EQ.2) THEN
             CALL VEM903(NE,LAST+1,NOP,NOP1,NOPARM,GEO1,GEOTYP,GEONEK,
     &                   ELM1,S(1),DSDV(1,1),DSDV(1,2),
     &                   ENOP,VRBIG(1,DNPDV1),VRBIG(1,DNPDV2))
           ENDIF
           IF (DIM.EQ.1) THEN
             CALL VEM902(NE,LAST+1,NOP,NOP1,NOPARM,GEO1,GEOTYP,GEONEK,
     &                   ELM1,S(1),DSDV(1,1),ENOP,VRBIG(1,DNPDV1))
           ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** compute derivatives of node parameters on elements :      ***
C**       --------------------------------------------------        ***
C**                                                                 ***
          CALL VEM922(NE,DIM,DIM,ELM1,VRBIG(1,DVDX),NOP,
     &                VRBIG(1,DNPDV),DNOPDX)
          ELSE
            ERR=5900
          ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check frechets :                                              ***
C**   --------------                                                ***
C**                                                                 ***
      L3=1
      L2=L3+CLASS*CLASS
      L1=L2+CLASS
      L0=L1+CLASS
      F1=L0+1
      F0=F1+CLASS
      L3H=F0+1
      L2H=L3H+CLASS*CLASS
      L1H=L2H+CLASS
      L0H=L1H+CLASS
      F1H=L0H+1
      F0H=F1H+CLASS
      DUDX2=F0H+1
      NVRB2=MAX(DUDX2+CLASS*NK,NVRB2)

      IF (NVRB2.LE.VRB2) THEN

        CALL VEM598(DFDUT,DU,EPS,
     &              SYM,T,GROUP,CLASS,NK,NE,
     &              NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &              NISP,ISPARM,NIVP,IVP1,IVPARM,
     &              MASKF,USERF,MASKL,USERL,ELM1,
     &              DIM,X,UU,ELM1T,UUT,NOP,ENOP,
     &              VRBIG(1,DXDV),DUDX,DUTDX,DNOPDX,
     &              LIST,VRBIG(1,F1),VRBIG(1,F0),VRBIG(1,L3),
     &              VRBIG(1,L2),VRBIG(1,L1),VRBIG(1,L0),
     &              VRBIG(1,F1H),VRBIG(1,F0H),VRBIG(1,L3H),
     &              VRBIG(1,L2H),VRBIG(1,L1H),VRBIG(1,L0H),
     &              VRBIG(1,DUDX2),OUTCNT,LOUT,IERR)

        IF (IERR.EQ.5980) THEN
          ERR=5903
          GOTO 9999
        ENDIF
        IF (IERR.EQ.5981) THEN
          ERR=5902
          GOTO 9999
        ENDIF

      ELSE

        ERR=5900

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9070  FORMAT('>>VEMCD:31:0001:',I9
     &      /'>>group ',I3,': ',I9,' illegal element jacobean.')
9080  FORMAT('>>element ',I9,': element jacobean :',G12.4)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
9999  CONTINUE
      R E T U R N
C-----End of VEM590----------------------------------------------------
      E    N    D
