C:::::      ,,,,,VEM594...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM594(DFDUT,DU,EPS,SYM,
     &                  T,GROUP,U1,NK,NE,GEO1,GEONEK,
     &                  NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  NOP1,NOP,NOPARM,DIM,NN,NOD,U,UT,MASKL,USERL,
     &                  MASKF,USERF,ELM1,X,UU,ELM1T,UUT,ENOP,
     &                  NVRB2,VRB2,VRBIG,LIST,OUTCNT,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM594     prepares the check of the Frechets on           ***
C**                 node element.                                   ***
C**                 ELM1T>=ELM1 marks the nonsteady case.           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           GROUP,U1,NK,NE,GEO1,NRSP,NRVP,RVP1,
     &                  NISP,NIVP,IVP1,DIM,NN,ELM1,NVRB2,
     &                  VRB2,NOP1,NOP,ELM1T,OUTCNT,LOUT,ERR

      INTEGER           GEONEK(GEO1),ISPARM(NISP),
     &                  IVPARM(IVP1,NIVP),LIST(NE)

      DOUBLE PRECISION  T,RSPARM(NRSP),RVPARM(RVP1,NRVP),
     &                  NOD(NN,DIM),U(U1,NK),UT(U1,NK),NOPARM(NOP1,NOP),
     &                  X(ELM1,DIM),UU(ELM1,NK),UUT(ELM1T,NK),
     &                  ENOP(ELM1,NOP),VRBIG(ELM1,VRB2),EPS,DU

      LOGICAL           MASKL(NK,NK),MASKF(NK),SYM,DFDUT

      EXTERNAL          USERF,USERL
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DFDUT  I  L   I in  I perturbation in direction UT
C--------I------I-----I-----------------------------------------------
C DU     I  R   I in  I increment for U and DUDX
C        I      I     I =0 => no check
C--------I------I-----I-----------------------------------------------
C EPS    I  R   I in  I small positiv machine constant
C--------I------I-----I-----------------------------------------------
C SYM    I  L   I i/o I symmetrical case
C--------I------I-----I-----------------------------------------------
C T      I  R   I in  I current time
C--------I------I-----I-----------------------------------------------
C GROUP  I  I   I in  I current group
C--------I------I-----I-----------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C NE     I  I   I in  I number of elements
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I order of shape function
C--------I------I-----I------------------------------------------------
C GEONEK I  I   I in  I mesh array           array: GEONEK(GEO1,GEOTYP)
C--------I------I-----I------------------------------------------------
C NRSP   I  I   I in  I number of real scalar parameters
C--------I------I-----I------------------------------------------------
C RSPARM I  R   I in  I set of real scalar Parameters
C        I      I     I                             array: RVPARM(NRSP)
C--------I------I-----I------------------------------------------------
C NRVP   I  I   I in  I number of real vector parameters
C--------I------I-----I------------------------------------------------
C RVPARM I  R   I in  I set of real vector parameters
C        I      I     I                        array: RVPARM(RVP1,NRVP)
C--------I------I-----I------------------------------------------------
C NISP   I  I   I in  I number of integer scalar parameters
C--------I------I-----I------------------------------------------------
C ISPARM I  R   I in  I set of integer scalar parameters
C        I      I     I                             array: ISPARM(NISP)
C--------I------I-----I------------------------------------------------
C NIVP   I  I   I in  I number of integer vector parameters
C--------I------I-----I------------------------------------------------
C IVPARM I  R   I in  I set of integer vector parameters :
C        I      I     I                         array: IPARM(IVP1,NIVP)
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C NOPARM I  I   I in  I node parameters         array: NOPARM(NOP1,NOP)
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I node coordinates               array: NOD(NN,3)
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I solution at nodes               array: U(U1,NK)
C--------I------I-----I------------------------------------------------
C UT     I  R   I in  I derivative of solution with respect to t
C        I      I     I at nodes                       array: UT(U1,NK)
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I mask of linear form            array: MASKF(NK)
C--------I------I-----I------------------------------------------------
C USERF  I EX   I in  I routine defining linear form
C--------I------I-----I------------------------------------------------
C MASKL  I  L   I in  I mask of frechets            array: MASKL(NK,NK)
C--------I------I-----I------------------------------------------------
C USERL  I EX   I in  I routine defining the frechet
C--------I------I-----I------------------------------------------------
C X      I  R   I out I centre points of elements    array: X(ELM1,DIM)
C--------I------I-----I------------------------------------------------
C UU     I  R   I out I solution at centre points    array: UU(ELM1,NK)
C--------I------I-----I------------------------------------------------
C UUT    I  R   I out I derivative of the solution with respect of
C        I      I     I T at the centre points     array: UUT(ELM1T,NK)
C--------I------I-----I------------------------------------------------
C ENOP   I  R   I out I node parameters at centre points
C        I      I     I                           array: ENOP(ELM1,NOP)
C--------I------I-----I------------------------------------------------
C NVRB2  I  I   I out I needed second dimension of VRBIG
C--------I------I-----I------------------------------------------------
C VRBIG  I  R   I -   I vector work array       array: VRBIG(ELM1,VRB2)
C--------I------I-----I------------------------------------------------
C LIST   I  I   I -   I list of failed elements         array: LIST(NE)
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I unit of line out
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I the first outcnt failed elements are printed
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number   =5940 => small storage
C        I      I     I                =5942 => incorrect frechets
C        I      I     I                =5943 => incorrect mask
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,I,LAST,CLASS,IERR,OUT2,L3,L2,L1,L0,F1,F0,
     &                  L3H,L2H,L1H,L0H,F1H,F0H,DUDX2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LAST=0
      CLASS=0
      OUT2=MIN(OUTCNT,NE)
      ERR=0
      NVRB2=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch node coordinates:                                       ***
C**   ----------------------                                        ***
C**                                                                 ***
      DO 10 I=1,DIM
        DO 10 Z=1,NE
          X(Z,I)=NOD(GEONEK(LAST+Z),I)
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch solution :                                              ***
C**   --------------                                                ***
C**                                                                 ***
      DO 20 I=1,NK
        DO 20 Z=1,NE
          UU(Z,I)=U(GEONEK(LAST+Z),I)
20    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch T-derivative of solution:                               ***
C**   ------------------------------                                ***
C**                                                                 ***
      IF (ELM1T.GE.ELM1) THEN
        DO 30 I=1,NK
          DO 30 Z=1,NE
            UUT(Z,I)=UT(GEONEK(LAST+Z),I)
30      CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch node parameters :                                       ***
C**   ----------------------                                        ***
C**                                                                 ***
      DO 40 I=1,NOP
        DO 40 Z=1,NE
          ENOP(Z,I)=NOPARM(GEONEK(LAST+Z),I)
40    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check frechets :                                              ***
C**   --------------                                                ***
C**                                                                 ***
      L3=1
      L2=L3+CLASS*CLASS
      L1=L2+CLASS
      L0=L1+CLASS
      F1=L0+1
      F0=F1+CLASS
      L3H=F0+1
      L2H=L3H+CLASS*CLASS
      L1H=L2H+CLASS
      L0H=L1H+CLASS
      F1H=L0H+1
      F0H=F1H+CLASS
      DUDX2=F0H+1
      NVRB2=MAX(DUDX2+CLASS*NK,NVRB2)

      IF (NVRB2.LE.VRB2) THEN

        CALL VEM598(DFDUT,DU,EPS,
     &              SYM,T,GROUP,CLASS,NK,NE,
     &              NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &              NISP,ISPARM,NIVP,IVP1,IVPARM,
     &              MASKF,USERF,MASKL,USERL,ELM1,
     &              DIM,X,UU,ELM1T,UUT,NOP,ENOP,
     &              VRBIG,VRBIG,VRBIG,VRBIG,
     &              LIST,VRBIG(1,F1),VRBIG(1,F0),VRBIG(1,L3),
     &              VRBIG(1,L2),VRBIG(1,L1),VRBIG(1,L0),
     &              VRBIG(1,F1H),VRBIG(1,F0H),VRBIG(1,L3H),
     &              VRBIG(1,L2H),VRBIG(1,L1H),VRBIG(1,L0H),
     &              VRBIG(1,DUDX2),OUTCNT,LOUT,IERR)

        IF (IERR.EQ.5980) THEN
          ERR=5943
          GOTO 9999
        ENDIF
        IF (IERR.EQ.5981) THEN
          ERR=5942
          GOTO 9999
        ENDIF

      ELSE

        ERR=5940

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
9999  CONTINUE
      R E T U R N
C-----End of VEM594----------------------------------------------------
      E    N    D
