C:::::      ,,,,,VEM598...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM598(DFDUT,DU,EPS,
     &                  SYM,T,GROUP,CLASS,NK,NE,
     &                  NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                  NISP,ISPARM,NIVP,IVP1,IVPARM,
     &                  MASKF,USERF,MASKL,USERL,ELM1,
     &                  DIM,X,U,ELM1T,UT,NOP,ENOP,
     &                  TAU,DUDX,DUTDX,DNOPDX,
     &                  LIST,F1,F0,L3,L2,L1,L0,
     &                  F1H,F0H,L3H,L2H,L1H,L0H,
     &                  DUDX2,OUTCNT,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM598  checks the frechet derivatives (if DU<>0),         ***
C**              the masks and the symmetry flag                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           GROUP,CLASS,NK,NE,
     &                  NRSP,NRVP,RVP1,NISP,NIVP,IVP1,DIM,
     &                  ELM1,ELM1T,NOP,ERR,OUTCNT,LOUT

      DOUBLE PRECISION  DU,EPS,T,RSPARM(NRSP),RVPARM(RVP1,NRVP),
     &                  X(ELM1,DIM),U(ELM1,NK),UT(ELM1T,NK),
     &                  ENOP(ELM1,NOP),TAU(ELM1,DIM,CLASS),
     &                  DNOPDX(ELM1,NOP,CLASS),
     &                  DUDX(ELM1,NK,CLASS),DUTDX(ELM1T,NK,DIM),
     &                  F0(ELM1),F1(ELM1,CLASS),
     &                  L3(ELM1,CLASS,CLASS),L2(ELM1,CLASS),
     &                  L1(ELM1,CLASS),L0(ELM1),
     &                  F0H(ELM1),F1H(ELM1,CLASS),
     &                  L3H(ELM1,CLASS,CLASS),L2H(ELM1,CLASS),
     &                  L1H(ELM1,CLASS),L0H(ELM1),DUDX2(ELM1,NK,CLASS)

      INTEGER           ISPARM(NISP),IVPARM(IVP1,NIVP),LIST(NE)

      LOGICAL           DFDUT,SYM,MASKF(NK),MASKL(NK,NK)

      EXTERNAL          USERF,USERL
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DFDUT  I  L   I in  I perturbation in direction ut
C--------I------I-----I-----------------------------------------------
C DU     I  R   I in  I increment for U and DUDX
C        I      I     I =0 => no check
C--------I------I-----I-----------------------------------------------
C EPS    I  R   I in  I small positiv machine constant
C--------I------I-----I-----------------------------------------------
C SYM    I  L   I i/o I symmetrical case
C--------I------I-----I-----------------------------------------------
C T      I  R   I in  I current time
C--------I------I-----I-----------------------------------------------
C GROUP  I  I   I in  I current group
C--------I------I-----I-----------------------------------------------
C CLASS  I  I   I in  I current class
C--------I------I-----I-----------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NE     I  I   I in  I number of elements in current group
C--------I------I-----I------------------------------------------------
C NRSP   I  I   I in  I number of real scalar parameters
C--------I------I-----I------------------------------------------------
C RSPARM I  R   I in  I set of real scalar parameters
C        I      I     I                             array: RVPARM(NRSP)
C--------I------I-----I------------------------------------------------
C NRVP   I  I   I in  I number of real vector parameters
C--------I------I-----I------------------------------------------------
C RVPARM I  R   I in  I set of real vector parameters
C        I      I     I                        array: RVPARM(RVP1,NRVP)
C--------I------I-----I------------------------------------------------
C NISP   I  I   I in  I number of integer scalar parameters
C--------I------I-----I------------------------------------------------
C ISPARM I  R   I in  I set of integer scalar parameters
C        I      I     I                             array: ISPARM(NISP)
C--------I------I-----I------------------------------------------------
C NIVP   I  I   I in  I number of integer vector parameters
C--------I------I-----I------------------------------------------------
C IVPARM I  R   I in  I set of integer vector parameters :
C        I      I     I                         array: IPARM(IVP1,NIVP)
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I mask of the linear form        array: MASKF(NK)
C--------I------I-----I------------------------------------------------
C USERF  I EX   I in  I routine defining the lienar form
C--------I------I-----I------------------------------------------------
C MASKL  I  L   I in  I mask of the Frechets        array: MASKL(NK,NK)
C--------I------I-----I------------------------------------------------
C USERL  I EX   I in  I routine defining the Frechet
C--------I------I-----I------------------------------------------------
C X      I  R   I in  I points in the elements       array: X(ELM1,DIM)
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I solution in the elements      array: U(ELM1,NK)
C--------I------I-----I------------------------------------------------
C UT     I  R   I in  I derivative of the solution with respect to
C        I      I     I T in the elements           array: UT(ELM1T,NK)
C        I      I     I (for the steady case it is ELM1T=0 !)
C--------I------I-----I------------------------------------------------
C ENOP   I  R   I in  I node parameters in the elements
C        I      I     I                           array: ENOP(ELM1,NOP)
C--------I------I-----I------------------------------------------------
C TAU    I  R   I in  I directions in the tangential hyperspace
C        I      I     I                      array: TAU(ELM1,DIM,CLASS)
C--------I------I-----I------------------------------------------------
C DUDX   I  R   I in  I derivative of solution in the elements
C        I      I     I                      array: DUDX(ELM1,NK,CLASS)
C--------I------I-----I------------------------------------------------
C DUTDX  I  R   I in  I derivative of derivative of the solution with
C        I      I     I respect to T in the elements
C        I      I     I                    array: DUTDX(ELM1T,NK,CLASS)
C--------I------I-----I------------------------------------------------
C DNOPDX I  R   I in  I derivative of the node parameters in the
C        I      I     I elements          array: DNOPDX(ELM1,NOP,CLASS)
C--------I------I-----I------------------------------------------------
C LIST   I  I   I  -  I list of the elements which fail
C--------I------I-----I------------------------------------------------
C FX     I  R   I  -  I coefficients of the linear form
C        I      I     I               arrays: F0(ELM1),F1(ELM1,CLASS),
C        I      I     I                       F0H(ELM1),F1H(ELM1,CLASS)
C--------I------I-----I------------------------------------------------
C LX     I  R   I     I coefficients of the Frechets
C        I      I     I   array: L3(ELM1,DIM,DIM),L3H(ELM1,DIM,DIM)
C        I      I     I          L2(ELM1,DIM),    L2H(ELM1,DIM)
C        I      I     I          L1(ELM1,DIM),    L1H(ELM1,DIM)
C        I      I     I          L0(ELM1),        L0H(ELM1)
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I unit of line out
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I the first OUTCNT failed elements are printed
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number : = 5980 incorrect masks
C        I      I     I                = 5981 incorrect Frechets
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           COMP1,COMP2,J1,J2,J,K,Z,LAST,OUT2,RHS,NFAIL
      LOGICAL           CONTRI,COUPLE
      DOUBLE PRECISION  ZERO,ONE,SYMZ,SYMQ,AZERO,QUOLIM,INCU
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LAST=0
      RHS=1
      ZERO=0.0
      ONE =1.0
      SYMZ=100*EPS
      SYMQ=SQRT(EPS)
      OUT2=MIN(OUTCNT,NE)
      QUOLIM=0.01
      AZERO=1.D-4
      ERR=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of test function loop :                                 ***
C**   ---------------------------                                   ***
C**                                                                 ***
      DO 500 COMP1=1,NK

        DO 10 Z=1,NE
          F0(Z)=ZERO
          F0H(Z)=ZERO
10      CONTINUE
        DO 15 K=1,CLASS
          DO 15 Z=1,NE
            F1(Z,K)=ZERO
15      CONTINUE
C**                                                                 ***
C****** set F :                                                     ***
C**     -----                                                       ***
C**                                                                 ***
        CALL USERF(T,GROUP,CLASS,COMP1,RHS,LAST,
     &             NE,ELM1,DIM,X,TAU,NK,U,DUDX,
     &             ELM1T,UT,DUTDX,NOP,ENOP,DNOPDX,
     &             NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &             NISP,ISPARM,NIVP,IVP1,IVPARM,F1,F0)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** is F nonzero ?                                              ***
C**     -------------                                               ***
C**                                                                 ***
        CONTRI=.FALSE.

        CALL VEM900(ZERO,EPS,EPS,NE,F0(1),F0H(1),NFAIL,LIST)
        IF (NFAIL.GT.0) THEN
          CONTRI=.TRUE.
        ENDIF
        DO 25 K=1,CLASS
          IF (.NOT.CONTRI) THEN
             CALL VEM900(ZERO,EPS,EPS,NE,F1(1,K),F0H(1),NFAIL,LIST)
             IF (NFAIL.GT.0) THEN
              CONTRI=.TRUE.
            ENDIF
          ENDIF
25      CONTINUE
C**                                                                 ***
C****** print message:                                              ***
C**     -------------                                               ***
C**                                                                 ***
        IF (.NOT.(MASKF(COMP1).EQV.CONTRI)) THEN
          ERR=MAX(ERR,5980)
          IF (MASKF(COMP1)) THEN
           WRITE(LOUT,9000) GROUP,COMP1
          ELSE
           WRITE(LOUT,9010) GROUP,COMP1,GROUP,COMP1
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** start of solution loop :                                    ***
C**     ----------------------                                      ***
C**                                                                 ***
        DO 510 COMP2=1,NK
C**                                                                 ***
C******** initialize L :                                            ***
C**       -------------                                             ***
C**                                                                 ***
          DO 100 J1=1,CLASS
            DO 100 J2=1,CLASS
              DO 100 Z=1,NE
                L3 (Z,J1,J2)=ZERO
                L3H(Z,J1,J2)=ZERO
  100     CONTINUE
          DO 101 J1=1,CLASS
            DO 101 Z=1,NE
              L2(Z,J1)=ZERO
              L1(Z,J1)=ZERO
              L2H(Z,J1)=ZERO
              L1H(Z,J1)=ZERO
  101     CONTINUE
          DO 102 Z=1,NE
             L0(Z)=ZERO
             L0H(Z)=ZERO
             F0H(Z)=ZERO
  102     CONTINUE
C**                                                                 ***
C******** set L :                                                   ***
C**       ------                                                    ***
C**                                                                 ***
          CALL USERL(T,GROUP,CLASS,COMP1,COMP2,LAST,
     &               NE,ELM1,DIM,X,TAU,NK,U,DUDX,
     &               ELM1T,UT,DUTDX,NOP,ENOP,DNOPDX,
     &               NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &               NISP,ISPARM,NIVP,IVP1,IVPARM,
     &               L3,L2,L1,L0)
          CALL USERL(T,GROUP,CLASS,COMP2,COMP1,LAST,
     &               NE,ELM1,DIM,X,TAU,NK,U,DUDX,
     &               ELM1T,UT,DUTDX,NOP,ENOP,DNOPDX,
     &               NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &               NISP,ISPARM,NIVP,IVP1,IVPARM,
     &               L3H,L2H,L1H,L0H)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** test of mask and symmetry :                               ***
C**       -------------------------                                 ***
C**                                                                 ***
          COUPLE=.FALSE.

          DO 200 J1=1,CLASS
            DO 200 J2=1,CLASS

              IF (.NOT.COUPLE) THEN
                CALL VEM900(ZERO,EPS,EPS,NE,L3(1,J1,J2),
     &                                             F0H(1),NFAIL,LIST)
                IF (NFAIL.GT.0) THEN
                 COUPLE=.TRUE.
                ENDIF
              ENDIF

              IF (SYM) THEN
                CALL VEM900(SYMZ,SYMQ,EPS,NE,L3(1,J1,J2),
     &                                      L3H(1,J2,J1),NFAIL,LIST)
                IF (NFAIL.GT.0) THEN
                 SYM=.FALSE.
                ENDIF
              ENDIF

 200      CONTINUE
          DO 220 J1=1,CLASS
              IF (.NOT.COUPLE) THEN
                CALL VEM900(ZERO,EPS,EPS,NE,L2(1,J1),F0H(1),NFAIL,LIST)
                IF (NFAIL.GT.0) THEN
                 COUPLE=.TRUE.
                ENDIF
              ENDIF

              IF (.NOT.COUPLE) THEN
                CALL VEM900(ZERO,EPS,EPS,NE,L1(1,J1),F0H(1),NFAIL,LIST)
                IF (NFAIL.GT.0) THEN
                 COUPLE=.TRUE.
                ENDIF
              ENDIF

              IF (SYM) THEN
                CALL VEM900(SYMZ,SYMQ,EPS,NE,L2(1,J1),
     &                                           L1H(1,J1),NFAIL,LIST)
                IF (NFAIL.GT.0) THEN
                 SYM=.FALSE.
                ENDIF
              ENDIF

 220      CONTINUE
          IF (.NOT.COUPLE) THEN
            CALL VEM900(ZERO,EPS,EPS,NE,L0(1),F0H(1),NFAIL,LIST)
            IF (NFAIL.GT.0) THEN
              COUPLE=.TRUE.
            ENDIF
          ENDIF
          IF (SYM) THEN
            CALL VEM900(SYMZ,SYMQ,EPS,NE,L0(1),L0H(1),NFAIL,LIST)
            IF (NFAIL.GT.0) THEN
              SYM=.FALSE.
            ENDIF
          ENDIF
C**                                                                 ***
C******** print message :                                           ***
C**       -------------                                             ***
C**                                                                 ***
          IF (.NOT.(MASKL(COMP1,COMP2).EQV.COUPLE)) THEN
            ERR=MAX(ERR,5980)
            IF (MASKL(COMP1,COMP2)) THEN
              WRITE(LOUT,9020) GROUP,COMP1,COMP2
            ELSE
              WRITE(LOUT,9030) GROUP,COMP1,COMP2,GROUP,COMP1,COMP2
            ENDIF
          ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** perturbation for comp2-th component of u:                 ***
C**       ----------------------------------------                  ***
C**      (skipped if DU=0)                                          ***
C**                                                                 ***
         IF (DU.NE.ZERO) THEN

           DO 230 Z=1,NE
             F0H(Z)=ZERO
 230       CONTINUE
           DO 231 K=1,CLASS
             DO 231 Z=1,NE
               F1H(Z,K)=ZERO
 231       CONTINUE
C**                                                                 ***
C*********** DUDX2 is used as perturbated U !                       ***
C**                                                                 ***
             DO 250 K=1,NK

               IF (K.EQ.COMP2) THEN
                 INCU=DU
               ELSE
                 INCU=ZERO
               ENDIF

               IF (.NOT.DFDUT) THEN
                 DO 255 Z=1,NE
                   DUDX2(Z,K,1)=U(Z,K)+INCU
 255             CONTINUE
               ELSE
                 DO 256 Z=1,NE
                   DUDX2(Z,K,1)=UT(Z,K)+INCU
 256             CONTINUE
               ENDIF

250         CONTINUE
C**                                                                 ***
C********** set F for perturbated U/UT:                             ***
C**         --------------------------                              ***
C**                                                                 ***
            IF (.NOT.DFDUT) THEN
              CALL USERF(T,GROUP,CLASS,COMP1,RHS,LAST,
     &                   NE,ELM1,DIM,X,TAU,NK,DUDX2,DUDX,
     &                   ELM1T,UT,DUTDX,NOP,ENOP,DNOPDX,
     &                   NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                   NISP,ISPARM,NIVP,IVP1,IVPARM,F1H,F0H)
            ELSE
              CALL USERF(T,GROUP,CLASS,COMP1,RHS,LAST,
     &                   NE,ELM1,DIM,X,TAU,NK,U,DUDX,
     &                   ELM1T,DUDX2,DUTDX,NOP,ENOP,DNOPDX,
     &                   NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                   NISP,ISPARM,NIVP,IVP1,IVPARM,F1H,F0H)
            ENDIF
C**                                                                 ***
C********** calculate difference quotient                           ***
C**         -----------------------------                           ***
C**                                                                 ***
            DO 260 J=1,CLASS
              DO 260 Z=1,NE
                L2H(Z,J)=(F1H(Z,J)-F1(Z,J))/DU
 260        CONTINUE
            DO 280 Z=1,NE
               L0H(Z)=(F0H(Z)-F0(Z))/DU
 280        CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** perturbation for COMP2-th component of DUDX :           ***
C**         -------------------------------------------             ***
C**                                                                 ***
            DO 300 J1=1,CLASS

              DO 301 J=1,CLASS
                DO 301 K=1,NK

                  IF ((K.EQ.COMP2).AND.(J.EQ.J1)) THEN
                    INCU=DU
                  ELSE
                    INCU=ZERO
                  ENDIF

                  IF (.NOT.DFDUT) THEN
                    DO 302 Z=1,NE
                       DUDX2(Z,K,J)=DUDX(Z,K,J)+INCU
  302               CONTINUE
                  ELSE
                    DO 303 Z=1,NE
                      DUDX2(Z,K,J)=DUTDX(Z,K,J)+INCU
  303               CONTINUE
                  ENDIF

 301          CONTINUE
C**                                                                 ***
C************ set F :                                               ***
C**           ------                                                ***
C**                                                                 ***
              DO 310 Z=1,NE
                F0H(Z)=ZERO
 310          CONTINUE
              DO 311 K=1,CLASS
                DO 311 Z=1,NE
                  F1H(Z,K)=ZERO
 311          CONTINUE

              IF (.NOT.DFDUT) THEN
                CALL USERF(T,GROUP,CLASS,COMP1,RHS,LAST,
     &                     NE,ELM1,DIM,X,TAU,NK,U,DUDX2,
     &                     ELM1T,UT,DUTDX,NOP,ENOP,DNOPDX,
     &                     NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                     NISP,ISPARM,NIVP,IVP1,IVPARM,F1H,F0H)
              ELSE
                CALL USERF(T,GROUP,CLASS,COMP1,RHS,LAST,
     &                     NE,ELM1,DIM,X,TAU,NK,U,DUDX,
     &                     ELM1T,UT,DUDX2,NOP,ENOP,DNOPDX,
     &                     NRSP,RSPARM,NRVP,RVP1,RVPARM,
     &                     NISP,ISPARM,NIVP,IVP1,IVPARM,F1H,F0H)
              ENDIF
C**                                                                 ***
C************ calculate difference quotient                         ***
C**           -----------------------------                         ***
C**                                                                 ***
              DO 330 J=1,CLASS
                DO 330 Z=1,NE
                  L3H(Z,J,J1)=(F1H(Z,J)-F1(Z,J))/DU
 330          CONTINUE
              DO 340 Z=1,NE
                L1H(Z,J1)=(F0H(Z)-F0(Z))/DU
 340          CONTINUE

 300        CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** check Frechet derivatives :                             ***
C**         -------------------------                               ***
C**                                                                 ***
            DO 400 J1=1,CLASS
              DO 400 J2=1,CLASS
                CALL VEM900(AZERO,QUOLIM,EPS,NE,L3H(1,J1,J2),
     &                                           L3(1,J1,J2),NFAIL,LIST)
                IF (NFAIL.GT.0) THEN
                  ERR=5981
                  IF (DFDUT) THEN
                    WRITE(LOUT,9160) GROUP,COMP1,COMP2,J1,COMP2,J2
                  ELSE
                    WRITE(LOUT,9060) GROUP,COMP1,COMP2,J1,COMP2,J2
                  ENDIF
                  WRITE(LOUT,9080) (LIST(Z),L3H(LIST(Z),J1,J2),
     &                         L3(LIST(Z),J1,J2),Z=1,MIN(NFAIL,OUT2))
                  WRITE(LOUT,9090) NFAIL
                ENDIF

400         CONTINUE

            DO 410 J1=1,CLASS
              CALL VEM900(AZERO,QUOLIM,EPS,NE,L2H(1,J1),
     &                                           L2(1,J1),NFAIL,LIST)
              IF (NFAIL.GT.0) THEN
                ERR=5981
                IF (DFDUT) THEN
                  WRITE(LOUT,9140) GROUP,COMP1,COMP2,J1,COMP2
                ELSE
                  WRITE(LOUT,9040) GROUP,COMP1,COMP2,J1,COMP2
                ENDIF
                WRITE(LOUT,9080) (LIST(Z),L2H(LIST(Z),J1),
     &                               L2(LIST(Z),J1),Z=1,MIN(NFAIL,OUT2))
                WRITE(LOUT,9090) NFAIL
              ENDIF
410         CONTINUE

            DO 420 J1=1,CLASS
              CALL VEM900(AZERO,QUOLIM,EPS,NE,L1H(1,J1),
     &                                           L1(1,J1),NFAIL,LIST)
              IF (NFAIL.GT.0) THEN
                ERR=5981
                IF (DFDUT) THEN
                  WRITE(LOUT,9170) GROUP,COMP1,COMP2,COMP2,J1
                ELSE
                  WRITE(LOUT,9070) GROUP,COMP1,COMP2,COMP2,J1
                ENDIF
                WRITE(LOUT,9080) (LIST(Z),L1H(LIST(Z),J1),
     &                             L1(LIST(Z),J1),Z=1,MIN(NFAIL,OUT2))
                WRITE(LOUT,9090) NFAIL
              ENDIF
420         CONTINUE

            CALL VEM900(AZERO,QUOLIM,EPS,NE,L0H(1),L0(1),NFAIL,LIST)
            IF (NFAIL.GT.0) THEN
              ERR=5981
              IF (DFDUT) THEN
                WRITE(LOUT,9150) GROUP,COMP1,COMP2,COMP2
              ELSE
                WRITE(LOUT,9050) GROUP,COMP1,COMP2,COMP2
              ENDIF
              WRITE(LOUT,9080) (LIST(Z),L0H(LIST(Z)),
     &                             L0(LIST(Z)),Z=1,MIN(NFAIL,OUT2))
              WRITE(LOUT,9090) NFAIL
            ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
          ENDIF
 510    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
500   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9000  FORMAT(/'  Group ',I3,': The linear form for COMPV=',I3,
     &                               ' is zero but the mask is true.'
     &      /13X,'Please check whether you can set it false.')
9010  FORMAT('>>VEMCD:31:0006:',I3,':',I3
     &      /'>>Group ',I3,': The linear form for COMPV=',I3,
     &                           ' is nonzero but the mask is false.'
     &      /'>>Please correct the mask entry.')
9020  FORMAT(/'  Group ',I3,': The Frechet derivative for COMPV=',I3,
     &                                    ' and COMPU=',I3,' is zero'
     &      /13X,'but the mask is true.',
     &                 ' Please check whether you can set it false.')
9030  FORMAT('>>VEMCD:31:0007:',I3,':',I3,':',I3
     &      /'>>Group ',I3,': The Frechet derivative for COMPV=',I3,
     &                                  ' and COMPU=',I3,' is nonzero'
     &      /'>>but the mask is false. Please correct the mask ',
     &                                                       'entry.')

9040  FORMAT('>>VEMCD:31:0005'
     &      /'>>Group ',I3,', COMPV=',I3,', COMPU=',I3,' :'
     &      /'>>incorrect Frechet derivatives of F1(',I3,') ',
     &                                    'with respect to U(',I3,')')
9050  FORMAT('>>VEMCD:31:0005'
     &      /'>>Group ',I3,', COMPV=',I3,', COMPU=',I3,' :'
     &      /'>>incorrect Frechet derivatives of F0 ',
     &                                    'with respect to U(',I3,')')
9060  FORMAT('>>VEMCD:31:0005'
     &      /'>>Group ',I3,', COMPV=',I3,', COMPU=',I3,' :'
     &      /'>>incorrect Frechet derivatives of F1(',I3,') ',
     &                        'with respect to DU(',I3,')/DX(',I3,')')
9070  FORMAT('>>VEMCD:31:0005'
     &      /'>>Group ',I3,', COMPV=',I3,', COMPU=',I3,' :'
     &      /'>>incorrect Frechet derivatives of F0 ',
     &                        'with respect to DU(',I3,')/DX(',I3,')')
9140  FORMAT('>>VEMCD:31:0005'
     &      /'>>Group ',I3,', COMPV=',I3,', COMPU=',I3,' :'
     &      /'>>incorrect Frechet derivatives of F1(',I3,') ',
     &                                   'with respect to UT(',I3,')')
9150  FORMAT('>>VEMCD:31:0005'
     &      /'>>Group ',I3,', COMPV=',I3,', COMPU=',I3,' :'/
     &      /'>>incorrect Frechet derivatives of F0 ',
     &                                   'with respect to UT(',I3,')')
9160  FORMAT('>>VEMCD:31:0005'
     &      /'>>Group ',I3,', COMPV=',I3,', COMPU=',I3,' :'
     &      /'>>incorrect Frechet derivatives of F1(',I3,') ',
     &                       'with respect to DUT(',I3,')/DX(',I3,')')
9170  FORMAT('>>VEMCD:31:0005'
     &      /'>>Group ',I3,', COMPV=',I3,', COMPU=',I3,' :'
     &      /'>>incorrect Frechet derivatives of F0 ',
     &                       'with respect to DUT(',I3,')/DX(',I3,')')

9080  FORMAT('>>Element ',I9,': '/
     &       '>>  numerical Frechet derivative :',G12.4/
     &       '>>  from user routine            :',G12.4)
9090  FORMAT ('>>',I9,' Frechets are incorrect.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM598----------------------------------------------------
      E    N    D
