C:::::      ,,,,,VEM600...                                          ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM600(LIVEM,IVEM,NLNGTH,DISCHK,ERR,OUTCNT,LOUT,
     &                  MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM600     check mesh parameters                             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           LIVEM,DISCHK,ERR,OUTCNT,LOUT,MYPROC,NPROC,NMSG
      INTEGER           IVEM(LIVEM),TIDS(NPROC),NLNGTH(16)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C LIVEM  I  I   I in  I length of integer info vector
C--------I------I-----I------------------------------------------------
C IVEM   I  I   I in  I integer info vector          array: IVEM(LIVEM)
C--------I------I-----I------------------------------------------------
C NLNGTH I  I   I out I needed length of the mesh arrays
C        I      I     I                               array: NLNGTH(15)
C        I      I     I NLNGTH(1)=NIVEM
C        I      I     I NLNGTH(2)=NRVEM
C        I      I     I NLNGTH(3)=NLVEM
C        I      I     I NLNGTH(4)=NBIG
C        I      I     I NLNGTH(5)=NNODN
C        I      I     I NLNGTH(6)=NNOD
C        I      I     I NLNGTH(7)=NNOPRM
C        I      I     I NLNGTH(8)=NNEK
C        I      I     I NLNGTH(9)=NIPARM
C        I      I     I NLNGTH(10)=NRPARM
C        I      I     I NLNGTH(11)=NDNOD
C        I      I     I NLNGTH(14)=NIDPRM
C        I      I     I NLNGTH(13)=NRDPRM
C        I      I     I NLNGTH(14)=NU
C        I      I     I NLNGTH(15)=NCU
C        I      I     I NLNGTH(16)=NUG
C--------I------I-----I------------------------------------------------
C DISCHK I  I   I in  I  =1  VEMDIS call is checked
C        I      I     I  =0  no check
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I output unit
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error codes (is not global !)
C        I      I     I              =95 array too small
C        I      I     I              =99 fatal error
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                     array: TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           MESH,NGROUP,M,NK,DIM,NN,GINFO,GINFO1,
     &                  DINFO,DINFO1,NE,GEOTYP,FORM,CLASS,ADDGEO,GEO1,
     &                  NINFO,NOP1,NOP,ADRSP,NRSP,ADRVP,RVP1,NRVP,ADISP,
     &                  NISP,ADIVP,IVP1,NIVP,NDC,ADDCG,ADRSDP,NRSDP,
     &                  ADRVDP,RVDP1,NRVDP,ADISDP,NISDP,ADIVDP,IVDP1,
     &                  NIVDP,NIVEM,NNEK,NRPRM,NIPRM,NDNOD,NRDPRM,LOLEN,
     &                  NIDPRM,START,G,D,I,J,OWN,ADDC,NDEG,GM,GNDEG,
     &                  TOTNT,NK2,NEK1,ADDNEK,MYTID,GLLEN,
     &                  DIS,SORTI,IWORK,LM,P,NJUMP,NINFO1
      EXTERNAL          VEM938
      include "bytes.h"
      include "maxnpe.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MESH=IVEM(1)
      DO 815 I=1,16
815    NLNGTH(I)=0
      NDEG  =IVEM(MESH+1)
      NK    =IVEM(MESH+2)
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      NOP1  =IVEM(MESH+13)
      NOP   =IVEM(MESH+14)
      OWN   =IVEM(MESH+15)
      DIS   =IVEM(MESH+18)
      NK2   = MAX(OWN,1)
      GINFO =IVEM(MESH+21)
      GINFO1=IVEM(MESH+22)
      DINFO =IVEM(MESH+23)
      DINFO1=IVEM(MESH+24)
      MYTID=TIDS(MYPROC)

      IF (DIS.EQ.220964) THEN
	SORTI=IVEM(MESH+19)
	NINFO1=SORTI+1+3*NPROC+NGROUP+IVEM(MESH+SORTI+1)
	M=IVEM(MESH+SORTI+1+NPROC+MYPROC)
	NJUMP=IVEM(MESH+SORTI)
	LM=0
	DO  9 P=1,NPROC
9         LM=MAX(LM,IVEM(MESH+NPROC+SORTI+1+P))
      ELSE
	M=0
	LM=0
	NJUMP=0
        NINFO1=MAX(GINFO+GINFO1*NGROUP,DINFO+DINFO1*NK)
      ENDIF
      NINFO=NINFO1+3*(2+NGROUP+NK)+1
      NIVEM=MESH+NINFO
      GLLEN=MESH+NINFO1+1
      IVEM(MESH+25)=GLLEN

      LOLEN=GLLEN+2+NGROUP+NK
      IWORK=LOLEN+2+NGROUP+NK
      IVEM(MESH+16)=LM
      ERR=0
      IF ((LM.GT.MAXL).OR.(NPROC.GT.MAXNPE)) THEN
	ERR=99
        WRITE(LOUT,9321)
      ENDIF

      IF (NIVEM.GT.LIVEM) ERR=95
      IF (MESH.LT.203+NPROC) THEN
        ERR=99
        WRITE(LOUT,9300) MYPROC,MYTID,MESH,203,203+NPROC
      ENDIF
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** global number of elements :                                   ***
C**   --------------------------                                    ***
C**                                                                 ***
      IVEM(LOLEN  )=NDEG
      IVEM(LOLEN+1)=M
      START=MESH+GINFO
      DO 11 G=1,NGROUP
11    IVEM(LOLEN+1+G)=IVEM(START+GINFO1*(G-1)   )
      START=MESH+DINFO
      DO 12 D=1,NK
12    IVEM(LOLEN+1+NGROUP+D)=IVEM(START+DINFO1*(D-1)   )
      DO 13 D=0,1+NGROUP+NK
13      IVEM(GLLEN+D)=IVEM(LOLEN+D)
      CALL LL4RED(VEM938,IVEM(IWORK),IVEM(GLLEN),(2+NGROUP+NK)*IINT,
     &            MYPROC,NPROC,TIDS,NMSG)
      GNDEG=IVEM(GLLEN)
      GM=IVEM(GLLEN+1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** show integer parameters :                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        WRITE(LOUT,9000)
        WRITE(LOUT,9121) GNDEG
        WRITE(LOUT,9130) NK
        WRITE(LOUT,9140) DIM
        WRITE(LOUT,9150) NGROUP
        WRITE(LOUT,9167) NOP
        WRITE(LOUT,9168) OWN
        IF (OWN.LE.0) THEN
           WRITE(LOUT,9191)
        ELSEIF (OWN.LT.NK) THEN
           WRITE(LOUT,9193)
        ELSE
           WRITE(LOUT,9192)
        ENDIF
        WRITE(LOUT,9194) DIS
        IF (DIS.EQ.220964) THEN
           WRITE(LOUT,9195)
        ELSE
           WRITE(LOUT,9196)
	ENDIF
        IF (DIS.EQ.220964) WRITE(LOUT,9120) GM
        IF (DIS.EQ.220964) WRITE(LOUT,9122) LM
        IF (DIS.EQ.220964) WRITE(LOUT,9198) NJUMP
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check integer parameters :                                    ***
C**   -------------------------                                     ***
C**                                                                 ***
      IF ((DIS.NE.220964).AND.(DISCHK.NE.0)) THEN
        ERR=99
        WRITE(LOUT,9305) MYPROC,MYTID
      ENDIF

      IF (NN.LT.NDEG) THEN
        ERR=99
        WRITE(LOUT,9341) MYPROC,MYTID,NN,NDEG
      ENDIF

      IF (NOP1*NOP.LT.NDEG*NOP) THEN
        ERR=99
        WRITE(LOUT,9342) MYPROC,MYTID,NOP1,NDEG
      ENDIF

      IF (NK.LE.0) THEN
        ERR=99
        WRITE(LOUT,9310) MYPROC,MYTID,NK
      ENDIF

      IF ((DIM.LE.0).OR.(DIM.GT.4)) THEN
        ERR=99
        WRITE(LOUT,9320) MYPROC,MYTID,DIM
      ENDIF

      IF (NGROUP.LE.0) THEN
        ERR=99
        WRITE(LOUT,9330) MYPROC,MYTID,NGROUP
      ENDIF

      IF (OWN.LT.0) THEN
        ERR=99
        WRITE(LOUT,9351) MYPROC,MYTID,OWN
      ENDIF

      IF ((OWN.GT.1).AND.(OWN.NE.NK)) THEN
        ERR=99
        WRITE(LOUT,9352) MYPROC,MYTID,OWN,NK
      ENDIF

      IF (GINFO.LT.30) THEN
        ERR=99
        WRITE(LOUT,9360) MYPROC,MYTID,GINFO
      ENDIF

      IF (GINFO1.LT.23+2*NK) THEN
        ERR=99
        WRITE(LOUT,9371) MYPROC,MYTID,GINFO1,2*NK+23
      ENDIF

      IF (DINFO.LT.GINFO+GINFO1*NGROUP) THEN
        ERR=99
        WRITE(LOUT,9380) MYPROC,MYTID,DINFO,GINFO+GINFO1*NGROUP
      ENDIF

      IF (DINFO1.LT.13) THEN
        ERR=99
        WRITE(LOUT,9390) MYPROC,MYTID,DINFO1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set default management informations :                         ***
C**   -----------------------------------                           ***
C**                                                                 ***
      START=MESH+GINFO
      IF ((OWN.EQ.0).AND.(DIS.NE.220964)) THEN
        DO 102 G=1,NGROUP
          IVEM(START+GINFO1*(G-1)+23+NK)=0
          IVEM(START+GINFO1*(G-1)+4)=IVEM(START+GINFO1*(G-1)+20)
          IVEM(START+GINFO1*(G-1)+5)=IVEM(START+GINFO1*(G-1)+21)
          IVEM(START+GINFO1*(G-1)+1)=IVEM(START+GINFO1*(G-1)+23)
 102    CONTINUE
      ENDIF
      DO 101 G=1,NGROUP
         TOTNT =0
         DO 100 I=1,NK2
           TOTNT =TOTNT+IVEM(START+GINFO1*(G-1)+22+I)
 100     CONTINUE

c IF (TOTNT*IVEM(START+GINFO1*(G-1))*
c     &                       IVEM(START+GINFO1*(G-1)+1).EQ.0) THEN
c           TOTNT=0
cc	   IVEM(START+GINFO1*(G-1))=0
c	   IVEM(START+GINFO1*(G-1)+1)=0
c         ENDIF

         IVEM(START+GINFO1*(G-1)+22)=TOTNT
         IVEM(START+GINFO1*(G-1)+ 6)=0

	 IF (IVEM(START+GINFO1*(G-1)+ 8).EQ.0) THEN
           IVEM(START+GINFO1*(G-1)+ 7)=1
         ENDIF
         IF (IVEM(START+GINFO1*(G-1)+11).EQ.0) THEN
           IVEM(START+GINFO1*(G-1)+ 9)=1
           IVEM(START+GINFO1*(G-1)+10)=0
         ENDIF
         IF (IVEM(START+GINFO1*(G-1)+13).EQ.0) THEN
           IVEM(START+GINFO1*(G-1)+12)=1
         ENDIF
         IF (IVEM(START+GINFO1*(G-1)+16).EQ.0) THEN
           IVEM(START+GINFO1*(G-1)+14)=1
           IVEM(START+GINFO1*(G-1)+15)=0
         ENDIF

 101  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** show element groups :                                         ***
C**   -------------------                                           ***
C**                                                                 ***
      IF ((OUTCNT.NE.0).AND.(NGROUP.GT.0)) THEN

         WRITE(LOUT,9500)

         WRITE(LOUT,9510)
         DO 20 G=1,NGROUP
           WRITE(LOUT,9520) G,IVEM(GLLEN+1+G),
     &                         (IVEM(START+J+GINFO1*(G-1)),J=1,3),
     &                           IVEM(START+22+GINFO1*(G-1))
20       CONTINUE

         DO 25 I=1,NK2,5
           WRITE(LOUT,9544) (J,J=I,MIN(NK2,I+4))
           WRITE(LOUT,9546)
           DO 25 G=1,NGROUP
              WRITE(LOUT,9545) G,(IVEM(START+J+GINFO1*(G-1)),
     &            IVEM(START+J+NK+GINFO1*(G-1)),J=22+I,22+MIN(NK2,I+4))
25       CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check element groups :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      NNEK  =0
      NRPRM =0
      NIPRM =0

      IF (NGROUP.GT.0) THEN

         DO 30 G=1,NGROUP

           NE     = IVEM(START+GINFO1*(G-1)   )
           GEOTYP = IVEM(START+GINFO1*(G-1)+ 1)
           FORM   = IVEM(START+GINFO1*(G-1)+ 2)
           CLASS  = IVEM(START+GINFO1*(G-1)+ 3)

           ADRSP  = IVEM(START+GINFO1*(G-1)+ 7)
           NRSP   = IVEM(START+GINFO1*(G-1)+ 8)
           ADRVP  = IVEM(START+GINFO1*(G-1)+ 9)
           RVP1   = IVEM(START+GINFO1*(G-1)+10)
           NRVP   = IVEM(START+GINFO1*(G-1)+11)

           ADISP  = IVEM(START+GINFO1*(G-1)+12)
           NISP   = IVEM(START+GINFO1*(G-1)+13)
           ADIVP  = IVEM(START+GINFO1*(G-1)+14)
           IVP1   = IVEM(START+GINFO1*(G-1)+15)
           NIVP   = IVEM(START+GINFO1*(G-1)+16)

           ADDNEK = IVEM(START+GINFO1*(G-1)+20)
           NEK1   = IVEM(START+GINFO1*(G-1)+21)
           TOTNT  = IVEM(START+GINFO1*(G-1)+22)
	
	   IF ((OWN.EQ.0).AND.(DIS.NE.220964)) THEN
             ADDGEO = ADDNEK
             GEO1   = NEK1
	   ELSE
             ADDGEO = IVEM(START+GINFO1*(G-1)+ 4)
             GEO1   = IVEM(START+GINFO1*(G-1)+ 5)
	   ENDIF
C**                                                                 ***
C********* check structure :                                        ***
C**        ---------------                                          ***
C**                                                                 ***
           IF (NE.GT.GEO1) THEN
             WRITE(LOUT,9730) MYPROC,MYTID,G,GEO1,NE
             ERR=99
           ENDIF

           IF (NE.GT.NEK1) THEN
             WRITE(LOUT,9700) MYPROC,MYTID,G,NEK1,NE
             ERR=99
           ENDIF

           IF (NE*NRVP.GT.RVP1*NRVP) THEN
             WRITE(LOUT,9710) MYPROC,MYTID,G,RVP1,NE
             ERR=99
           ENDIF

           IF (NE*NIVP.GT.IVP1*NIVP) THEN
             WRITE(LOUT,9720) MYPROC,MYTID,G,IVP1,NE
             ERR=99
           ENDIF
C**                                                                 ***
C********* minimal lengths of mesh arrays :                         ***
C**        ------------------------------                           ***
C**                                                                 ***
           NNEK  =MAX(NNEK,ADDGEO-1+GEO1*GEOTYP,ADDNEK-1+NEK1*TOTNT)
           NRPRM =MAX(NRPRM,ADRSP-1+NRSP,ADRVP-1+NRVP*RVP1)
           NIPRM =MAX(NIPRM,ADISP-1+NISP,ADIVP-1+NIVP*IVP1)

30       CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** show Dirichlet conditions :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
      IF ((OUTCNT.NE.0).AND.(NK.GT.0)) THEN
         WRITE(LOUT,9560)
         WRITE(LOUT,9565)
         DO 40 D=1,NK
           WRITE(LOUT,9566) D,IVEM(GLLEN+1+NGROUP+D)
40       CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check Dirichlet condtions :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
      NDNOD  =0
      NRDPRM =0
      NIDPRM =0

      IF (NK.GT.0) THEN

	 START=MESH+DINFO
         DO 50 D=1,NK

           IF (IVEM(START+DINFO1*(D-1)+ 4).EQ.0) THEN
             IVEM(START+DINFO1*(D-1)+ 3)=1
           ENDIF
           IF (IVEM(START+DINFO1*(D-1)+ 7).EQ.0) THEN
             IVEM(START+DINFO1*(D-1)+ 5)=1
             IVEM(START+DINFO1*(D-1)+ 6)=0
           ENDIF
           IF (IVEM(START+DINFO1*(D-1)+ 9).EQ.0) THEN
             IVEM(START+DINFO1*(D-1)+ 8)=1
           ENDIF
           IF(IVEM(START+DINFO1*(D-1)+12).EQ.0) THEN
             IVEM(START+DINFO1*(D-1)+10)=1
             IVEM(START+DINFO1*(D-1)+11)=0
           ENDIF

           NDC  = IVEM(START+DINFO1*(D-1)   )
           ADDC= IVEM(START+DINFO1*(D-1)+2)
           IF ((OWN.EQ.0).AND.(DIS.NE.220964)) THEN
             IVEM(START+DINFO1*(D-1)+1)=IVEM(START+DINFO1*(D-1)+2)
           ENDIF
           ADDCG = IVEM(START+DINFO1*(D-1)+1)

           ADRSDP = IVEM(START+DINFO1*(D-1)+ 3)
           NRSDP  = IVEM(START+DINFO1*(D-1)+ 4)
           ADRVDP = IVEM(START+DINFO1*(D-1)+ 5)
           RVDP1  = IVEM(START+DINFO1*(D-1)+ 6)
           NRVDP  = IVEM(START+DINFO1*(D-1)+ 7)

           ADISDP = IVEM(START+DINFO1*(D-1)+ 8)
           NISDP  = IVEM(START+DINFO1*(D-1)+ 9)
           ADIVDP = IVEM(START+DINFO1*(D-1)+10)
           IVDP1  = IVEM(START+DINFO1*(D-1)+11)
           NIVDP  = IVEM(START+DINFO1*(D-1)+12)
C**                                                                 ***
C********* check structure :                                        ***
C**        ---------------                                          ***
C**                                                                 ***
           IF (NDC*NRVDP.GT.RVDP1*NRVDP) THEN
             WRITE(LOUT,9750) MYPROC,MYTID,D,RVDP1,NDC
             ERR=99
           ENDIF

           IF (NDC*NIVDP.GT.IVDP1*NIVDP) THEN
             WRITE(LOUT,9760) MYPROC,MYTID,D,IVDP1,NDC
             ERR=99
           ENDIF
C**                                                                 ***
C********* minimal lengths of Dirichlet arrays :                    ***
C**        -----------------------------------                      ***
C**                                                                 ***
           NDNOD  =MAX(NDNOD,ADDCG-1+NDC,ADDC-1+NDC)
           NRDPRM =MAX(NRDPRM,ADRSDP-1+NRSDP,ADRVDP-1+NRVDP*RVDP1)
           NIDPRM =MAX(NIDPRM,ADISDP-1+NISDP,ADIVDP-1+NIVDP*IVDP1)

50       CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check the array lengths :                                     ***
C**   -----------------------                                       ***
C**                                                                 ***
      IVEM(MESH+ 6)=NNEK
      IVEM(MESH+ 7)=NRPRM
      IVEM(MESH+ 8)=NIPRM
      IVEM(MESH+ 9)=NDNOD
      IVEM(MESH+10)=NRDPRM
      IVEM(MESH+11)=NIDPRM
      IVEM(MESH+12)=NINFO

      NLNGTH(5)=NDEG
      NLNGTH(6)=NN*DIM
      NLNGTH(7)=NOP1*NOP
      NLNGTH(8)=IVEM(MESH+6)
      NLNGTH(9)=IVEM(MESH+8)
      NLNGTH(10)=IVEM(MESH+7)
      NLNGTH(11)=IVEM(MESH+9)
      NLNGTH(12)=IVEM(MESH+11)
      NLNGTH(13)=IVEM(MESH+10)

9999  IVEM(5)=NIVEM
      NLNGTH(1)=NIVEM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
9000  FORMAT(/'  global mesh informations'
     &        /2X,24('-')/)
9120  FORMAT('    total number of unknowns ................... M =',I10)
9122  FORMAT('    maximal number of unknowns on a process ... LM =',I10)
9198  FORMAT('    number of communication jumps .......... NJUMP =',I10)
9121  FORMAT('    total number of geometrical nodes ....... NDEG =',I10)
9130  FORMAT('    number of solution components ............. NK =',I10)
9140  FORMAT('    space dimension .......................... DIM =',I10)
9150  FORMAT('    number of groups ...................... NGROUP =',I10)
9167  FORMAT('    number of node parameters ................ NOP =',I10)
9168  FORMAT('    number of proposal functions ............. OWN =',I10)
9191  FORMAT('    => isoparametrical mesh')
9192  FORMAT('    => mixed mesh')
9193  FORMAT('    => mixed mesh with identical proposal functions')
9194  FORMAT('    indicator of distributed mesh ............ DIS =',I10)
9195  FORMAT('    => distributed mesh')
9196  FORMAT('    => mesh has to be distributed')
9500  FORMAT(/'  element groups :'/)
9510  FORMAT('      group |     NE    | GEOTYP | FORM | CLASS | ',
     &                                         '  TOTNT   |'/5X,56('-'))
9520  FORMAT(7X,I4,' | ',I9,' | ',I6,' | ',I4,' | ',I5,' | ',I9,' | ')
9541  FORMAT(/'      proposal functions'/)
9546  FORMAT(6X,69('-'))
9543  FORMAT(7X,I4,' | ',3(I9,' | '),2(I5,' ->',I5))
9544  FORMAT(/'      group | NELTYP ->PRFLIB for component'
     &       /'            |  ',6(1X,I5,7X))
9545  FORMAT(7X,I4,' |  ',6(I5,' ->',I4))

9560  FORMAT(/'  Dirichlet conditions :'/)
9565  FORMAT('      component |    NDC    |'/6X,24('-'))
9566  FORMAT(8X,I7,' | ',I9,' |')

9310  FORMAT('>>VEMCD:30:0101'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>number of components NK=',I3,' must be positive !')
9320  FORMAT('>>VEMCD:30:0102'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>dimension DIM=',I3,' can be 1,2 or 3 !')
9321  FORMAT('>>VEMCD:30:0107:',
     &      /'>>You are using a VECFEM demo version.',
     &      /'>>The number of unknowns and number of processors is ',
     &                            'restricted.')
9305  FORMAT('>>VEMCD:30:0191'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>you have forgotten to call VEMDIS !')
9300  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>MESH=',I9,' must be greater than ',I4,'+NPROC=',I9,'!')
9330  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>number of groups NGROUP=',I3,' must be positive !')
9341  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>NN=',I9,' must be greater/equal NDEG=',I9,' !')
9342  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>NOP1=',I9,' must be greater/equal NDEG=',I9,' !')
9351  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>OWN=',I9,' must be nonnegative !')
9352  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>OWN=',I9,' must be equal to 1 or NK=',I5,' !')
9360  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>GINFO=',I8,' must be greater/equal 30 !')
9370  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>GINFO1=',I8,' must be greater/equal 20 !')
9371  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>GINFO=',I8,' must be greater/equal 23+2*NK=',I8,' !')
9380  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>DINFO=',I8,' must be greater/equal GINFO+',
     &                                      'GINFO1*NGROUP=',I8,' !')
9390  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>DINFO1=',I8,' must be greater/equal 13 !')
9700  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>error in group ',I3,' :'
     &      /'>>NEK1=',I8,' must be greater/equal NE=',I8,' !')
9730  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>error in group ',I3,' :'
     &      /'>>GEO1=',I8,' must be greater/equal NE=',I8,' !')
9710  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>error in group ',I3,' :'
     &      /'>>RVP1=',I8,' must be greater/equal NE=',I8,' !')
9720  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>error in group ',I3,' :'
     &      /'>>IVP1=',I8,' must be greater/equal NE=',I8,' !')
9750  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>error in Dirichlet conditions of component ',I3,' :'
     &      /'>>RVDP1=',I8,' must be greater/equal NDC=',I8,' !')
9760  FORMAT('>>VEMCD:30:0190'
     &      /'>>VEM600 error: process ',I4,' (TID=',I10,'):'
     &      /'>>error in Dirichlet conditions of component ',I3,' :'
     &      /'>>IVDP1=',I8,' must be greater/equal NDC=',I8,' !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM600----------------------------------------------------
      E    N    D
