C:::::      ,,,,,VEM601...                                          ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM601(NOLIN,LIVEM,IVEM,RVEM,LRVEM,LLVEM,LVEM,
     &                  MYPROC,MYTID,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM601   check the parameters for steady problems            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           LIVEM,LLVEM,LRVEM,ERR,MYTID,MYPROC
      DOUBLE PRECISION  RVEM(LRVEM)
      INTEGER           IVEM(LIVEM)
      LOGICAL           NOLIN,LVEM(LLVEM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NOLIN  I  L   I in  I marks the nonlinear case
C--------I------I-----I------------------------------------------------
C IVEM   I  I   I in  I integer info vector          array: IVEM(LIVEM)
C--------I------I-----I------------------------------------------------
C RVEM   I  R   I in  I real info vector             array: RVEM(LRVEM)
C--------I------I-----I------------------------------------------------
C LVEM   I  L   I in  I logical info vector          array: LVEM(LLVEM)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C MYTID  I  I   I in  I task id
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error code
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  ONE,LL8EPS
      INTEGER           LOUT,OUTCNT
      include "archi.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ONE = 1.E0
      LOUT=IVEM(40)
      OUTCNT=IVEM(41)
      ERR=0
      IF (OUTCNT.NE.0) WRITE (LOUT,9000)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** show parameters :                                             ***
C**   ---------------                                               ***
C**                                                                 ***
C**  IVEM(45) - MSPACK greater than 1                               ***
C**  IVEM(46) - PCLASS restricted between 0 and 2                   ***
C**  IVEM(51) - ORDER  integration order                            ***
C**  IVEM(52) - NRHS   greater than 0                               ***
C**                                                                 ***
      IVEM(10)=MAX(IVEM(10),0)
      IVEM(11)=MAX(IVEM(11),0)
      IVEM(45)=MAX(IVEM(45),1)
      IVEM(46)=MIN(MAX(IVEM(46),0),2)
      IVEM(51)=MAX(IVEM(51),1)
      IVEM(52)=MAX(IVEM(52),1)
      IVEM(60)=MAX(IVEM(60),0)

      IF (OUTCNT.NE.0) THEN

        WRITE (LOUT,9120) 10,IVEM(10)
        WRITE (LOUT,9121) 11,IVEM(11)
        IF (NOLIN) WRITE (LOUT,9122) 12,IVEM(12)
        WRITE (LOUT,9100) 40,LOUT
        WRITE (LOUT,9110) 41,OUTCNT
        WRITE (LOUT,9200) 45,IVEM(45)
        WRITE (LOUT,9210) 46,IVEM(46)
        WRITE (LOUT,9230) 51,IVEM(51)
        IF (NOLIN) THEN
          WRITE (LOUT,9260) 60,IVEM(60)
          IF (IVEM(60).EQ.0) WRITE (LOUT,9261)
        ELSE
          WRITE (LOUT,9250) 52,IVEM(52)
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** LINSOL parameters :                                           ***
C**   -----------------                                             ***
C**                                                                 ***
      IVEM(72)=MAX(IVEM(72),10)

      IF (OUTCNT.NE.0) THEN

        WRITE (LOUT,9420) 70,IVEM(70)
        WRITE (LOUT,9430) 71,IVEM(71)
        IF (NOLIN) THEN
          WRITE (LOUT,9411) 72,IVEM(72)
        ELSE
          WRITE (LOUT,9410) 72,IVEM(72)
        ENDIF
	IF ((IVEM(73).LT.100).AND.(IVEM(73).GT.20)) THEN
	   WRITE (LOUT,9412) 73,IVEM(73)
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** show RVEM :                                                   ***
C**   -----------                                                   ***
C**                                                                 ***
C**   RVEM(3) - EPSLIN   EPS<=EPSLIN<=0.1                           ***
C**                                                                 ***

      RVEM(2)=LL8EPS(ONE)
      IF (RVEM(3).LT.RVEM(2)) RVEM(3)=ONE/10
      RVEM(3)=MIN(RVEM(3),ONE/10)

      IF (OUTCNT.NE.0) THEN
        WRITE (LOUT,9500) 2,RVEM(2)
        IF (NOLIN) THEN
          WRITE (LOUT,9511) 3,RVEM(3)
          WRITE (LOUT,9520) 10,RVEM(10)
C**       DO 16 I=1,NK
C**         IF (LVEM(20+I)) THEN
C**           WRITE (LOUT,9530) I,20+I,RVEM(20+I)
C**         ENDIF
C**         IF (LVEM(20+NK+I)) THEN
C**           WRITE (LOUT,9540) I,20+NK+I,RVEM(20+NK+I)
C**         ENDIF
C16       CONTINUE
        ELSE
          WRITE (LOUT,9510) 3,RVEM(3)
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** show LVEM :                                                   ***
C**   -----------                                                   ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN

        IF (LVEM(1)) THEN
         WRITE (LOUT,9610) 1
        ELSE
         WRITE (LOUT,9600) 1
        ENDIF

        IF (NOLIN) THEN
          IF (LVEM(4)) THEN
            WRITE (LOUT,9691) 4
          ELSE
            WRITE (LOUT,9692) 4
          ENDIF
        ENDIF
     
       IF (LVEM(5)) THEN
         WRITE (LOUT,9630) 5
       ELSE
         WRITE (LOUT,9631) 5
       ENDIF

        IF (NOLIN) THEN
          IF (LVEM(6)) WRITE (LOUT,9644) 6
          IF (LVEM(7)) WRITE (LOUT,9645) 7
          IF (LVEM(8)) THEN
           WRITE (LOUT,9650) 8
          ELSE
           WRITE (LOUT,9660) 8
          ENDIF
        ENDIF
        IF (LVEM(9)) THEN
          WRITE (LOUT,9696) 9
        ELSE
          WRITE (LOUT,9695) 9
        ENDIF
        IF (NOLIN) THEN
          IF (.NOT.LVEM(10)) WRITE (LOUT,9690) 10
          IF (LVEM(11)) THEN
           WRITE (LOUT,9670) 11
          ELSE
           WRITE (LOUT,9680) 11
          ENDIF
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
9000  FORMAT (/'  checking of input parameters for steady problems'/
     &         '  ------------------------------------------------'/)
9100  FORMAT ('    line output to unit ..................... LOUT =',
     &                                          ' IVEM(',I4,') = ',I10)
9110  FORMAT ('    output control ........................ OUTCNT =',
     &                                          ' IVEM(',I4,') = ',I10)
9120  FORMAT ('    unit for paging of index ..................... =',
     &                                          ' IVEM(',I4,') = ',I10)
9121  FORMAT ('    unit for paging of addresses ................. =',
     &                                          ' IVEM(',I4,') = ',I10)
9122  FORMAT ('    unit for paging of global matrix ............. =',
     &                                          ' IVEM(',I4,') = ',I10)
9200  FORMAT ('    max. stripes for packing of matrix .... MSPACK =',
     &                                          ' IVEM(',I4,') = ',I10)
9210  FORMAT ('    pack class ............................ PCLASS =',
     &                                          ' IVEM(',I4,') = ',I10)
9230  FORMAT ('    order of integration formulas .......... ORDER =',
     &                                          ' IVEM(',I4,') = ',I10)
9250  FORMAT ('    number of right hand sides .............. NRHS =',
     &                                          ' IVEM(',I4,') = ',I10)
9260  FORMAT ('    maximal number of Newton iterations .... MAXIT =',
     &                                          ' IVEM(',I4,') = ',I10)
9261  FORMAT ('    => unbounded number of Newton steps')
9410  FORMAT ('    maximal number of MVM per right hand side .... =',
     &                                          ' IVEM(',I4,') = ',I10)
9411  FORMAT ('    maximal number of MVM per Newton step ........ =',
     &                                          ' IVEM(',I4,') = ',I10)
9412  FORMAT ('    stiffness matrix is written to unit .... MUNIT =',
     &                                          ' IVEM(',I4,') = ',I10)
9420  FORMAT ('    algorithm of LINSOL .......................... =',
     &                                          ' IVEM(',I4,') = ',I10)
9430  FORMAT ('    normalization in LINSOL ...................... =',
     &                                          ' IVEM(',I4,') = ',I10)

9500  FORMAT ('    small positive machine constant .......... EPS =',
     &                                        ' RVEM(',I4,') = ',G12.5)
9510  FORMAT ('    accuracy for LINSOL ................... EPSLIN =',
     &                                        ' RVEM(',I4,') = ',G12.5)
9511  FORMAT ('    LINSOL accuracy for error estimation .. EPSEST =',
     &                                        ' RVEM(',I4,') = ',G12.5)
9520  FORMAT ('    error tolerance .......................... TOL =',
     &                                        ' RVEM(',I4,') = ',G12.5)
9530  FORMAT ('    lower bound for component ',I4,' .......... MINU',
     &                                      ' = RVEM(',I4,') = ',G12.5)
9540  FORMAT ('    upper bound for component ',I4,' .......... MAXU',
     &                                      ' = RVEM(',I4,') = ',G12.5)

9691  FORMAT ('    LVEM(',I3,') => ',
     &                      'too small Newton correction is accepted.')
9692  FORMAT ('    LVEM(',I3,') => no small Newton correction.')
9600  FORMAT ('    LVEM(',I3,') => the global matrix is nonsymmetric.')
9610  FORMAT ('    LVEM(',I3,') => the global matrix is symmetric.')
9630  FORMAT ('    LVEM(',I3,') => U is initial guess ')
9631  FORMAT ('    LVEM(',I3,') => no initial guess ')
9643  FORMAT ('    LVEM(',I3,') => stopping criterion by tolerance ')
9644  FORMAT ('    LVEM(',I3,') => stopping criterion by ',
     &                                           'error estimation ')
9645  FORMAT ('    LVEM(',I3,') => error estimation ')
9646  FORMAT ('    LVEM(',I3,') => no error estimation ')
9650  FORMAT ('    LVEM(',I3,') => use simplified Newton iteration')
9660  FORMAT ('    LVEM(',I3,') => no simplified Newton iteration')
9670  FORMAT ('    LVEM(',I3,') => ',
     &                    'consider uniform error for the components')
9680  FORMAT ('    LVEM(',I3,') => ',
     &                'consider individual errors for the components')
9690  FORMAT ('    LVEM(',I3,') => ',
     &                  'stop if LINSOL reachs maximal number of MVM')
9695  FORMAT ('    LVEM(',I3,') => ',
     &                  'LINSOL returns smoothed solution.')
9696  FORMAT ('    LVEM(',I3,') => ',
     &                  'LINSOL returns nonsmoothed solution.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM601----------------------------------------------------
      E    N    D
