C:::::      ,,,,,VEM608...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM608(OWN,NGROUP,GINFO1,GINFO,NEK,
     &                  NK,DINFO1,DINFO,DNOD,NKN,COMIND,
     &                  DINDEX,TNDC,LM,MASK,NJUMP,
     &                  JUMP,NPROC,LMATBK,PTRMBK,MYPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM608   creates the index of the global nodes for         ***
C**               the components and the index of the Dirchlet      ***
C**               conditions.                                       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,OWN,GINFO1,NK,DINFO1,TNDC,
     &                  NPROC,NJUMP,MYPROC,LM,NMSG

      INTEGER           GINFO(GINFO1,NGROUP),NEK(*),
     &                  DINFO(DINFO1,NK),DNOD(*),MASK(LM,2),
     &                  NKN(NK),COMIND(LM),DINDEX(LM),JUMP(NJUMP),
     &                  LMATBK(NPROC),PTRMBK(NPROC),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I mesh type
C--------I------I-----I-----------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I infovector for groups
C        I      I     I                     array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I elements                          array: NEK(*)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution componets
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I info vector for Dirichlet conditions
C        I      I     I                         array: DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I in  I nodes with Dirichlet conditions
C        I      I     I                                  array: DNOD(*)
C--------I------I-----I------------------------------------------------
C COMIND I  I   I out I component i is defined by the global nodes
C        I      I     I COMIND(C+1),...,COMIND(C+NKN(I)) with
C        I      I     I C=C+NKN(I)                    array: COMIND(LM)
C--------I------I-----I------------------------------------------------
C DINDEX I  I   I out I index of global node id-PTKMBK on process with
C        I      I     I Dirichlet condions          array: DINDEX(TNDC)
C--------I------I-----I------------------------------------------------
C TNDC   I  I   I out I total number of Dirichlet conditions on process
C--------I------I-----I------------------------------------------------
C MASK   I  I   I  -  I masks                         array: MASK(LM,2)
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                              array: JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I                            array: LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I                            array: PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                     array: TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           I,J,Z,K,ADDCC,TOTID,FRTID,MIDS,MIDR,INFO,
     &                  NE,NELTYP,NEK1,ADDNEK,NDC,T0,M01,M1,MH,
     &                  BC,CC0,CC,BB,NK2,PROC,LL9MAP,P,SWPBUF,RCVBUF,
     &                  SNDBUF
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      NK2=MAX(OWN,1)
      BB=NK-NK2+1
      RCVBUF=1
      SNDBUF=2
      PROC=MYPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** mark the component of global nodes from elements:             ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      DO 70 P=1,NJUMP
        FRTID=TIDS(LL9MAP(MYPROC-JUMP(P),NPROC))
        TOTID=TIDS(LL9MAP(MYPROC+JUMP(P),NPROC))
        PROC=LL9MAP(PROC-JUMP(P),NPROC)
	M1=LMATBK(PROC)
	M01=PTRMBK(PROC)
        IF (P.EQ.1) THEN
           DO 40 Z=1,LM
             MASK(Z,RCVBUF)=0
  40      CONTINUE
        ELSE
	  CALL MPRCVA(FRTID,NMSG+P,IINT*LM,MASK(1,RCVBUF),MIDR,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*LM,MASK(1,SNDBUF),MIDS,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*LM,MASK(1,RCVBUF),MIDR,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IINT*LM,MASK(1,SNDBUF),MIDS,INFO)
        ENDIF
	
        DO 80 I=1,NGROUP
          NE=GINFO(1,I)
          ADDNEK=GINFO(21,I)
          NEK1=GINFO(22,I)
          NELTYP=23

          T0=-1
          DO 90 K=1,NK
            BC=MIN(K-BB,0)
            DO 95 J=1,GINFO(NELTYP+MIN(NK2,K),I)
              DO 95 Z=1,NE
                MH=BB*NEK(ADDNEK+NEK1*(J+T0)-1+Z)+BC-M01
		IF ((MH.GT.0).AND.(MH.LE.M1)) MASK(MH,RCVBUF)=K
   95       CONTINUE
            IF (K.LT.NK2) T0=T0+GINFO(NELTYP+K,I)
 90       CONTINUE

80      CONTINUE
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
70    CONTINUE
      NMSG=NMSG+NJUMP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** mark the components of global nodes from Dirichlet cond.:     ***
C**   --------------------------------------------------------      ***
C**                                                                 ***
      DO 100 K=1,NK
          NDC =DINFO(1,K)
          ADDCC=DINFO(3,K)
          BC=MIN(K-BB,0)
          DO 110 Z=1,NDC
             MASK(BB*DNOD(ADDCC-1+Z)+BC-PTRMBK(MYPROC),SNDBUF)=-K
  110     CONTINUE
 100  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create index for solution components:                         ***
C**   ------------------------------------                          ***
C**                                                                 ***
      CC0=0
      DO 200 K=1,NK
          CC=0
          DO 210 Z=1,LM
            IF (ABS(MASK(Z,SNDBUF)).EQ.K) THEN
              CC=CC+1
              COMIND(CC0+CC)=Z
            ENDIF
  210     CONTINUE
          NKN(K)=CC
          CC0=CC0+CC
200   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create the index of global nodes Fixed by Dirichlet cond.:    ***
C**   ---------------------------------------------------------     ***
C**                                                                 ***
      TNDC=0
      DO 300 Z=1,LM
        IF (MASK(Z,SNDBUF).LT.0) THEN
          TNDC=TNDC+1
          DINDEX(TNDC)=Z
        ENDIF
 300  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM608----------------------------------------------------
      E    N    D
