C:::::      ,,,,,VEM609...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM609(ARRY,NARRY,LARRY,HEAD,LOUT)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM609   print array statistcs table                       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NARRY,LARRY,LOUT
      CHARACTER         ARRY*22
      LOGICAL           HEAD
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C ARRY   I C*22 I in  I array name
C--------I------I-----I-----------------------------------------------
C NARRY  I  I   I in  I needed length of array
C--------I------I-----I------------------------------------------------
C LARRY  I  I   I in  I actual length of array
C--------I------I-----I------------------------------------------------
C HEAD   I  L   I i/o I =true=> head lines are printed
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I line out unit
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
C**                                                                 ***
      INTEGER           PPC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      IF (.NOT.HEAD) THEN
        WRITE(LOUT,9100)
        HEAD=.TRUE.
      ENDIF

      IF (LARRY.LE.0) THEN
       IF (NARRY.EQ.0) THEN
        PPC=100
       ELSE
        PPC=999999
       ENDIF
      ELSE
        PPC=INT(100.*DBLE(NARRY)/DBLE(LARRY))
      ENDIF

      IF (LARRY.GE.NARRY) THEN
       WRITE(LOUT,9110) ARRY,LARRY,NARRY,PPC
      ELSE
       WRITE(LOUT,9120) ARRY,LARRY,NARRY,PPC
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   --------                                                      ***
C**                                                                 ***
9100  FORMAT (/'  storage statistics'/3X,18('-')
     &        /29X,'|   length   |   length   |       '
     &        /8X,'array                |    real    |   needed   |   %'
     &        /5X,60('-'))
9110  FORMAT (5X,A23,' | ',I10,' | ',I10,' |',I6)
9120  FORMAT ('  >> ',A23,' | ',I10,' | ',I10,' |',I6,' << too small')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM609----------------------------------------------------
      E    N    D
