C:::::      ,,,,,VEM610...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM610(NOPER,LSYM,NK,NGROUP,MASKL)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM610    mirrors the MASKL for a set of NOPER bilinear    ***
C**                form MASKS at the main diagonal if the symmetry  ***
C**                flag is set                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NK,NGROUP,NOPER
      LOGICAL           LSYM(NOPER),MASKL(NK,NK,NGROUP,NOPER)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NOPER  I  I   I in  I number of bilinear forms
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C LSYM   I  L   I in  I symmetry flags               array: LSYM(NOPER)
C--------I------I-----I------------------------------------------------
C MASKL  I  L   I in  I bilinear form masks  
C        I      I     I                array: MASKL(NK,NK,NGROUP,NOPER)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           K,J,OP,G
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 1000 OP=1,NOPER
        IF (LSYM(NOPER)) THEN

          DO 100 G=1,NGROUP
            DO 100 J=1,NK-1
             DO 100 K=J+1,NK
               MASKL(K,J,G,OP)=MASKL(J,K,G,OP)
 100      CONTINUE

        ENDIF
1000  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM610----------------------------------------------------
      E    N    D
