C:::::      ,,,,,VEM620...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM620(NGROUP,NK,DIM,NOP,OWN,
     &                  GINFO1,GINFO,ORDER,NRHS,NOPER,
     &                  OPER,LSYM,MASKL,MASKF,NADD,MOUNT1,MOUNT,
     &                  RMOUNT,NEM,NLOCU,NUBUF,DINFO1,DINFO,LDC,NELEMD,
     &                  VEM63X,NPROC,LMATBK,MYPROC,MYTID,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEM620    storage manager                                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,NK,DIM,NOP,GINFO1,OWN,
     &                  MSMONT,NRHS,NOPER,MOUNT1,NELEMD,DINFO1,
     &                  LDC,NLOCU,NUBUF,NPROC,MYPROC,MYTID,LOUT,ERR

      INTEGER           GINFO(GINFO1,NGROUP),ORDER(NOPER),
     &                  OPER(NOPER),NADD(NOPER),
     &                  MOUNT(MOUNT1,NGROUP,NOPER),RMOUNT(NOPER),
     &                  DINFO(DINFO1,NK),NEM(NOPER),LMATBK(NPROC)

      LOGICAL           MASKL(NK,NK,NGROUP,NOPER),
     &                  MASKF(NK,NRHS,NGROUP,NOPER),LSYM(NOPER)

      EXTERNAL VEM63X
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I number of proposal functions
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos         array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C ORDER  I  I   I in  I wished integration order    array: ORDER(NOPER)
C--------I------I-----I------------------------------------------------
C NRHS   I  I   I in  I number of right hand side/linear forms
C--------I------I-----I------------------------------------------------
C NOPER  I  I   I in  I number of considered bilinear forms
C--------I------I-----I------------------------------------------------
C OPER   I  I   I in  I type of evaluation (see VEM63X)
C        I      I     I                              array: OPER(NOPER)
C--------I------I-----I------------------------------------------------
C LSYM   I  L   I in  I symmetry flags               array: LSYM(NOPER)
C--------I------I-----I------------------------------------------------
C MASKL  I  L   I in  I mask of couplings in the bilinear forms
C        I      I     I                array: MASKL(NK,NK,NGROUP,NOPER)
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I mask of contributions in linear forms
C        I      I     I              array: MASKF(NK,NRHS,NGROUP,NOPER)
C--------I------I-----I------------------------------------------------
C NADD   I  I   I out I needed storage for addresses in RBIG
C        I      I     I                              array: NADD(NOPER)
C--------I------I-----I------------------------------------------------
C MOUNT  I  I   I out I infos for mounting for global matrix and rhs
C        I      I     I 1 = SLICE - size of element matrix
C        I      I     I 2 = PILE  - size of rhs element matrix
C        I      I     I 3 = STORRS- real scalar storage
C        I      I     I 4 = STORRV- real vector storage per element
C        I      I     I 5 = STORIS- integer scalar storage
C        I      I     I 6 = STORIV- integer vector storage per element
C        I      I     I 7 = ORDER - actual order of integration scheme
C        I      I     I 8 = NQMAX - Maximal number of integration nodes
C        I      I     I 9 = LEAD - leading dimesion of element matrices
C        I      I     I               array: MOUNT(MOUNT1,NGROUP,NOPER)
C--------I------I-----I------------------------------------------------
C RMOUNT I  I   I out I needed space for mounting procedure VEM50X
C        I      I     I in RBIG                    array: RMOUNT(NOPER)
C--------I------I-----I------------------------------------------------
C NEM    I  I   I out I needed space for element matrices in RBIG
C        I      I     I                               array: NEM(NOPER)
C--------I------I-----I------------------------------------------------
C NLOCU  I  I   I out I needed storage for the solution distributed
C        I      I     I to the elements
C--------I------I-----I------------------------------------------------
C NUBUF  I  I   I out I buffer length for distribution of solution
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I Dirichlet cond. infos   array: DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C LDC    I  I   I out I selected leading dimension in VEM518
C--------I------I-----I------------------------------------------------
C NELEMD I  I   I out I needed storage for the evaluation and 
C        I      I     I elemination of dirichlet conditions
C--------I------I-----I------------------------------------------------
C VEM63X I  EX  I in  I routine to fix the storage request in VEM50X
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I                           array : LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C MYTID  I  I   I in  I task id
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I message units
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number: (local)
C        I      I     I =6200 illegal parameter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"
      include "archi.h"
      INTEGER           G,OP,NELTYP,NE,SLICE,PILE,NBIG,NK2,
     &                  STORRS,STORRV,STORIS,STORIV,LEN,NADD2,
     &                  NDC,D,OR,NQ,IERR,LEAD,STOEM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ERR=0
      NK2=MAX(1,OWN)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** storage amount for distribution of solution onto elements:    ***
C**   ---------------------------------------------------------     ***
C**                                                                 ***
      CALL VEM660(OWN,NK,NGROUP,GINFO1,GINFO,NPROC,LMATBK,NLOCU,NUBUF)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** storage for inserting of dirichlet conditions :               ***
C**   ---------------------------------------------                 ***
C**                                                                 ***
      LDC=0
      DO 10 D=1,NK
        NDC=DINFO( 1,D)
        LDC=LDC+NDC
10    CONTINUE
      NELEMD=NUBUF*NRHS+MAX((DIM+NOP+1)*LDC,(8*NUBUF+RPI-1)/RPI)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** storage of element matrix calculation:                        ***
C**   -------------------------------------                         ***
C**                                                                 ***
C**                                                                 ***
C**** start of bilinear form loop :                                 ***
C**   ---------------------------                                   ***
C**                                                                 ***
      DO 80 OP=1,NOPER

        NADD2=0
        NBIG=0
        STOEM=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** start of group loop :                                       ***
C**     ---------------------                                       ***
C**                                                                 ***
        DO 70 G=1,NGROUP

          NE     = GINFO( 1,G)
          NELTYP=24
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** size of the element matrix:                               ***
C**       --------------------------                                ***
C**                                                                 ***
          CALL VEM621(NK,LSYM(OP),NK2,GINFO(NELTYP,G),
     &                                          MASKL(1,1,G,OP),SLICE)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** size of the right hand side element matrix:               ***
C**       ------------------------------------------                ***
C**                                                                 ***
          CALL VEM622(NRHS,NK,NK2,GINFO(NELTYP,G),MASKF(1,1,G,OP),PILE)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** storage request per element:                              ***
C**       ---------------------------                               ***
C**                                                                 ***
	  IF (NE.EQ.0) THEN
	    LEAD=0
	  ELSE
            LEAD=NE+1-MOD(NE,2)
	  ENDIF
          NADD2=NADD2+SLICE*LEAD
          STOEM=STOEM+(PILE+SLICE)*LEAD
	
          IF (NE*(SLICE+PILE).NE.0) THEN
            OR=ORDER(OP)
            CALL VEM63X(G,OPER(OP),NK,DIM,NOP,OWN,
     &                  GINFO1,GINFO(1,G),OR,NQ,
     &                  SLICE,PILE,STORRS,STORRV,STORIS,STORIV,
     &                  MYPROC,MYTID,LOUT,IERR)
            IF (IERR.GT.0) ERR=6200
          ELSE

            STORRS=0
            STORRV=0
            STORIS=0
            STORIV=0
            NQ=0
            OR=0
	    LEAD=0

          ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
          MOUNT(1,G,OP)=SLICE
          MOUNT(2,G,OP)=PILE
          MOUNT(3,G,OP)=STORRS
          MOUNT(4,G,OP)=STORRV
          MOUNT(5,G,OP)=STORIS
          MOUNT(6,G,OP)=STORIV
          MOUNT(7,G,OP)=OR
          MOUNT(8,G,OP)=NQ
          MOUNT(9,G,OP)=LEAD
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** storage amount for optimal stripe length MV :             ***
C**       -------------------------------------------               ***
C**                                                                 ***
          LEN=MIN(MV,NE)
          IF (NE*(SLICE+PILE).NE.0) THEN
            NBIG=MAX(NBIG,LEN*STORRV+STORRS+
     &           (LEN*STORIV+RPI-1)/RPI+(STORIS+RPI-1)/RPI)
          ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** end of group loop :                                         ***
C**     ------------------                                          ***
C**                                                                 ***
   70   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of bilnear form loop :                                    ***
C**   ------------------------                                      ***
C**                                                                 ***
        NADD(OP)=(NADD2+RPI-1)/RPI
        RMOUNT(OP)=NBIG
        NEM(OP)=STOEM
  80  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
C**   R E T U R N                                                   ***
C-----End of VEM620----------------------------------------------------
      E    N    D
