C:::::      ,,,,,VEM621...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM621(NK,SYM,NK2,NELTYP,MASKL,SLICE)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEM621    computes the size of an element matrix            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NK,SLICE,NK2

      INTEGER           NELTYP(NK2)
      LOGICAL           MASKL(NK,NK),SYM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I order of the test functions 
C        I      I     I                              array: NELTYP(NK2)
C--------I------I-----I------------------------------------------------
C SYM    I  L   I in  I symmetry flags
C--------I------I-----I------------------------------------------------
C MASKL  I  L   I in  I mask of couplings in the bilinear form
C        I      I     I                             array: MASKL(NK,NK)
C--------I------I-----I------------------------------------------------
C SLICE  I  I   I out I  ELEMENT MATRIX PER ELEMENT
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I1,I2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      SLICE=0

      IF (SYM) THEN

        DO 500 I1=1,NK
          DO 500 I2=I1+1,NK
            IF (MASKL(I1,I2)) THEN
              SLICE=SLICE+NELTYP(MIN(I1,NK2))*NELTYP(MIN(I2,NK2))
            ENDIF
 500    CONTINUE

        DO 501 I1=1,NK
          IF (MASKL(I1,I1)) THEN
              SLICE=SLICE+
     &       ( NELTYP(MIN(I1,NK2)) * ( NELTYP(MIN(I1,NK2)) +1 ) )/2
           ENDIF
 501    CONTINUE

      ELSE

        DO 502 I1=1,NK
          DO 502 I2=1,NK
            IF (MASKL(I1,I2)) THEN
              SLICE=SLICE+NELTYP(MIN(I1,NK2))*NELTYP(MIN(I2,NK2))
            ENDIF
 502    CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM621----------------------------------------------------
      E    N    D
