C:::::      ,,,,,VEM622...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM622(NRHS,NK,NK2,NELTYP,MASKF,PILE)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM622    computes the size of linear form element matrix  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NRHS,NK,PILE,NK2

      INTEGER           NELTYP(NK2)
      LOGICAL           MASKF(NK,NRHS)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NRHS   I  I   I in  I number of right hand sides/linear forms
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I order of the test functions   array: NELTYP(NK2)
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I mask of the contributions in the linear forms
C        I      I     I                           array: MASKF(NK,NRHS)
C--------I------I-----I------------------------------------------------
C PILE   I  I   I out I storage for linear form element matrix
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           J,I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      PILE=0
      DO 500 I=1,NRHS
        DO 500 J=1,NK
           IF (MASKF(J,I)) THEN
             PILE=PILE+NELTYP(MIN(J,NK2))
           ENDIF
500   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM622----------------------------------------------------
      E    N    D
