C:::::      ,,,,,VEM630...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM630(GROUP,MATRIX,NK,DIM,NOP,OWN,
     &                  GINFO1,GINFO,ORDER,NQ,
     &                  SLICE,PILE,STORRS,STORRV,STORIS,STORIV,
     &                  MYPROC,MYTID,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM630      compute storage per element for the            ***
C**                  caculation of the element matrices by VEM500   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 *** 
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           GROUP,MATRIX,NK,DIM,GINFO1,ORDER,NQ,NOP,SLICE,
     &                  PILE,STORRS,STORRV,STORIS,STORIV,OWN,
     &                  MYTID,MYPROC,ERR,LOUT

      INTEGER           GINFO(GINFO1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I in  I current group id
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I number proposal functions
C        I      I     I =0 isoparametricalmesh
C--------I------I-----I------------------------------------------------
C MATRIX I  I   I in  I evalution type
C        I      I     I     0 - (L(u),f)
C        I      I     I     1 - (L+alpha*k(u,ut),f(u,ut))
C        I      I     I    -1 - (L(u,ut),f)
C        I      I     I    10 - (L(u),f(u)) error estimation
C        I      I     I   100 - L1-norm of proposal functions
C        I      I     I    11 - (L(u,ut),f(u,u,utt)) error estimation
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components 
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension 
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group info's               array: GINFO(GINFO1)
C--------I------I-----I------------------------------------------------
C ORDER  I  I   I i/o I requested/selected integration order
C--------I------I-----I------------------------------------------------
C NQ     I  I   I out I number of integration nodes
C--------I------I-----I------------------------------------------------
C SLICE  I  I   I in  I size of element matrix
C--------I------I-----I------------------------------------------------
C PILE   I  I   I in  I size of linear form element matrix
C--------I------I-----I------------------------------------------------
C STORRS I  I   I out I integer scalar work space
C--------I------I-----I------------------------------------------------
C STORRV I  I   I out I real work space per element
C--------I------I-----I------------------------------------------------
C STORIS I  I   I out I integer scalar work space
C--------I------I-----I------------------------------------------------
C STORIV I  I   I out I integer work space per element
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I out I process id
C--------I------I-----I------------------------------------------------
C MYTID  I  I   I out I task id
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I out I message unit
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I    =6300 => illegal element parameters
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NELTYP,CLASS,FORM,IERR,TOTNT,
     &                  GEOTYP,NK2,IWORK,IW1,RWORK,RW1,PRFLIB,
     &                  SETME
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ERR=0
      NK2=MAX(1,OWN)
      SETME=0
      IF ((MATRIX.EQ.10).OR.(MATRIX.EQ.11)) SETME=1

      GEOTYP=GINFO(2)
      FORM  =GINFO(3)
      CLASS =GINFO(4)
      TOTNT=GINFO(23)
      NELTYP = 24
      PRFLIB = 24+NK
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check quadratur order and shape and proposal functions :      ***
C**   ------------------------------------------------------        ***
C**                                                                 ***
      CALL VEMPR0(SETME,GROUP,CLASS,FORM,OWN,ORDER,NQ,
     &            GEOTYP,GINFO(NELTYP),GINFO(PRFLIB),TOTNT,
     &            RW1,IW1,MYPROC,MYTID,LOUT,IERR)
      RWORK=NQ*(GEOTYP+1)*(CLASS+1)
      IF (OWN.GT.0) RWORK=RWORK+NQ*(TOTNT*(CLASS+1))
      IF ((MATRIX.EQ.10).OR.(MATRIX.EQ.11))
     &                 RWORK=RWORK+NQ*(TOTNT*(CLASS+1))
      RWORK=RW1+RWORK
      IWORK=IW1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** L1-norm of weights
C**   ------------------                                            ***
C**                                                                 ***
      IF (MATRIX.EQ.100) THEN
	STORRV =1+DIM*CLASS
	STORIV =0
        STORRS =RWORK
        STORIS =IWORK
      ELSE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** inner elements :                                              ***
C**   ---------------                                               ***
C**                                                                 ***
      IF (CLASS.EQ.DIM) THEN

        STORRV = DIM+NK+NOP+TOTNT*DIM+NK*DIM+NOP*DIM+1

        IF (SLICE.EQ.0) THEN
           IF ((MATRIX.EQ.1).OR.(MATRIX.EQ.-1).OR.(MATRIX.EQ.11)) THEN
             STORRV = STORRV + NK+NK*DIM  +
     &         MAX(DIM*DIM+MAX(NK,NOP)*DIM,DIM+1)
           ELSE
             STORRV = STORRV +
     &         MAX(DIM*DIM+MAX(NK,NOP)*DIM,DIM+1)
           ENDIF
        ELSE
           IF (MATRIX.EQ.1) THEN
             STORRV = STORRV + NK+NK*DIM  +
     &         MAX(DIM*DIM+MAX(NK,NOP)*DIM,2*(DIM*DIM+2*DIM+1))
           ELSEIF (MATRIX.EQ.-1) THEN
             STORRV = STORRV + NK+NK*DIM  +
     &         MAX(DIM*DIM+MAX(NK,NOP)*DIM,DIM*DIM+2*DIM+1)
           ELSE
             STORRV = STORRV +
     &         MAX(DIM*DIM+MAX(NK,NOP)*DIM,DIM*DIM+2*DIM+1)
           ENDIF
        ENDIF

        STORIV = 0
        STORRS = RWORK
        STORIS = IWORK

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** area elements :                                             ***
C**     --------------                                              ***
C**                                                                 ***
      IF ((CLASS.EQ.2).AND.(DIM.EQ.3)) THEN

        STORRV = DIM+NK+NOP+2*DIM+TOTNT*2+NK*2+NOP*2+1

        IF (SLICE.EQ.0) THEN
           IF ((MATRIX.EQ.1).OR.(MATRIX.EQ.-1).OR.(MATRIX.EQ.11)) THEN
             STORRV = STORRV + NK+NK*2   + 3
           ELSE
             STORRV = STORRV +             3
           ENDIF
        ELSE
           IF (MATRIX.EQ.1) THEN
             STORRV = STORRV + NK +NK*2 + 18
           ELSEIF (MATRIX.EQ.-1) THEN
             STORRV = STORRV + NK +NK*2 +  9
           ELSE
             STORRV = STORRV +             9
           ENDIF
        ENDIF

        STORIV = 0
        STORRS = RWORK
        STORIS = IWORK

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** line elements :                                               ***
C**   --------------                                                ***
C**                                                                 ***
      IF ((CLASS.EQ.1).AND.(DIM.GT.1)) THEN

        STORRV = DIM+NK+NOP+DIM+TOTNT+NK+NOP+1

        IF (SLICE.EQ.0) THEN
           IF ((MATRIX.EQ.1).OR.(MATRIX.EQ.-1).OR.(MATRIX.EQ.11)) THEN
             STORRV = STORRV + NK+NK   + 2
           ELSE
             STORRV = STORRV +           2
           ENDIF
        ELSE
           IF (MATRIX.EQ.1) THEN
             STORRV = STORRV + NK +NK +  8
           ELSEIF (MATRIX.EQ.-1) THEN
             STORRV = STORRV + NK +NK +  4
           ELSE
             STORRV = STORRV +           4
           ENDIF
        ENDIF

        STORIV = 0
        STORRS = RWORK
        STORIS = IWORK

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** nodal elements :                                              ***
C**   --------------                                                ***
C**                                                                 ***
      IF (CLASS.EQ.0) THEN

        STORRV = DIM+NK+NOP

        IF ((MATRIX.EQ.1).OR.(MATRIX.EQ.-1).OR.(MATRIX.EQ.11)) THEN
          STORRV = STORRV + NK + 1
        ENDIF

        STORIV = 0
        STORRS = RWORK
        STORIS = IWORK

      ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** o.k. ?:                                                       ***
C**   -----                                                         ***
C**                                                                 ***
      IF (IERR .NE. 0) ERR=6300
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM630----------------------------------------------------
      E    N    D
