C:::::      ,,,,,VEM653...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM653(NDEG,NC,C1,C,CU1,CU,COUNT,LAST,NELIS,GEO1,
     &                  GEOTYP,GEONEK,INDEX,NODES,MARK,MASK)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM653   adds values CU given at the elements (e.g. at the   ***
C**             centre points) to their geometrical nodal values.   ***
C**             a set of NELIS elements in a group starting with    ***
C**             the element LAST+1 are processed.                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NC,C1,NDEG,CU1,NELIS,GEO1,GEOTYP,LAST

      DOUBLE PRECISION  C(C1,NC),CU(CU1,NC)

      INTEGER           COUNT(NDEG),GEONEK(GEO1,GEOTYP),
     &                  INDEX(NELIS),NODES(NELIS),MASK(NELIS),MARK(NDEG)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NDEG   I  I   I in  I number of geometrical nodes
C--------I------I-----I------------------------------------------------
C NC     I  I   I in  I number of values per element/node
C--------I------I-----I------------------------------------------------
C C      I  R   I i/o I nodal values                    array: C(C1,NC)
C--------I------I-----I------------------------------------------------
C CU     I  R   I in  I element values                array: CU(CU1,NC)
C--------I------I-----I------------------------------------------------
C COUNT  I  I   I i/o I counts the contributions to node values 
C        I      I     I                              array: COUNT(NDEG)
C--------I------I-----I------------------------------------------------
C LAST   I  I   I in  I startup for elements
C--------I------I-----I------------------------------------------------
C NELIS  I  I   I in  I number of elements in stripe
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of local nodes 
C--------I------I-----I------------------------------------------------
C GEONEK I  I   I in  I geometrical nodes of the elements
C        I      I     I                      array: GEONEK(GEO1,GEOTYP)
C--------I------I-----I------------------------------------------------
C INDEX  I  I   I -   I list of unprocessed elements  
C        I      I     I                             array: INDEX(NELIS)
C--------I------I-----I------------------------------------------------
C NODES  I  I   I -   I list of unprocessed element nodes    
C        I      I     I                             array: NODES(NELIS)
C--------I------I-----I------------------------------------------------
C MASK   I  I   I  -  I mask of unprocessed elements array: MASK(NELIS)
C--------I------I-----I------------------------------------------------
C MARK   I  I   I  -  I mask of nodes concerned by addition
C        I      I     I                               array: MARK(NDEG)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,I,J,K,KN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 2000 I=1,GEOTYP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** install mask index of unprocessed elements:                 ***
C**     ------------------------------------------                  ***
C**                                                                 ***
        DO 10 Z=1,NELIS
          MASK(Z)=0
          INDEX(Z)=Z
 10     CONTINUE
        K=NELIS

1000    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** find the elements added to different places in C:           ***
C**     ------------------------------------------------            ***
C**                                                                 ***
        DO 20 Z=1,NDEG
          MARK(Z)=0
 20     CONTINUE
        DO 30 Z=1,K
          MARK(GEONEK(INDEX(Z)+LAST,I))=INDEX(Z)
 30     CONTINUE

        KN=0
        DO 40 Z=1,NDEG
          IF (MARK(Z).GT.0) THEN
            KN=KN+1
            INDEX(KN)=MARK(Z)
            NODES(KN)=GEONEK(MARK(Z)+LAST,I)
          ENDIF
 40     CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** add the element values for elements INDEX:                  ***
C**     -----------------------------------------                   ***
C**                                                                 ***
        include "norec.h"
        DO 50 Z=1,KN
          MASK(INDEX(Z))=1
          COUNT(NODES(Z))=COUNT(NODES(Z))+1
  50    CONTINUE

        include "norec.h"
        DO 60 J=1,NC
          DO 60 Z=1,KN
            C(NODES(Z),J)=C(NODES(Z),J)+CU(INDEX(Z),J)
  60    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** gather the elements which are not yet processed:            ***
C**     -----------------------------------------------             ***
C**                                                                 ***
        K=0
        DO 70 Z=1,NELIS
          IF (MASK(Z).EQ.0) THEN
            K=K+1
            INDEX(K)=Z
          ENDIF
  70    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** if there are unprocessed elements go on:                    ***
C**     ---------------------------------------                     ***
C**                                                                 ***
        IF (K.NE.0) GOTO 1000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
2000  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM653----------------------------------------------------
      E    N    D
