C:::::      ,,,,,VEM660...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM660(OWN,NK,NGROUP,GINFO1,GINFO,
     &                  NPROC,LMATBK,NLOCU,NBUF)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM660  computes the storage want for the distibution      ***
C**              of the solution to the elements                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,NPROC,NK,NBUF,NLOCU,OWN
      INTEGER           GINFO(GINFO1,NGROUP),LMATBK(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I mesh type
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos         array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of nodes on processes
C        I      I     I                            array: LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C NLOCU  I  I   I out I length of the array with elementwise solution
C--------I------I-----I------------------------------------------------
C NBUF   I  I   I out I length of needed communication buffer
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I,P,NE,TOTNT,BB,MPINFO,SBT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      IF (NPROC.EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
C**                                                                 ***
      NBUF=0
      DO 120 P=1,NPROC
        NBUF=MAX(NBUF,LMATBK(P))
120   CONTINUE
      NBUF=NBUF*SBT
C**                                                                 ***
      NLOCU=0
      BB=NK-MAX(OWN,1)+1
      DO 140 I=1,NGROUP
        NE    =GINFO(1,I)
        TOTNT =GINFO(23,I)
        NLOCU=NLOCU+TOTNT*BB*NE
 140  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM660----------------------------------------------------
      E    N    D
