C:::::      ,,,,,VEM661...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM661(M,U,OWN,NK,NGROUP,GINFO1,GINFO,NEK,NJUMP,
     &                  JUMP,LMATBK,PTRMBK,NLOCU,LOCU,
     &                  SBT,NBUF,BUF,MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM661  distributes the solution to the elements             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,MYPROC,NPROC,M,NJUMP,NK,
     &                  NBUF,NLOCU,OWN,NMSG,SBT

      INTEGER           GINFO(GINFO1,NGROUP),JUMP(NJUMP),TIDS(NPROC),
     &                  NEK(*),LMATBK(NPROC),PTRMBK(NPROC)

      DOUBLE PRECISION  U(M),LOCU(NLOCU),BUF(NBUF,SBT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C M      I  I   I in  I number of global nodes on process
C--------I------I-----I------------------------------------------------
C U      I  I   I in  I values of the global nodes
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I mesh type
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos       array : GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                   array : NEK(*)
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                              array: JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I                            array: LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I                           array : PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C SBT    I  I   I in  I =1 no switching buffer technique
C        I      I     I =2 use switching buffer technique
C--------I------I-----I------------------------------------------------
C BUF    I  R   I  -  I communication buffer       array: BUF(NBUF,SBT)
C--------I------I-----I------------------------------------------------
C LOCU   I  R   I out I values of the solution at the nodes of the 
C        I      I     I proposal functions at the elements 
C        I      I     I                              array: LOCU(NLOCU)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           I,P,TOPROC,TOTID,FRPROC,FRTID,MIDS,M1,M01,NH,
     &                  NE,TOTNT,INFO,BB,ADDNEK,NEK1,Z,J,K,S,
     &                  LL9MAP,MIDR,PROC,SWPBUF,RCVBUF,SNDBUF
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      BB=NK-MAX(OWN,1)+1
      PROC=MYPROC
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)

      DO 10 Z=1,M
10      BUF(Z,SNDBUF)=U(Z)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      DO 120 P=1,NJUMP

	IF (P.LT.NJUMP) THEN
          TOPROC=LL9MAP(MYPROC+JUMP(P),NPROC)
          FRPROC=LL9MAP(MYPROC-JUMP(P),NPROC)
          TOTID=TIDS(TOPROC)
          FRTID=TIDS(FRPROC)
	  CALL MPRCVA(FRTID,NMSG+P,IREAL*NBUF,BUF(1,RCVBUF),MIDR,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IREAL*NBUF,BUF(1,SNDBUF),MIDS,INFO)
        ENDIF

        M1=LMATBK(PROC)
        M01=PTRMBK(PROC)
	S=0
        DO 140 I=1,NGROUP
          NE    =GINFO(1,I)
          ADDNEK=GINFO(21,I)
          NEK1  =GINFO(22,I)
          TOTNT =GINFO(23,I)
	  DO 150 J=1,BB
	   DO 150 K=1,TOTNT
	    DO 150 Z=1,NE
	      NH=BB*NEK(ADDNEK-1+Z+NEK1*(K-1))-BB+J-M01
	      IF ((0.LT.NH).AND.(NH.LE.M1)) THEN
		LOCU(S+Z+NE*(TOTNT*(J-1)+K-1))=BUF(NH,SNDBUF)
              ENDIF
 150      CONTINUE
	  S=S+TOTNT*BB*NE
 140    CONTINUE
	
	IF (P.LT.NJUMP) THEN
          PROC=LL9MAP(PROC-JUMP(P),NPROC)
	  CALL MPRCVW(FRTID,NMSG+P,IREAL*NBUF,BUF(1,RCVBUF),MIDR,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IREAL*NBUF,BUF(1,SNDBUF),MIDS,INFO)
	ENDIF
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
120   CONTINUE
      NMSG=NMSG+NJUMP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM661----------------------------------------------------
      E    N    D
