C:::::      ,,,,,VEM662...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM662(LM,COUNT,U,OWN,NK,NGROUP,GINFO1,GINFO,NEK,
     &                  NJUMP,JUMP,LMATBK,PTRMBK,
     &                  NLOCU,LOCU,SBT,NBUF,COUBUF,BUF,
     &                  SKIP,BLKLST,BLK,MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM662  distributes values at global nodes of the elements ***
C**              to global result vector                            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,MYPROC,NPROC,LM,NJUMP,NK,
     &                  NBUF,NLOCU,OWN,COUNT,NMSG,SBT

      INTEGER           GINFO(GINFO1,NGROUP),JUMP(NJUMP),TIDS(NPROC),
     &                  NEK(*),BLKLST(NGROUP),BLK(*),SKIP(NGROUP),
     &                  COUBUF(NBUF,SBT),LMATBK(NPROC),PTRMBK(NPROC)

      DOUBLE PRECISION  U(LM),LOCU(NLOCU),BUF(NBUF,SBT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C LM     I  I   I in  I maximal number of global nodes on process
C--------I------I-----I------------------------------------------------
C COUNT  I  I   I out I number of global nodes get no value
C--------I------I-----I------------------------------------------------
C U      I  I   I out I values at the global nodes
C        I      I     I unreferenced nodes get the value 0.
C        I      I     I                                     array: U(M)
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I mesh type
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos         array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                     array: NEK(*)
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                             array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I                            array: LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I                           array : PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C LOCU   I  R   I in  I values at nodes of the proposal functions at
C        I      I     I the elements                 array: LOCU(NLOCU)
C--------I------I-----I------------------------------------------------
C SBT    I  I   I in  I =1 no switching buffer technique
C        I      I     I =2 use switching buffer technique
C--------I------I-----I------------------------------------------------
C COUBUF I  I   I  -  I buffer for counter      array: COUBUF(NBUF,SBT)
C--------I------I-----I------------------------------------------------
C BUF    I  R   I  -  I buffer for values          array: BUF(NBUF,SBT)
C--------I------I-----I------------------------------------------------
C SKIP   I  I   I in  I  =1 => group is skipped     array: SKIP(NGROUP)
C--------I------I-----I------------------------------------------------
C BLKLST I  I   I in  I number of blocks in groups
C        I      I     I                           array: BLKLST(NGROUP)
C--------I------I-----I------------------------------------------------
C BLK    I  I   I in  I block lengths                     array: BLK(*)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                     array: TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I,P,TOPROC,TOTID,FRPROC,FRTID,M1,M01,NH,L,
     &                  NE,TOTNT,INFO,BB,ADDNEK,NEK1,Z,J,K,S,PROC,
     &                  S1,S2,MIDS1,MIDS2,MIDR1,MIDR2,LL9MAP,
     &                  SWPBUF,RCVBUF,SNDBUF,M
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      BB=NK-MAX(OWN,1)+1
      M=LMATBK(MYPROC)
      PROC=MYPROC
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)
C**                                                                 ***
      DO 120 P=1,NJUMP

        TOPROC=LL9MAP(MYPROC+JUMP(P),NPROC)
        TOTID=TIDS(TOPROC)
        PROC=LL9MAP(PROC-JUMP(P),NPROC)
        FRPROC=LL9MAP(MYPROC-JUMP(P),NPROC)
        FRTID=TIDS(FRPROC)
	M1=LMATBK(PROC)
	M01=PTRMBK(PROC)

	IF (P.EQ.1) THEN
          DO 10 Z=1,M1
            COUBUF(Z,RCVBUF)=0
10          BUF(Z,RCVBUF)=0.
        ELSE
	  CALL MPRCVA(FRTID,NMSG+P,IINT*NBUF,COUBUF(1,RCVBUF),
     &                                                     MIDR1,INFO)
	  CALL MPRCVA(FRTID,NMSG+NJUMP+P,IREAL*NBUF,BUF(1,RCVBUF),
     &                                                     MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*NBUF,COUBUF(1,SNDBUF),
     &                                                     MIDS1,INFO)
	  CALL MPSNDA(TOTID,NMSG+NJUMP+P,IREAL*NBUF,BUF(1,SNDBUF),
     &                                                     MIDS2,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*NBUF,COUBUF(1,RCVBUF),
     &                                                     MIDR1,INFO)
	  CALL MPRCVW(FRTID,NMSG+NJUMP+P,IREAL*NBUF,BUF(1,RCVBUF),
     &                                                     MIDR2,INFO)
        ENDIF
C**                                                                 ***
	S=0
	S1=0
        DO 140 I=1,NGROUP
	  IF (SKIP(I).EQ.0) THEN
	    S2=0
            NE    =GINFO(1,I)
            ADDNEK=GINFO(21,I)
            NEK1  =GINFO(22,I)
            TOTNT =GINFO(23,I)
	    DO 151 L=1,BLKLST(I)
	      DO 150 J=1,BB
	        DO 150 K=1,TOTNT
		  include"norec.h"
	          DO 150 Z=S2+1,S2+BLK(S1+L)
	            NH=BB*NEK(ADDNEK-1+Z+NEK1*(K-1))-BB+J-M01
	            IF ((0.LT.NH).AND.(NH.LE.M1)) THEN
		      BUF(NH,RCVBUF)=
     &                 BUF(NH,RCVBUF)+LOCU(S+Z+NE*(TOTNT*(J-1)+K-1))
		      COUBUF(NH,RCVBUF)=COUBUF(NH,RCVBUF)+1
                    ENDIF
 150          CONTINUE
	      S2=S2+BLK(S1+L)
 151        CONTINUE
	    S=S+TOTNT*BB*NE
          ENDIF
	  S1=S1+BLKLST(I)
 140    CONTINUE
C**                                                                 ***
	IF (P.NE.1) THEN
	  CALL MPSNDW(TOTID,NMSG+P,IINT*NBUF,COUBUF(1,SNDBUF),
     &                                                     MIDS1,INFO)
	  CALL MPSNDW(TOTID,NMSG+NJUMP+P,IREAL*NBUF,BUF(1,SNDBUF),
     &                                                     MIDS2,INFO)
        ENDIF
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF

120   CONTINUE
      NMSG=NMSG+2*NJUMP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** average value of U
C**   ------------------                                            ***
C**                                                                 ***
      COUNT=0
      DO 260 I=1,M
        IF (COUBUF(I,SNDBUF).GT.0) THEN
          U(I)=1./DBLE(COUBUF(I,SNDBUF)) * BUF(I,SNDBUF)
        ELSE
          COUNT=COUNT+1
          U(I)=0.
        ENDIF
 260  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM662----------------------------------------------------
      E    N    D
