C:::::      ,,,,,VEM664...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM664(NDEG,COUNT,NODNUM,NU,NN,U,
     &                  NDEGL,NDEG0L,SBT,LCBF,COUNBF,UBF,
     &                  MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEM664  adds a solution given at the geometrical nodes      ***
C**             at the processes to the vector of the geometrical   ***
C**             nodes over all processes and distributes this       ***
C**             vector back to the processes. so the data at the    ***
C**             geometrical nodes on different processors can be    ***
C**             equilized.                                          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           MYPROC,NPROC,NDEGL,NDEG0L,LCBF,NN,NU,NDEG,NMSG,
     &                  SBT
      INTEGER           COUNBF(2+LCBF,SBT),TIDS(NPROC),NODNUM(NDEG),
     &                  COUNT(NDEG)
      DOUBLE PRECISION  UBF(LCBF,NU,SBT),U(NN,NU)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NDEG   I  I   I in  I number of node coordinates on process
C--------I------I-----I------------------------------------------------
C COUNT  I  I   I i/o I number of contributions in U
C        I      I     I                              array: COUNT(NDEG)
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I global node id of the geometrical nodes
C        I      I     I                            array : NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NU     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C U      I  R   I i/o I solution at geoemtrical nodes 
C        I      I     I                                array : U(NN,NU)
C--------I------I-----I------------------------------------------------
C NDEGL  I  I   I in  I number of node in node buffer
C--------I------I-----I------------------------------------------------
C NDEG0L I  I   I in  I first node id number in node buffer-1
C--------I------I-----I------------------------------------------------
C SBT    I  I   I in  I =1 no switching buffer technique
C        I      I     I =2 use switching buffer technique
C--------I------I-----I------------------------------------------------
C COUNBF I  I   I -   I buffer of counter     array: COUNBF(2+LCBF,SBT)
C        I      I     I (LCBF>=maximal buffer length on all processes)
C--------I------I-----I------------------------------------------------
C UBF    I   R  I -   I solution buffer         array: UBF(LCBF,NU,SBT)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I  process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I  task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           J,P,Z,TOPROC,TOTID,FRPROC,FRTID,LBF,
     &                  INFO,MYTID,NH,NDEG1,NDEG01,LL9MAP,MIDS1,MIDS2,
     &                  MIDR1,MIDR2,SWPBUF,RCVBUF,SNDBUF
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      TOPROC=LL9MAP(MYPROC+1,NPROC)
      TOTID=TIDS(TOPROC)
      FRPROC=LL9MAP(MYPROC-1,NPROC)
      FRTID=TIDS(FRPROC)
      LBF=LCBF*NU
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the node solution is scattered:                               ***
C**   ------------------------------                                ***
C**                                                                 ***
      COUNBF(1,SNDBUF)=NDEGL
      COUNBF(2,SNDBUF)=NDEG0L
      DO 20 P=1,NPROC
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,NMSG+P,IINT*2,COUNBF(1,RCVBUF),MIDR1,INFO)
	    CALL MPSNDA(TOTID,NMSG+P,IINT*2,COUNBF(1,SNDBUF),MIDS1,INFO)
          ENDIF
          DO 11 J=1,NU
            DO 11 Z=1,LCBF
  11          UBF(Z,J,RCVBUF)=0.
          DO 10 Z=1,LCBF
  10        COUNBF(2+Z,RCVBUF)=0
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,NMSG+P,IINT*2,COUNBF(1,RCVBUF),MIDR1,INFO)
	    CALL MPSNDW(TOTID,NMSG+P,IINT*2,COUNBF(1,SNDBUF),MIDS1,INFO)
          ENDIF
	ELSE
C**                                                                 ***
	  CALL MPRCVA(FRTID,NMSG+P,IINT*(2+LCBF),COUNBF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	  CALL MPRCVA(FRTID,NMSG+NPROC+P,IREAL*LBF,UBF(1,1,RCVBUF),
     &                                                      MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*(2+LCBF),COUNBF(1,SNDBUF),
     &                                                      MIDS1,INFO)
	  CALL MPSNDA(TOTID,NMSG+NPROC+P,IREAL*LBF,UBF(1,1,SNDBUF),
     &                                                      MIDS2,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*(2+LCBF),COUNBF(1,RCVBUF),
     &                                                      MIDR1,INFO)
        ENDIF
        NDEG1=COUNBF(1,RCVBUF)
        NDEG01=COUNBF(2,RCVBUF)
C**                                                                 ***
C****** add counter                                                 ***
C**                                                                 ***
	include "norec.h"
	DO 30 Z=1,NDEG
	  NH=NODNUM(Z)-NDEG01
	  IF ((NH.GT.0).AND.(NH.LE.NDEG1)) THEN
	    COUNBF(2+NH,RCVBUF)=COUNBF(2+NH,RCVBUF)+COUNT(Z)
          ENDIF
30      CONTINUE
        IF (P.GT.1) THEN
	  CALL MPRCVW(FRTID,NMSG+NPROC+P,IREAL*LBF,UBF(1,1,RCVBUF),
     &                                                      MIDR2,INFO)
        ENDIF
C**                                                                 ***
C****** add solution:                                               ***
C**                                                                 ***
	DO 40 J=1,NU
	  include "norec.h"
	  DO 40 Z=1,NDEG
	  NH=NODNUM(Z)-NDEG01
	  IF ((NH.GT.0).AND.(NH.LE.NDEG1)) THEN
	    UBF(NH,J,RCVBUF)=UBF(NH,J,RCVBUF)+U(Z,J)
	  ENDIF
40      CONTINUE
C**                                                                 ***
        IF (P.GT.1) THEN
	  CALL MPSNDW(TOTID,NMSG+P,IINT*(2+LCBF),COUNBF(1,SNDBUF),
     &                                                      MIDS1,INFO)
	  CALL MPSNDW(TOTID,NMSG+NPROC+P,IREAL*LBF,UBF(1,1,SNDBUF),
     &                                                      MIDS2,INFO)
        ENDIF
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
20    CONTINUE
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the solution is gathered:                                 ***
C**   ----------------------------                                  ***
C**                                                                 ***
      DO 120 P=1,NPROC
	IF (P.LT.NPROC) THEN
	  CALL MPRCVA(FRTID,NMSG+P,IINT*(2+LCBF),COUNBF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	  CALL MPRCVA(FRTID,NMSG+NPROC+P,IREAL*LBF,UBF(1,1,RCVBUF),
     &                                                      MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*(2+LCBF),COUNBF(1,SNDBUF),
     &                                                      MIDS1,INFO)
	  CALL MPSNDA(TOTID,NMSG+NPROC+P,IREAL*LBF,UBF(1,1,SNDBUF),
     &                                                      MIDS2,INFO)
        ENDIF
        NDEG1=COUNBF(1,SNDBUF)
        NDEG01=COUNBF(2,SNDBUF)
C**                                                                 ***
C****** read counter on process from buffer:                        ***
C**                                                                 ***
	DO 130 Z=1,NDEG
	  NH=NODNUM(Z)-NDEG01
	  IF ((NH.GT.0).AND.(NH.LE.NDEG1)) THEN
	    COUNT(Z)=COUNBF(2+NH,SNDBUF)
	  ENDIF
130     CONTINUE
C**                                                                 ***
C****** read solution on process from buffer:                       ***
C**                                                                 ***
	DO 140 J=1,NU
	  DO 140 Z=1,NDEG
	   NH=NODNUM(Z)-NDEG01
	   IF ((NH.GT.0).AND.(NH.LE.NDEG1)) THEN
	     U(Z,J)=UBF(NH,J,SNDBUF)
	   ENDIF
140     CONTINUE
C**                                                                 ***
	IF (P.LT.NPROC) THEN
	  CALL MPRCVW(FRTID,NMSG+P,IINT*(2+LCBF),COUNBF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	  CALL MPRCVW(FRTID,NMSG+NPROC+P,IREAL*LBF,UBF(1,1,RCVBUF),
     &                                                      MIDR2,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IINT*(2+LCBF),COUNBF(1,SNDBUF),
     &                                                      MIDS1,INFO)
	  CALL MPSNDW(TOTID,NMSG+NPROC+P,IREAL*LBF,UBF(1,1,SNDBUF),
     &                                                      MIDS2,INFO)
        ENDIF
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
120   CONTINUE
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM664----------------------------------------------------
      E    N    D
