C:::::      ,,,,,VEM680...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM680 (UNIT,LU,U,LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &                   LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                   LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                   NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG,
     &                   LOUT,ERR)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM680  read the VECFEM arrays for restart                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
C**                    >                                            ***
      include"bytes.h"
      INTEGER          UNIT,LU,LIVEM,LLVEM,LRVEM,ERR,LOUT,LNOPRM,LNODN,
     &                 LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,LIDPRM,LNOD,LBIG

      DOUBLE PRECISION U(LU),RVEM(LRVEM),RPARM(LRPARM),RDPARM(LRDPRM),
     &                 NOD(LNOD),NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER          IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                 IDPARM(LIDPRM),NODNUM(LNODN),IBIG(LBIG*RPI)

      LOGICAL          LVEM(LLVEM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Parameters (see user's guide)                         ***
C**   ------------------                                            ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           MESH,LOUT1,NIVEM,Z,NBIG,NPROC2,NMSG,MYPROC,
     &                  NPROC,MYTID,IOTID,TIDS,NLNGTH(16),LLNGTH(16)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MESH=IVEM(1)
      LLNGTH(1)=LIVEM
      LLNGTH(2)=LRVEM
      LLNGTH(3)=LLVEM
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=LU
      LLNGTH(15)=0
      LLNGTH(16)=0
      DO 1  Z=1,16
1      NLNGTH(Z)=0
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=IVEM(202)
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      LOUT1=6
      IF (LOUT.GT.0) LOUT1=LOUT
      IF (UNIT.LE.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read length of IVEM :                                         ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=98
      REWIND(UNIT,ERR=1000)
      READ(UNIT,ERR=1000) NIVEM

      ERR=0
      NBIG=(NPROC+1+RPI-1)/RPI
      NLNGTH(1)=NIVEM
      NLNGTH(4)=NBIG
1000  CALL VEM098('VEM680',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),NMSG,
     &            IVEM(19),1,LOUT1)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read IVEM :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      DO 10 Z=0,NPROC
10      IBIG(Z+1)=IVEM(TIDS-1+Z)
      CALL VEM698(NIVEM,IVEM,UNIT,ERR)
      DO 20 Z=0,NPROC
20      IVEM(TIDS-1+Z)=IBIG(Z+1)

      IF (ERR.EQ.0) THEN
         NPROC2=IVEM(200)
         IF (NPROC.NE.NPROC2) THEN
           ERR=99
           WRITE(LOUT1,9221) NPROC2,NPROC,MYPROC,MYTID,NPROC2,NPROC
         ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** check the array lengths :                                   ***
C**     -----------------------                                     ***
C**                                                                 ***
        MESH  =IVEM(1)
        NLNGTH(2)=IVEM(6)
        NLNGTH(3)=IVEM(7)
        NLNGTH(5)=IVEM(MESH+1)
        NLNGTH(6)=IVEM(MESH+ 5)*IVEM(MESH+3)
        NLNGTH(7)=IVEM(MESH+13)*IVEM(MESH+14)
        NLNGTH(8)=IVEM(MESH+ 6)
        NLNGTH(9)=IVEM(MESH+ 8)
        NLNGTH(10)=IVEM(MESH+ 7)
        NLNGTH(11)=IVEM(MESH+ 9)
        NLNGTH(12)=IVEM(MESH+11)
        NLNGTH(13)=IVEM(MESH+10)
        NLNGTH(14)=IVEM(MESH+16)
      ENDIF
2000  CALL VEM098('VEM680',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IBIG(2),NMSG,
     &            IVEM(19),1,LOUT1)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start reading :                                               ***
C**   -------------                                                 ***
C**                                                                 ***
      CALL VEM697(NLNGTH(14),U,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM697(NLNGTH(2),RVEM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM699(NLNGTH(3),LVEM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM698(NLNGTH(5),NODNUM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM697(NLNGTH(6),NOD,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM697(NLNGTH(7),NOPARM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM698(NLNGTH(8),NEK,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM697(NLNGTH(10),RPARM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM698(NLNGTH(9),IPARM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM698(NLNGTH(11),DNOD,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM697(NLNGTH(13),RDPARM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM698(NLNGTH(12),IDPARM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** error handling :                                              ***
C**   --------------
C**                                                                 ***
 3000 CONTINUE
      IF (ERR.NE.0) WRITE(LOUT1,9220) MYPROC,MYTID,UNIT
      CALL VEM098('VEM680',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),NMSG,
     &            IVEM(19),1,LOUT1)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ----------                                                    ***
C**                                                                 ***
 9999 CONTINUE
      IVEM(202)=NMSG
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
9220  FORMAT('>>VEMCD:10:0010'
     &      /'>>VEM680 error: process ',I10,' (TID=',I10,')'
     &      / '>>reading of restart file from unit ',I2,' failed !')
9221  FORMAT('>>VEMCD:10:0011'
     &      /'>>VEM680 error: process ',I10,' (TID=',I10,')'
     &      /'>>restart file was generated by ',I5,' processors,'
     &      /'>>but the actual number of processors is ',I5,'.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM680----------------------------------------------------
      E    N    D
