C:::::      ,,,,,VEM681...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM681 (UNIT,LU,U,LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &                   LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                   LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                   NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG,
     &                   LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM681   save VECFEM arrays for restart                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
C**                    >                                            ***
      include"bytes.h"
      INTEGER          UNIT,LU,LIVEM,LLVEM,LRVEM,ERR,LOUT,LNOPRM,LNODN,
     &                 LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,LIDPRM,LNOD,LBIG

      DOUBLE PRECISION U(LU),RVEM(LRVEM),RPARM(LRPARM),RDPARM(LRDPRM),
     &                 NOD(LNOD),NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER          IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                 IDPARM(LIDPRM),NODNUM(LNODN),IBIG(LBIG*RPI)

      LOGICAL          LVEM(LLVEM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Parameters (see user's Guide)                         ***
C**   ------------------                                            ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           MESH,LOUT1,NPROC,MYPROC,NMSG,TIDS,IOTID,MYTID,
     &                  NLNGTH(16),LLNGTH(16)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MESH=IVEM(1)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=IVEM(202)
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      LOUT1=6
      IF (LOUT.GT.0) LOUT1=LOUT
      IF (UNIT.LE.0) GOTO 9999
      LLNGTH(1)=LIVEM
      LLNGTH(2)=LRVEM
      LLNGTH(3)=LLVEM
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=LU
      LLNGTH(15)=0
      LLNGTH(16)=0
      NLNGTH(1)=IVEM(5)
      NLNGTH(2)=IVEM(6)
      NLNGTH(3)=IVEM(7)
      NLNGTH(4)=0
      NLNGTH(5)=IVEM(MESH+1)
      NLNGTH(6)=IVEM(MESH+ 5)*IVEM(MESH+3)
      NLNGTH(7)=IVEM(MESH+13)*IVEM(MESH+14)
      NLNGTH(8)=IVEM(MESH+ 6)
      NLNGTH(9)=IVEM(MESH+ 8)
      NLNGTH(10)=IVEM(MESH+ 7)
      NLNGTH(11)=IVEM(MESH+ 9)
      NLNGTH(12)=IVEM(MESH+11)
      NLNGTH(13)=IVEM(MESH+10)
      NLNGTH(14)=IVEM(MESH+16)
      NLNGTH(15)=0
      NLNGTH(16)=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start writing :                                               ***
C**   --------------                                                ***
C**                                                                 ***
      ERR=98
      REWIND(UNIT,ERR=3000)
      WRITE(UNIT,ERR=3000) NLNGTH(1)
      ERR=0

      CALL VEM695(NLNGTH(1),IVEM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM694(NLNGTH(14),U,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM694(NLNGTH(2),RVEM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM696(NLNGTH(3),LVEM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM695(NLNGTH(5),NODNUM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM694(NLNGTH(6),NOD,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM694(NLNGTH(7),NOPARM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM695(NLNGTH(8),NEK,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM694(NLNGTH(10),RPARM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM695(NLNGTH(9),IPARM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM695(NLNGTH(11),DNOD,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM694(NLNGTH(13),RDPARM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
      CALL VEM695(NLNGTH(12),IDPARM,UNIT,ERR)
      IF (ERR.GT.0) GOTO 3000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** error handling :                                              ***
C**   --------------                                                ***
C**                                                                 ***
 3000 CONTINUE
      IF (ERR.GT.0) WRITE(LOUT1,9220) MYPROC,MYTID,UNIT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
 9999 CONTINUE
      CALL VEM098('VEM681',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),NMSG,
     &            IVEM(19),1,LOUT1)
      IVEM(202)=NMSG
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
9220  FORMAT('>>VEMCD:10:0015'
     &      /'>>VEM681 error: process ',I10,' (TID=',I10,')'
     &      /'>>writing of restart file to unit ',I2,' failed !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM681----------------------------------------------------
      E    N    D
