C:::::      ,,,,,VEM694...
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM694(N,RBIG,SAVE,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM694    writes the real array RBIG to unit ABS(SAVE).    ***
C**                IF SAVE>0, it will be written unformated         ***
C**                else list directed.                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N,SAVE,ERR
      DOUBLE PRECISION  RBIG(N)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C RBIG   I  R   I in  I real array                       array: RBIG(N)
C--------I------I-----I------------------------------------------------
C SAVE   I  I   I in  I unit of output file
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number (=6940 error occurs)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,S1,NVAL,I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ERR=0
      NVAL=3

      S1=ABS(SAVE)
      IF (N.GT.0) THEN
        IF (SAVE.GT.0) THEN
          WRITE (S1,ERR=9999) (RBIG(Z),Z=1,N)
        ELSE
          DO 10 I=1,N,NVAL
  10      WRITE (S1,*,ERR=9999) (RBIG(Z),Z=I,MIN(I+NVAL-1,N))
        ENDIF
      ENDIF
      GOTO 5000

9999  CONTINUE
      ERR=6940
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
5000  CONTINUE
      R E T U R N
C-----End of VEM694----------------------------------------------------
      E    N    D
