C:::::      ,,,,,VEM697...
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM697(N,RBIG,LOAD,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM697    reads the real array RBIG from unit ABS(LOAD).   ***
C**                IF LOAD>0, it will be read unformated            ***
C**                else list directed.                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N,LOAD,ERR
      DOUBLE PRECISION  RBIG(N)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C RBIG   I  R   I out I real array                       array: RBIG(N)
C--------I------I-----I------------------------------------------------
C LOAD   I  I   I in  I unit of input file
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number (=6970 error occurs)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,L1,NVAL,I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ERR=0
      NVAL=3

      L1=ABS(LOAD)
      IF (N.GT.0) THEN
        IF (LOAD.GT.0) THEN
           READ (L1,ERR=9999) (RBIG(Z),Z=1,N)
        ELSE
          DO 10 I=1,N,NVAL
  10       READ (L1,*,ERR=9999) (RBIG(Z),Z=I,MIN(I+NVAL-1,N))
        ENDIF
      ENDIF
      GOTO 5000

9999  CONTINUE
      ERR=6970
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
5000  CONTINUE
      R E T U R N
C-----End of VEM697----------------------------------------------------
      E    N    D
