C:::::      ,,,,,VEM695...
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM699(N,LBIG,LOAD,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM699    reads the logical array LBIG from unit ABS(LOAD).***
C**                IF LOAD>0, it will be read unformated            ***
C**                else list directed.                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N,LOAD,ERR
      LOGICAL           LBIG(N)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C LBIG   I  L   I out I logical array                    array: LBIG(N)
C--------I------I-----I------------------------------------------------
C LOAD   I  I   I in  I unit of input file
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number (=6990 error occurs)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,S1,NVAL,I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ERR=0
      NVAL=8

      S1=ABS(LOAD)
      IF (N.GT.0) THEN
        IF (LOAD.GT.0) THEN
           READ (S1,ERR=9999) (LBIG(Z),Z=1,N)
        ELSE
           DO 10 I=1,N,NVAL
  10       READ (S1,*,ERR=9999) (LBIG(Z),Z=I,MIN(I+NVAL-1,N))
        ENDIF
      ENDIF
      GOTO 5000

9999  CONTINUE
      ERR=6990
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
5000  CONTINUE
      R E T U R N
C-----End of VEM699----------------------------------------------------
      E    N    D
