C:::::      ,,,,,VEM700...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM700 (OWN,NGROUP,GINFO1,GINFO,SYM,NK,MASKOP,NEK,
     &                   PCLASS,MAXSTR,MOUNT1,MOUNT,LADD,ADD,
     &                   NINDEX,NIBIG,LINDEX,INDEX,
     &                   NMAT,ND,NJUMP,JUMP,NPROC,LMATBK,
     &                   PTRMBK,MYPROC,TIDS,NMSG,OUTCNT,ERR,LOUT)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM700  controls the packing of the global matrix and        ***
C**            computes the addresses ADD of the element matrices   ***
C**            in the array of the matrix. first the matrix is      ***
C**            stored with full and packed diagonals then (only in  ***
C**            case on nonvector processors) short diagonals are    ***
C**            joint to starry sky (see linsol(3)). The matrix      ***
C**            shape is determined by using a striping technique.   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,NK,LADD,NMAT,ND,STRIPS,MOUNT1,
     &                  PCLASS,MAXSTR,NINDEX,LINDEX,NIBIG,OWN,
     &                  NPROC,NJUMP,MYPROC,OUTCNT,ERR,LOUT,NMSG


      INTEGER           GINFO(GINFO1,NGROUP),MOUNT(MOUNT1,NGROUP),
     &                  NEK(*),ADD(LADD),INDEX(LINDEX),JUMP(NJUMP),
     &                  LMATBK(NPROC),PTRMBK(NPROC),TIDS(NPROC)

      LOGICAL           MASKOP(NK,NK,NGROUP),SYM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I mesh type
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations
C--------I------I-----I------------------------------------------------
C SYM    I  L   I in  I symmetry flag
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C MASKOP I  L   I in  I mask of the  couplings in the bilinear form
C        I      I     I array: MASKOP(NK,NK,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                     array: NEK(*)
C--------I------I-----I------------------------------------------------
C PCLASS I  I   I in  I pack class (see vem780)
C--------I------I-----I------------------------------------------------
C MAXSTR I  I   I in  I maximal number of stripes to pack the matrix
C--------I------I-----I------------------------------------------------
C MOUNT  I  I   I in  I infos for managing the mounting (see vem620)
C        I      I     I array: MOUNT(MOUNT1,NGROUP)
C--------I------I-----I------------------------------------------------
C ADD    I  I   I out I addresses of the element matrices in packed
C        I      I     I matrix                         array: ADD(LADD)
C--------I------I-----I------------------------------------------------
C NINDEX I  I   I out I length of INDEX array in use
C--------I------I-----I------------------------------------------------
C NIBIG  I  I   I out I needed length of INDEX (>>NINDEX since INDEX
C        I      I     I is used as workspace)
C--------I------I-----I------------------------------------------------
C INDEX  I  I   I out I index array of the packed matrix.
C        I      I     I  INDEX(1)=PTRVTS
C        I      I     I  INDEX(2)=NVTYP=number of linsol matrix shapes
C        I      I     I  INDEX(3)=INFOL=pointer to matrix infos in
C        I      I     I           INDEX. the pointer to the index is
C        I      I     I           relative to INDEX(1) !!
C        I      I     I  INDEX(4)=IL1=leading dimension of matrix infos
C        I      I     I  INDEX(5)=IL2=number of infos per shape
C        I      I     I  INDEX(PTRVTS)=
C        I      I     I  INDEX(PTRVTS+NVTYP*NPROC)=the indices.
C        I      I     I  INDEX(INFOL)=start of matrix infos
C        I      I     I INDEX is also used as workspace !
C        I      I     I                            array: INDEX(LINDEX)
C--------I------I-----I------------------------------------------------
C NMAT   I  I   I out I length of the packed matrix
C--------I------I-----I------------------------------------------------
C ND     I  I   I out I number of terms in the matrix subdivision
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I  number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I  JUMP(I)+MYPROC specify the process for the
C        I      I     I  send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I array : LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I array : PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I output control
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error code (global)
C        I      I     I =7000 index is too small, NIBIG gives the
C        I      I     I       needed length.
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I print unit
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  VEMSCD,TIME

      INTEGER           FPACK,NADD,OCCDEG(4),ODIAGG,UDIAGG,
     &                  DIAG,START,LM,MYTID,PROC,IHELP(3),
     &                  ODIAG,UDIAG,I,P,LUMAPG,MPINFO,SBT,LIBUF,IBUF,
     &                  OFFIND,NAIB,LL9MAP,DIAG1,PTRVTS,NVTYP,INFOL,
     &                  IL1,IL2,TYP,ENDE,LFREE,LBUF,DIAIND,
     &                  LSKY,L,IAC,IAR,LINDX2,PRCBLK,LUMAT,NMATL,
     &                  ADDIND,ADDMAT,NIND2,NUPD,NPD,NSS,NVT,NMATG
      EXTERNAL          VEM938
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ERR=0
      NMAT=0
      NINDEX=0
      ND=0
      TIME=VEMSCD()
      MYTID=TIDS(MYPROC)
      IF (NPROC.EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      OCCDEG(1)=0
      OCCDEG(2)=0
      OCCDEG(3)=0
      OCCDEG(4)=0

      LM=0
      DO 10 P=1,NPROC
	LM=MAX(LM,LMATBK(P))
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   DIAG1 gives the maximal number of diagonals                   ***
C**   in a matrix block:                                            ***
C**                                                                 ***
      IF (SYM) THEN
	DIAG1=LM
      ELSE
	DIAG1=2*LM-1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initialize the address array :                                ***
C**   ----------------------------                                  ***
C**                                                                 ***
      DO 20 I=1,LADD
	ADD(I)=0
20    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** reserve storage of mangament tables for linsol :              ***
C**   ----------------------------------------------                ***
C**                                                                 ***
      IL2=7
      PTRVTS=6
      NVTYP=12
      OFFIND=PTRVTS-1+NPROC*NVTYP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set the pack limits :                                         ***
C**   -------------------                                           ***
C**                                                                 ***
      CALL VEM780(FPACK,LSKY,IL2,LMATBK(MYPROC),PCLASS)
      IF (OUTCNT.NE.0) THEN
         WRITE(LOUT,9000)
         WRITE(LOUT,9010) PCLASS,FPACK,LSKY
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** is there enough storage to compute the diagonal addresses ?   ***
C**   ---------------------------------------------------------     ***
C**                                                                 ***
      NAIB=LINDEX-NPROC+1
      DIAG=NAIB-DIAG1*NJUMP
      LIBUF=DIAG1*NJUMP
      IBUF=1

      NIBIG=LINDEX-DIAG+1+LIBUF*SBT
      IF (LINDEX.LT.NIBIG) THEN
        ERR=7000
        WRITE (LOUT,9800) MYPROC,MYTID
      ENDIF
      IHELP(1)=ERR
      CALL LL4INM(1,1,1,IHELP(1),IHELP(2),IHELP(3),MYPROC,
     &                                                NPROC,TIDS,NMSG)
      ERR=IHELP(2)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** mark the naighbour processes in the NAIB mask :               ***
C**   ----------------------------------------------                ***
C**                                                                 ***
      DO 30 P=1,NPROC
       INDEX(NAIB-1+P)=0
30    CONTINUE
      PROC=MYPROC
      DO 40 P=1,NJUMP
        INDEX(NAIB-1+PROC)=1
        PROC=LL9MAP(PROC+JUMP(P),NPROC)
40    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the diagonal addresses of the element matrices :      ***
C**   ------------------------------------------------------        ***
C**                                                                 ***
      CALL VEM710(SYM,OWN,GINFO1,GINFO,LM,NK,NGROUP,MASKOP,
     &            NEK,DIAG1,INDEX(DIAG),MOUNT1,MOUNT,LADD,ADD,
     &            ND,NJUMP,JUMP,NPROC,LMATBK,PTRMBK,INDEX(NAIB),
     &            SBT,LIBUF,INDEX(IBUF),MYPROC,TIDS,NMSG)
      IF (OUTCNT.NE.0) WRITE (LOUT,9030) ND
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** SET  ADDRESSES OF MATRIX MANAGMENT VECTORS :
C**   ------------------------------------------
C**                                                                 ***
      TYP=DIAG-ND
      L=TYP-ND
      IAC=L-ND
      IAR=IAC-ND
      DIAIND=IAR-ND
      ADDIND=DIAIND-ND
      ADDMAT=ADDIND-ND
      PRCBLK=ADDMAT-(NJUMP+1)
      LINDX2=PRCBLK-1

      NIBIG=(LINDEX-LINDX2)+OFFIND
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** estimate the number of stripes :                              ***
C**   ------------------------------                                ***
C**                                                                 ***
      NIBIG=NIBIG+SBT*MAX(INT(DBLE(ND)*DBLE(LM)/DBLE(MAXSTR)+.5),LM)
      IF (NIBIG.GT.LINDEX) THEN
        ERR=7000
        WRITE (LOUT,9810) MYPROC,MYTID
      ENDIF
      IHELP(1)=ERR
      CALL LL4INM(1,1,1,IHELP(1),IHELP(2),IHELP(3),MYPROC,
     &                                                NPROC,TIDS,NMSG)
      ERR=IHELP(2)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set informations from diagonal mask :                         ***
C**   ------------------------------------                          ***
C**                                                                 ***
      CALL VEM730(DIAG1,INDEX(DIAG),NJUMP,JUMP,
     &            MYPROC,NPROC,LMATBK,PTRMBK,ND,INDEX(TYP),INDEX(L),
     &            INDEX(IAC),INDEX(IAR),INDEX(DIAIND),INDEX(PRCBLK))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** install the striping :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      NMAT=0
      NINDEX=0
C**                                                                 ***
C**** the UDIAG+1,....,ODIAG-th occupied diagonal are in the        ***
C**   current stripe:                                               ***
C**                                                                 ***
      ODIAG=0
C**                                                                 ***
C**** UDIAGG+1 and ODIAGG are the first and last diagonal in the    ***
C**   current stripe:                                               ***
C**                                                                 ***
      ODIAGG=INDEX(DIAIND)-1
C**                                                                 ***
C**** ENDE=1 => all diagonals are processed on all processes        ***
C**                                                                 ***
      ENDE=0
C**                                                                 ***
C**** STRIPS counts the stripes :                                   ***
C**                                                                 ***
      STRIPS=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of packing :                                            ***
C**   -----------------                                             ***
C**                                                                 ***
1234  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** define stripe : (error code is global)                        ***
C**   -------------                                                 ***
C**                                                                 ***
C**   START,...,START-1+LFREE is the available space in INDEX.      ***
C**                                                                 ***
      START=NINDEX+OFFIND+1
      LFREE=LINDX2-START+1
      CALL VEM751(SYM,LFREE,LBUF,UDIAG,UDIAGG,ODIAG,ODIAGG,LUMAT,
     &            LUMAPG,ND,INDEX(L),INDEX(IAC),
     &            INDEX(IAR),INDEX(DIAIND),DIAG1,NJUMP,INDEX(START),
     &            ENDE,SBT,NPROC,MYPROC,TIDS,NMSG,ERR)
C**                                                                 ***
C**** if the stripe is empty the computation stops:                 ***
C**                                                                 ***
      IF (ERR.GT.0) THEN
        NIBIG=START+(LINDEX-LINDX2)+
     &   SBT*MAX(INT(DBLE(ND-UDIAG)*DBLE(LM)/MAX(MAXSTR-STRIPS,1)),LM)
        ERR=7000
        WRITE (LOUT,9810) MYPROC,MYTID
        GOTO 9999
      ENDIF
      NIBIG=MAX(NIBIG,START-1+LBUF+(LINDEX-LINDX2))
      IF (ENDE.LE.1) THEN
        STRIPS=STRIPS+1
        IF (OUTCNT.NE.0) WRITE (LOUT,9020) STRIPS,ODIAG-UDIAG,LUMAPG
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute the addresses of the element matrices, which        ***
C**     are mounted into the current stripe :                       ***
C**     ----------------------------------------------------        ***
C**                                                                 ***
        CALL VEM720(SYM,OWN,GINFO1,GINFO,NK,NGROUP,MASKOP,NEK,
     &              LUMAPG,UDIAGG,ODIAGG,LUMAT,NMAT*NJUMP,LBUF,
     &              INDEX(NINDEX+OFFIND+1),MOUNT1,MOUNT,LADD,ADD,
     &              NJUMP,JUMP,NPROC,LMATBK,MYPROC,TIDS,NMSG)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** make the address array continous :                          ***
C**     --------------------------------                            ***
C**                                                                 ***
        CALL VEM701(NGROUP,GINFO1,GINFO,MOUNT1,MOUNT,ADD,NADD)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** pack the matrix stripe and assign new addresses to the      ***
C**     element matrices :                                          ***
C**     ----------------                                            ***
C**                                                                 ***
        LFREE=NINDEX+SBT*LUMAPG
        CALL VEM750(NMAT,NINDEX,LFREE,INDEX(OFFIND+1),ND,
     &              INDEX(L),INDEX(TYP),INDEX(IAC),INDEX(IAR),
     &              INDEX(ADDIND),INDEX(ADDMAT),
     &              UDIAG,ODIAG,FPACK,LSKY,OCCDEG,LUMAPG,
     &              LADD,ADD,NJUMP,JUMP,NPROC,MYPROC,TIDS,NMSG)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of the stripe loop :                                      ***
C**   ----------------------                                        ***
C**                                                                 ***
        GOTO 1234
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute dimensions of the linsol tables :                     ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      NIND2=NINDEX
      CALL VEM731(LSKY,ND,INDEX(L),INDEX(TYP),INDEX(ADDMAT),
     &            NINDEX,INDEX(PRCBLK),
     &            NUPD,NPD,NSS,NVT,NJUMP,JUMP)
      IL1=NVT
      INFOL=OFFIND+NINDEX+1
      NINDEX=INFOL+IL1*IL2-1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** is there enough storage to create the linsol tables :         ***
C**   ---------------------------------------------------           ***
C**                                                                 ***
      NIBIG=MAX(NIBIG,NINDEX+(LINDEX-PRCBLK+1))
      IF (NIBIG.GT.LINDEX) THEN
        ERR=7000
        WRITE (LOUT,9800) MYPROC,MYTID
      ENDIF
      IHELP(1)=ERR
      CALL LL4INM(1,1,1,IHELP(1),IHELP(2),IHELP(3),MYPROC,
     &                                                NPROC,TIDS,NMSG)
      ERR=IHELP(2)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** join short diagonals and create the linsol tables :           ***
C**   -------------------------------------------------             ***
C**                                                                 ***
      CALL VEM732(NINDEX,NMATL,INDEX(OFFIND+1),OFFIND,NIND2,IL1,IL2,
     &            INDEX(INFOL),NVTYP,INDEX(PTRVTS),ND,INDEX(TYP),
     &            INDEX(L),INDEX(IAR),INDEX(IAC),INDEX(ADDMAT),
     &            INDEX(ADDIND),INDEX(PRCBLK),
     &            NJUMP,JUMP,NPROC,MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute global matrix length:                                 ***
C**   ----------------------------                                  ***
C**                                                                 ***
      IHELP(1)=NMATL
      CALL LL4RED(VEM938,IHELP(2),IHELP(1),1*IINT,
     &            MYPROC,NPROC,TIDS,NMSG)
      NMATG=IHELP(1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print messages :                                              ***
C**   --------------                                                ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        WRITE (LOUT,9050) STRIPS
        WRITE (LOUT,9070) OCCDEG
        WRITE (LOUT,9090) NUPD
        WRITE (LOUT,9080) NPD
        WRITE (LOUT,9100) NSS
        WRITE (LOUT,9105) NVT
        WRITE (LOUT,9115) NADD
        WRITE (LOUT,9120) NINDEX
        WRITE (LOUT,9110) NMAT
	IF (NPROC.GT.1) THEN
          WRITE (LOUT,9111) NMATG
          WRITE (LOUT,9112) NMATG/NPROC
	ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's is !                                                   ***
C**   -----------                                                   ***
C**                                                                 ***
9999  CONTINUE
      INDEX(1)=PTRVTS
      INDEX(2)=NVTYP
      INDEX(3)=INFOL
      INDEX(4)=IL1
      INDEX(5)=IL2
      ND=NVT
      TIME=VEMSCD()-TIME
      IF (OUTCNT.NE.0) THEN
        IF (ERR.EQ.0) THEN
          WRITE (LOUT,9700) TIME
        ELSE
          WRITE (LOUT,9710) TIME
        ENDIF
      ENDIF
C***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
9000  FORMAT(/'  addresses of element matrices and packing',
     &                            ' of the global matrix'/2X,62('-')/)
9010  FORMAT('    pack class ',I2,'  limit for packed diagonals ...',
     &                                      '.........(%) = ',I10/
     &       '                   length of short diagonals .....',
     &                                       '........... = ',I10)
9030  FORMAT('    number of occupied diagonals on process .....',
     &                                      '............ = ',I10)
9020  FORMAT('    stripe ',I6,' : length of ',I6,' occupied',
     &                                  ' diagonals ......= ',I10)
9050  FORMAT('    needed stripes ..............................',
     &                                      '............ = ',I10)
9080  FORMAT('    number of packed diagonals ..................',
     &                                      '............ = ',I10)
9090  FORMAT('    number of unpacked diagonals ................',
     &                                      '............ = ',I10)
9100  FORMAT('    number of starry skies ......................',
     &                                      '............ = ',I10)
9105  FORMAT('    number of shapes ............................',
     &                                      '............ = ',I10)
9115  FORMAT('    length of address array .....................',
     &                                      '............ = ',I10)
9110  FORMAT('    length of matrix array ......................',
     &                                      '............ = ',I10)
9111  FORMAT('    length of matrix over all processors ........',
     &                                      '............ = ',I10)
9112  FORMAT('                     per processor ..............',
     &                                      '............ = ',I10)
9120  FORMAT('    length of index array .......................',
     &                                      '............ = ',I10)
9070  FORMAT('    number of diagonals with occupation between :',
     &           ' 0 and  25 % = ',I10/
     &       49X,'25 and  50 % = ',I10/
     &       49X,'50 and  75 % = ',I10/
     &       49X,'75 and 100 % = ',I10)
9700  FORMAT(/'  computation ended successfully. ',
     &                                 '(time = ',F10.2,' sec)'/)
9710  FORMAT(/'  computation failed. (time = ',F10.2,' sec)'/)

9800  FORMAT(/'>>VEMCD:30:0200'
     &       /'>>VEM700 error: process ',I10,' (TID=',I10,')'
     &       /'>>Too small storage for INDEX array.'
     &       /'>>action: give more R/IBIG.')
9810  FORMAT(/'>>VEMCD:30:0201'
     &       /'>>VEM700 error: process ',I10,' (TID=',I10,')'
     &       /'>>Too small storage for packing of matrix.'
     &       /'>>action: increase MSPACK or give more R/IBIG.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM700----------------------------------------------------
      E    N    D
