C:::::      ,,,,,VEM701...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM701(NGROUP,GINFO1,GINFO,MOUNT1,MOUNT,ADD,NADD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM701  makes the address array continous so that          ***
C**              ADD can be interpretes as a long vector            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,MOUNT1,NADD

      INTEGER           GINFO(GINFO1,NGROUP),MOUNT(MOUNT1,NGROUP),ADD(*)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos         array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C MOUNT  I  I   I in  I infos for managing the mounting (see vem620)
C        I      I     I array: MOUNT(MOUNT1,NGROUP)
C--------I------I-----I------------------------------------------------
C ADD    I  I   I i/o I addresses of the element matrices in packed
C        I      I     I matrix                         array: ADD(LADD)
C--------I------I-----I------------------------------------------------
C NADD   I  I   I out I length of the address file in use
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NE,LEAD,SLICE,J,I,Z
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      NADD=0
      DO 10 I=1,NGROUP

        NE=GINFO(1,I)
        SLICE=MOUNT(1,I)
        LEAD=MOUNT(9,I)

        IF (NE*SLICE.NE.0) THEN

           DO 12 J=NE+1,LEAD
             include "norec.h"
             DO 15 Z=1,SLICE
               ADD(NADD+(Z-1)*LEAD+J)=ADD(NADD+(Z-1)*LEAD+1)
  15         CONTINUE
 12        CONTINUE

          ENDIF
	  NADD=NADD+LEAD*SLICE

10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM701----------------------------------------------------
      E    N    D
