C:::::      ,,,,,VEM710...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM710(SYM,OWN,GINFO1,GINFO,LM,NK,NGROUP,MASKOP,
     &                  NEK,DIAG1,DIAG,MOUNT1,MOUNT,LADD,ADD,ND,
     &                  NJUMP,JUMP,NPROC,LMATBK,PTRMBK,NAIB,
     &                  SBT,LIBUF,IBUF,MYPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEM710  controls the calculation of the diagonal addresses  ***
C**             of the element matrices. The diagonal mask DIAG     ***
C**             is sent around, so that every process marks its     ***
C**             contributions to diagonals in the matrix stripe     ***
C**             on this process.                                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NK,NGROUP,LM,LADD,GINFO1,ND,OWN,MOUNT1,
     &                  NPROC,NJUMP,MYPROC,DIAG1,NMSG,LIBUF,SBT

      INTEGER           ADD(LADD),NEK(*),
     &                  MOUNT(MOUNT1,NGROUP),NAIB(NPROC),JUMP(NJUMP),
     &                  GINFO(GINFO1,NGROUP),DIAG(DIAG1,NJUMP),
     &                  LMATBK(NPROC),PTRMBK(NPROC),TIDS(NPROC),
     &                  IBUF(LIBUF,SBT)

      LOGICAL           SYM,MASKOP(NK,NK,NGROUP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C SYM    I  L   I in  I symmetry flag
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I mesh type
C--------I------I-----I-----------------------------------------------
C GINFO  I  I   I in  I group infos         array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C LM     I  I   I in  I maximal number of unknowns on processes
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C MASKOP I  L   I in  I mask of the  couplings in the bilinear form
C        I      I     I array: MASKOP(NK,NK,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                     array: NEK(*)
C--------I------I-----I------------------------------------------------
C DIAG   I  I   I out I masks of the occupied diagonals
C        I      I     I DIAG(i,p)=1 => i-th diagonal in p-th matrix block
C        I      I     I on the proccess is occupied. p=1 is the main
C        I      I     I diagonal block.
C        I      I     I array: DIAG(DIAG1,NJUMP)
C        I      I     I        SYM => DIAG1=LM
C        I      I     I  .not. SYM => DIAG1=2*LM-1
C--------I------I-----I------------------------------------------------
C MOUNT  I  I   I in  I infos for managing the mounting (see vem620)
C        I      I     I array: MOUNT(MOUNT1,NGROUP)
C--------I------I-----I------------------------------------------------
C ADD    I  I   I out I addresses of the element matrices in packed
C        I      I     I matrix                         array: ADD(LADD)
C--------I------I-----I------------------------------------------------
C ND     I  I   I out I number of occupied diagonals
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I  number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I  JUMP(I)+MYPROC specify the process for the
C        I      I     I  send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I array : LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I array : PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I communication buffer
C        I      I     I array : IBUF(LIBUF,SBT) (LIBUF>=DIAG1*NJUMP)
C--------I------I-----I------------------------------------------------
C NAIB   I  I   I in  I mask of processes gives contribution to the
C        I      I     I diagonals on the process.
C        I      I     I array : NAIB(NPROC)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I  process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I  task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NE,NELTYP,NEK1,ADDNEK,ADDELM,LEAD,SLICE,I,NK2,
     &                  TOTNT,P,PROC,TOTID,FRTID,MIDS1,MIDR1,INFO,M,
     &                  LL9MAP,SWPBUF,RCVBUF,SNDBUF,MIDR2,MIDS2,Q,
     &                  LMSG(2),I1,SLBUF,RLBUF
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)
      SLBUF=1
      RLBUF=2
      NK2=MAX(1,OWN)
      M=LMATBK(MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initialize the diagonal masks :                               ***
C**   -----------------------------                                 ***
C**                                                                 ***
      DO 10 P=1,NJUMP
        DO 10 I=1,DIAG1
          DIAG(I,P)=0
 10   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start the marking procedure :                                 ***
C**   ---------------------------                                   ***
C**                                                                 ***
      PROC=MYPROC
      DO 400 P=1,NJUMP
C**                                                                 ***
C****** send to right and reveive from left processor :             ***
C**                                                                 ***
	PROC=LL9MAP(PROC-JUMP(P),NPROC)
	IF (P.GT.1) THEN
	  FRTID=TIDS(LL9MAP(MYPROC-JUMP(P),NPROC))
	  TOTID=TIDS(LL9MAP(MYPROC+JUMP(P),NPROC))
	  CALL MPRCVA(FRTID,NMSG+P,IINT,LMSG(RLBUF),MIDR1,INFO)
	  LMSG(SLBUF)=0
	  DO 50 Q=1,NJUMP 
	    DO 50 I=1,DIAG1  
              IF (DIAG(I,Q).NE.0) THEN
		LMSG(SLBUF)=LMSG(SLBUF)+1
		IBUF(LMSG(SLBUF),SNDBUF)=NJUMP*I+Q-1
              ENDIF
50        CONTINUE
	  CALL MPSNDA(TOTID,NMSG+P,IINT,LMSG(SLBUF),MIDS1,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT,LMSG(RLBUF),MIDR1,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IINT,LMSG(SLBUF),MIDS1,INFO)
	  CALL MPRCVA(FRTID,NMSG+P+NJUMP,IINT*LMSG(RLBUF),
     &                                IBUF(1,RCVBUF),MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+P+NJUMP,IINT*LMSG(SLBUF),
     &                                IBUF(1,SNDBUF),MIDS2,INFO)
          DO 60 Q=1,NJUMP
           DO 60 I=1,DIAG1
              DIAG(I,Q)=0
 60       CONTINUE
	  CALL MPRCVW(FRTID,NMSG+P+NJUMP,IINT*LMSG(RLBUF),
     &                                IBUF(1,RCVBUF),MIDR2,INFO)
           DO 70 I=1,LMSG(RLBUF)
	      I1=IBUF(I,RCVBUF)/NJUMP
              DIAG(I1,IBUF(I,RCVBUF)-I1*NJUMP+1)=1
 70       CONTINUE
	  CALL MPSNDW(TOTID,NMSG+P+NJUMP,IINT*LMSG(SLBUF),
     &                               IBUF(1,SNDBUF),MIDS2,INFO)
        ENDIF
C**                                                                 ***
C****** mark contributions to diagonals on process PROC :           ***
C**                                                                 ***
	ADDELM=1
        DO 100 I=1,NGROUP
          NE     = GINFO(1,I)
          SLICE  = MOUNT(1,I)
          LEAD   = MOUNT(9,I)
          ADDNEK = GINFO(21,I)
          NEK1   = GINFO(22,I)
          TOTNT  = GINFO(23,I)
          NELTYP = 24
          IF (NE*SLICE.GT.0) THEN
            IF (SYM) THEN
              CALL VEM711(NK,NE,NK2,GINFO(NELTYP,I),
     &                    NEK1,TOTNT,NEK(ADDNEK),MASKOP(1,1,I),
     &                    LEAD,SLICE,ADD(ADDELM),PROC,LM,DIAG,
     &                    NJUMP,JUMP,NPROC,LMATBK,PTRMBK,NAIB)
            ELSE
              CALL VEM712(NK,NE,NK2,GINFO(NELTYP,I),
     &                    NEK1,TOTNT,NEK(ADDNEK),MASKOP(1,1,I),
     &                    LEAD,SLICE,ADD(ADDELM),PROC,LM,DIAG,
     &                    NJUMP,JUMP,NPROC,LMATBK,PTRMBK,NAIB)
            ENDIF
            ADDELM=ADDELM+LEAD*SLICE
          ENDIF
  100   CONTINUE

        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
        SWPBUF=RLBUF
        RLBUF=SLBUF
        SLBUF=SWPBUF
400   CONTINUE
      NMSG=NMSG+2*NJUMP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** count the occupied diagonals on the process :                 ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      DIAG(M,1)=1
      ND=0
      PROC=MYPROC
      IF (SYM) THEN
        DO 200 P=1,NJUMP
          DO 201 I=1,LMATBK(PROC)
            IF (DIAG(I,P).NE.0) THEN
              ND=ND+1
            ENDIF
 201      CONTINUE
	  PROC=LL9MAP(PROC+JUMP(P),NPROC)
 200    CONTINUE
      ELSE
        DO 210 P=1,NJUMP
          DO 211 I=1,2*LMATBK(PROC)-1
            IF (DIAG(I,P).NE.0) THEN
              ND=ND+1
            ENDIF
211       CONTINUE
	  PROC=LL9MAP(PROC+JUMP(P),NPROC)
210     CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM710----------------------------------------------------
      E    N    D
