C:::::      ,,,,,VEM712...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM712(NK,NE,NK2,NELTYP,NEK1,TOTNT,NEK,MASKOP,
     &                  ADD1,ADD2,ADD,PROC,LM,DIAG,
     &                  NJUMP,JUMP,NPROC,LMATBK,PTRMBK,NAIB)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM712 computes the diagonal addresses and mark the occupied ***
C**           diagonals for the diagonals on prpcessor PROC for     ***
C**           the nonsymmetrical case                               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NK,NE,NK2,ADD2,NEK1,ADD1,TOTNT,LM,
     &                  NPROC,NJUMP,PROC

      INTEGER           NEK(NEK1,TOTNT),NELTYP(NK2),NAIB(NPROC),
     &                  DIAG(2*LM-1,NJUMP),ADD(ADD1,ADD2),
     &                  JUMP(NJUMP),LMATBK(NPROC),PTRMBK(NPROC)

      LOGICAL           MASKOP(NK,NK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NE     I  I   I in  I number of elements
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I order of the proposal functions
C        I      I     I                              array: NELTYP(NK2)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I the element list         array: NEK(NEK1,TOTNT)
C--------I------I-----I------------------------------------------------
C MASKOP I  L   I in  I mask of the  couplings in the bilinear form
C        I      I     I array: MASKOP(NK,NK)
C--------I------I-----I------------------------------------------------
C ADD    I  I   I out I number * (-1) of the diagonal the entry of the
C        I      I     I element matrix has to be mounted,
C        I      I     I only addresses in the current diagonal mask
C        I      I     I are computed !
C        I      I     I ADD=NJUMP*(2*LM-1)*(PROC-1)+i+LM*(p-1)
C        I      I     I is the i-th diagonal in the p-the matric block
C        I      I     I on processor PROC.
C        I      I     I ADD1>=NE, ADD2=size of element matrix.
C        I      I     I array : ADD(ADD1,ADD2)
C--------I------I-----I------------------------------------------------
C PROC   I  I   I in  I process id number of current diagonal mask
C--------I------I-----I------------------------------------------------
C DIAG   I  I   I i/o I mask of the occupied diagonals on processor
C        I      I     I PROC
C        I      I     I array : DIAG(2*LM-1,NJUMP)
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I  number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I  JUMP(I)+MYPROC specify the process for the
C        I      I     I  send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I array : LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I array : PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C NAIB   I  I   I in  I mask of the naibour processes of MYPROC
C        I      I     I array : NAIB(NPROC)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           J1,J2,K,Z,R,CC0,CR0,I1,I2,CR,CC,BB,BCC,BCR,
     &                  ROW,COL,NTROW,NTCOL,NROW,NCOL,ST,M,M0,PROC1,
     &                  COLM,COLM0,P,LL9MAP,LM2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      BB=NK-NK2+1
      M=LMATBK(PROC)
      M0=PTRMBK(PROC)
      PROC1=PROC
      LM2=2*LM-1

      DO 1000 P=1,NJUMP
	IF (NAIB(PROC1).EQ.1) THEN
	COLM=LMATBK(PROC1)
	COLM0=PTRMBK(PROC1)
        R=0
        CR0=0
        CC0=TOTNT-NELTYP(MIN(NK2,NK))
	
        DO 500 I1=1,2*NK-1

          IF ((I1.GT.NK).AND.(I1-NK.LT.NK2)) CR0=CR0+NELTYP(I1-NK)
          IF ((I1.LE.NK).AND.(NK-I1+1.LT.NK2)) CC0=CC0-NELTYP(NK-I1+1)

          CR=CR0
          CC=CC0

          DO 501 I2=1,NK-ABS(NK-I1)

            ROW=MAX(0,I1-NK)+I2
            COL=MAX(0,NK-I1)+I2

            BCR=MAX(ROW,NK2)-NK
            BCC=MAX(COL,NK2)-NK

            NTROW=NELTYP(MIN(ROW,NK2))
            NTCOL=NELTYP(MIN(COL,NK2))

            IF (MASKOP(ROW,COL).AND.(NTCOL*NTROW.GT.0)) THEN

              DO 110 J1=1,NTROW
               DO 110 J2=1,NTCOL

                K=R+NTCOL*(J1-1)+J2

                DO 120 Z=1,NE
                  NROW=BB*NEK(Z,CR+J1)+BCR-M0
                  NCOL=BB*NEK(Z,CC+J2)+BCC-COLM0
		  IF ((NROW.GT.0).AND.(NROW.LE.M).AND.
     &  	      (NCOL.GT.0).AND.(NCOL.LE.COLM)) THEN
                    ST=COLM+NROW-NCOL
                    ADD(Z,K)=-(ST+LM2*(P-1)+LM2*NJUMP*(PROC-1))
                    DIAG(ST,P)=1
                  ENDIF
 120            CONTINUE
110           CONTINUE

              R=R+NTROW*NTCOL

            ENDIF

            IF (ROW.LT.NK2) CR=CR+NTROW
            IF (COL.LT.NK2) CC=CC+NTCOL

 501      CONTINUE

500       CONTINUE
	ENDIF
	PROC1=LL9MAP(PROC1+JUMP(P),NPROC)
1000  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM712----------------------------------------------------
      E    N    D
