C:::::      ,,,,,VEM720...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM720(SYM,OWN,GINFO1,GINFO,NK,NGROUP,MASKOP,
     &                  NEK,LUMAPG,UDIAGG,ODIAGG,LUMAT,
     &                  START0,LMASK,MASK,MOUNT1,MOUNT,LADD,ADD,
     &                  NJUMP,JUMP,NPROC,LMATBK,MYPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM720  controls the computation of the addresses of the   ***
C**              element matrices in the unpacked matrix and        ***
C**              marks the occupied entries for a stripe of         ***
C**              diagonals.                                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NK,NGROUP,LADD,GINFO1,OWN,START0,
     &                  MOUNT1,NPROC,NJUMP,MYPROC,LUMAT,
     &                  LUMAPG,NMSG,LMASK,ODIAGG,UDIAGG

      INTEGER           ADD(LADD),NEK(*),MOUNT(MOUNT1,NGROUP),
     &                  GINFO(GINFO1,NGROUP),
     &                  JUMP(NJUMP),LMATBK(NPROC),TIDS(NPROC),
     &                  MASK(LMASK)

      LOGICAL           SYM,MASKOP(NK,NK,NGROUP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C SYM    I  L   I in  I symmetry flag
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I mesh type
C--------I------I-----I-----------------------------------------------
C GINFO  I  I   I in  I group infos         array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C MASKOP I  L   I in  I mask of the  couplings in the bilinear form
C        I      I     I array: MASKOP(NK,NK,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                     array: NEK(*)
C--------I------I-----I------------------------------------------------
C LUMAPG I  I   I in  I length of the unpacked matrix stripe =>
C        I      I     I the unpacked matrix on relative processor p
C        I      I     I is addressed in the range START0+LUMAPG*(p-1)+1
C        I      I     I to START0+LUMAPG*p
C--------I------I-----I------------------------------------------------
C UDIAGG I      I in  I defined the range of diagonals
C ODIAGG I      I     I in the current stripes
C--------I------I-----I------------------------------------------------
C LUMAT  I      I in  I length of the unpacked matrix 
C        I      I     I in the current stripes
C--------I------I-----I------------------------------------------------
C MASK   I      I in  I MASK(i)=start address of diagonal UDIAGG+i.
C        I      I out I MASK(i)<0  => nonzero entry at position
C        I      I     I               i in unpacked matrix in
C        I      I     I               the current stripe
C        I      I     I at the end maximal MASK(LUMAPG) is significant,
C        I      I     I but in the case of SBT=2 the range LUMAPG+1 to
C        I      I     I LMASK is used as communication buffer.
C        I      I     I array: MASK(LMASK) 
C--------I------I-----I------------------------------------------------
C MOUNT  I  I   I in  I infos for managing the mounting (see vem620)
C        I      I     I array: MOUNT(MOUNT1,NGROUP)
C--------I------I-----I------------------------------------------------
C ADD    I  I   I in  I  diagonal addresses*(-1) of element matrices
C        I      I out I  addresses in the unpacked matrix stripe
C        I      I     I  (only for diagonal addresses in UDIAGG+1,ODIAGG;
C        I      I     I  the address is set >START0)
C        I      I     I  array : ADD(LADD)
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I  number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I  JUMP(I)+MYPROC specify the process for the
C        I      I     I  send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I array : LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I array : PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C NAIB   I  I   I in  I mask of processes gives contribution to the
C        I      I     I diagonals on the process.
C        I      I     I array : NAIB(NPROC)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I  process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I  task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NE,NELTYP,NEK1,ADDNEK,ADDELM,LEAD,SLICE,I,NK2,
     &                  TOTNT,P,PROC,TOTID,FRTID,MIDS2,MIDR2,INFO,M,
     &                  LL9MAP,START1,MIDS1,MIDR1,LMSGS,LMSGR,HERE,
     &                  SWPBUF,RCVBUF,SNDBUF,MSG(4,2),START
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      NK2=MAX(1,OWN)
      M=LMATBK(MYPROC)
      START1=START0
      PROC=MYPROC
      SNDBUF=1
      IF (NJUMP.EQ.1) THEN
        RCVBUF=1
      ELSE
        RCVBUF=2
      ENDIF
      MSG(1,SNDBUF)=UDIAGG
      MSG(2,SNDBUF)=ODIAGG
      MSG(3,SNDBUF)=LUMAT
      START=1

      DO 400 P=1,NJUMP
	PROC=LL9MAP(PROC-JUMP(P),NPROC)
	FRTID=TIDS(LL9MAP(MYPROC-JUMP(P),NPROC))
	TOTID=TIDS(LL9MAP(MYPROC+JUMP(P),NPROC))
C**                                                                 ***
C****** pack entries in the mask: LMSGS counts the last used entry  ***
C**     in MASK                                                     ***
C**                                                                 ***
        LMSGS=0
	IF (P.GT.1) THEN
	  include"norec.h"
  	  DO 411 I=1,LUMAT
	    IF (MASK(I).LT.0) THEN
	      LMSGS=LMSGS+1
	      MASK(LMSGS)=I
            ENDIF
411       CONTINUE
          include"norec.h"
	  DO 412 I=1,ODIAGG-UDIAGG
	    MASK(LMSGS+I)=MASK(START-1+I)
412       CONTINUE
	ENDIF
        LMSGS=LMSGS+ODIAGG-UDIAGG
	MSG(4,SNDBUF)=LMSGS
C**                                                                 ***
C*****  send index length and diagonal informations                 ***
C**                                                                 ***
	IF (NJUMP.GT.1) THEN
	  CALL MPRCVA(FRTID,NMSG+P,IINT*4,MSG(1,RCVBUF),MIDR1,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*4,MSG(1,SNDBUF),MIDS1,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*4,MSG(1,RCVBUF),MIDR1,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IINT*4,MSG(1,SNDBUF),MIDS1,INFO)
        ENDIF
	UDIAGG=MSG(1,RCVBUF)
	ODIAGG=MSG(2,RCVBUF)
	LUMAT=MSG(3,RCVBUF)
	LMSGR=MSG(4,RCVBUF)
	START=LMASK-(ODIAGG-UDIAGG)+1
C**                                                                 ***
C*****  send index                                                  ***
C**                                                                 ***
	IF (NJUMP.GT.1) THEN
	  IF (LMSGR.GT.0) 
     &          CALL MPRCVA(FRTID,NMSG+P+NJUMP,IINT*LMSGR,
     &                      MASK(LMASK-LMSGR+1),MIDR2,INFO)
	  IF (LMSGS.GT.0) 
     &          CALL MPSNDA(TOTID,NMSG+P+NJUMP,IINT*LMSGS,
     &                      MASK,MIDS2,INFO)
	  IF (LMSGR.GT.0) 
     &          CALL MPRCVW(FRTID,NMSG+P+NJUMP,IINT*LMSGR,
     &                      MASK(LMASK-LMSGR+1),MIDR2,INFO)
	  IF (LMSGS.GT.0) 
     &          CALL MPSNDW(TOTID,NMSG+P+NJUMP,IINT*LMSGS,
     &                      MASK,MIDS2,INFO)
        ELSE
          include"norec.h"
	  DO 415 I=ODIAGG-UDIAGG,1,-1
	    MASK(START-1+I)=MASK(I)
415       CONTINUE
        ENDIF
	DO 413 I=1,MIN(LMASK-LMSGR,LUMAT)
	   MASK(I)=0
413     CONTINUE
C**                                                                 ***
C****** unpack the mask index:                                      ***
C**                                                                 ***
	include"norec.h"
	DO 414 I=LMASK-LMSGR+1,START-1
	    HERE=MASK(I)
	    MASK(HERE)=-1
414     CONTINUE
C**                                                                 ***
C*****  mark the entries into the current matrix stripe :           ***
C**                                                                 ***
	IF (ODIAGG.GT.UDIAGG) THEN
	 ADDELM=1
         DO 100 I=1,NGROUP
          NE=GINFO(1,I)
          SLICE=MOUNT(1,I)
          LEAD=MOUNT(9,I)
          ADDNEK=GINFO(21,I)
          NEK1=GINFO(22,I)
          TOTNT=GINFO(23,I)
          NELTYP=24

          IF (NE*SLICE.GT.0) THEN
            IF (SYM) THEN
              CALL VEM721(NK,NE,NK2,GINFO(NELTYP,I),NEK1,TOTNT,
     &                    NEK(ADDNEK),MASKOP(1,1,I),LEAD,SLICE,
     &                    ADD(ADDELM),UDIAGG,ODIAGG,START1,
     &                    MASK(START),LUMAPG,MASK)
            ELSE
              CALL VEM722(NK,NE,NK2,GINFO(NELTYP,I),NEK1,TOTNT,
     &                    NEK(ADDNEK),MASKOP(1,1,I),LEAD,SLICE,
     &                    ADD(ADDELM),UDIAGG,ODIAGG,START1,
     &                    MASK(START),LUMAPG,MASK)
            ENDIF

          ENDIF
	  ADDELM=ADDELM+LEAD*SLICE
  100    CONTINUE
	ENDIF
	START1=START1+LUMAPG
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF

400   CONTINUE
      NMSG=NMSG+2*NJUMP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM720----------------------------------------------------
      E    N    D
