C:::::      ,,,,,VEM722...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM722(NK,NE,NK2,NELTYP,NEK1,TOTNT,NEK,MASKOP,
     &                  ADD1,ADD2,ADD,UDIAG,ODIAG,START0,
     &                  START,LMASK,MASK)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM722  controls the computation of the addresses of the   ***
C**              element matrices in the unpacked matrix and        ***
C**              marks the occupied entries for a stripe of         ***
C**              diagonals for one group in the nonsymmetrical case.***
C**              the diagonals are on process PROC.                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NK,NE,NK2,ADD2,NEK1,ADD1,TOTNT,LMASK,
     &                  ODIAG,UDIAG,START0

      INTEGER           NEK(NEK1,TOTNT),NELTYP(NK2),
     &                  START(UDIAG+1:ODIAG),ADD(ADD1,ADD2),MASK(LMASK)

      LOGICAL           MASKOP(NK,NK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NE     I  I   I in  I number of elements
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I order of the proposal functions
C        I      I     I                              array: NELTYP(NK2)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I the element list         array: NEK(NEK1,TOTNT)
C--------I------I-----I------------------------------------------------
C MASKOP I  L   I in  I mask of the  couplings in the bilinear form
C        I      I     I array: MASKOP(NK,NK)
C--------I------I-----I------------------------------------------------
C ADD    I  I   I in  I  diagonal addresses*(-1) of element matrices
C        I      I out I  addresses in the unpacked matrix stripe
C        I      I     I  (only for diagonal addresses in UDIAG+1,ODIAG;
C        I      I     I  the address is set >START0)
C        I      I     I  array : ADD(ADD1,ADD2)
C--------I------I-----I------------------------------------------------
C UDIAG  I  I   I in  I  range of the diagonals in the current
C ODIAG  I      I     I  stripe (global)
C--------I------I-----I------------------------------------------------
C START  I  I   I in  I  start addresses of the occupied diagonals
C        I      I     I  array : START(UDIAG+1:ODIAG)
C--------I------I-----I------------------------------------------------
C MASK   I  I   I out I  MASK(i)<0  => nonzero entry at position
C        I      I     I                i in unpacked matrix in
C        I      I     I                current stripe
C        I      I     I array : MASK(LMASK)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           J1,J2,K,Z,R,CC0,CR0,I1,I2,CR,CC,BB,BCC,BCR,
     &                  ROW,COL,NTROW,NTCOL,NROW,DIAG,HERE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      BB=NK-NK2+1
      R=0
      CR0=0
      CC0=TOTNT-NELTYP(MIN(NK2,NK))
	
      DO 500 I1=1,2*NK-1

        IF ((I1.GT.NK).AND.(I1-NK.LT.NK2)) CR0=CR0+NELTYP(I1-NK)
        IF ((I1.LE.NK).AND.(NK-I1+1.LT.NK2)) CC0=CC0-NELTYP(NK-I1+1)

        CR=CR0
        CC=CC0

        DO 501 I2=1,NK-ABS(NK-I1)

          ROW=MAX(0,I1-NK)+I2
          COL=MAX(0,NK-I1)+I2

          BCR=MAX(ROW,NK2)-NK
          BCC=MAX(COL,NK2)-NK

          NTROW=NELTYP(MIN(ROW,NK2))
          NTCOL=NELTYP(MIN(COL,NK2))

          IF (MASKOP(ROW,COL).AND.(NTCOL*NTROW.GT.0)) THEN

            DO 110 J1=1,NTROW
             DO 110 J2=1,NTCOL

              K=R+NTCOL*(J1-1)+J2

              DO 120 Z=1,NE
                DIAG=-ADD(Z,K)
                IF ((UDIAG.LT.DIAG).AND.(DIAG.LE.ODIAG)) THEN
                  NROW=BB*NEK(Z,CR+J1)+BCR
                  HERE=START(DIAG)+NROW
		  MASK(HERE)=-1
		  ADD(Z,K)=START0+HERE
                ENDIF
 120          CONTINUE
110         CONTINUE

            R=R+NTROW*NTCOL

          ENDIF

          IF (ROW.LT.NK2) CR=CR+NTROW
          IF (COL.LT.NK2) CC=CC+NTCOL

 501    CONTINUE

500     CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM722----------------------------------------------------
      E    N    D
