C:::::      ,,,,,VEM730.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM730(LMASK,DIAG,NJUMP,JUMP,MYPROC,NPROC,LMATBK,
     &                  PTRMBK,ND,TYP,L,IAC,IAR,DIAIND,PRCBLK)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEM730   computes the index of the diagonals DIAIND, their    ***
C**            length L, their column IAC and row IAR and the       ***
C**            processor block PRCBLK from the given diagonal mask. ***
C**            The diagonals are unpacked !                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      INTEGER           LMASK,NJUMP,MYPROC,NPROC,ND
      INTEGER           DIAG(LMASK,NJUMP),L(ND),IAC(ND),DIAIND(ND),
     &                  IAR(ND),PRCBLK(NJUMP+1),TYP(ND),
     &                  JUMP(NJUMP),LMATBK(NPROC),PTRMBK(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DIAG   I  I   I in  I masks of the occupied diagonals
C        I      I     I DIAG(i,p)=1 => i-th diagonal in p-th matrix block
C        I      I     I on the proccess is occupied. p=1 is the main
C        I      I     I diagonal block.
C        I      I     I array: DIAG(LMASK,NJUMP)
C        I      I     I        SYM => LMASK=LM
C        I      I     I  .not. SYM => LMASK=2*LM-1
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I  number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I  JUMP(I)+MYPROC specify the process for the
C        I      I     I  send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I  process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I array : LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I array : PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C ND     I  I   I in  I number of diagonals
C--------I------I-----I------------------------------------------------
C TYP    I  I   I out I typ of the diagonals
C        I      I     I =1 => main diagonal
C        I      I     I =2 => unpacked diagonal
C        I      I     I =3 => packed diagonal
C        I      I     I =6 => starry sky
C        I      I     I array: TYP(ND)
C--------I------I-----I------------------------------------------------
C L      I  I   I out I length of the occupied diagonals
C        I      I     I array: L(ND)
C--------I------I-----I------------------------------------------------
C IAC    I  I   I out I first occupied column-1
C        I      I     I array: IAC(ND)
C--------I------I-----I------------------------------------------------
C IAR    I  I   I out I first occupied row-1
C        I      I     I array: IAR(ND)
C--------I------I-----I------------------------------------------------
C DIAIND I  I   I out I diagonal index, list of DIAG(DIAIND(I))=1 !
C        I      I     I array: DIAIND(ND)
C--------I------I-----I------------------------------------------------
C PRCBLK I  I   I out I PRCBLK(P) notify the first diagonal on
C        I      I     I processor P, PRCBLK(NJUMP+1)=ND
C        I      I     I array: PRCBLK(NJUMP+1)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           I,COUNT,P,PROC,LL9MAP,M,M1,M01,M0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      COUNT=0
      PROC=MYPROC
      M=LMATBK(MYPROC)
      M0=PTRMBK(MYPROC)

      DO 100 P=1,NJUMP

         M1=LMATBK(PROC)
         M01=PTRMBK(PROC)
         PRCBLK(P)=COUNT

         DO 10   I = 1,LMASK
           IF (DIAG(I,P).GT.0) THEN
             COUNT=COUNT+1
             L(COUNT)=MIN(MIN(I,M),MIN(M1,M+M1-I))
             IAC(COUNT)=M01+MAX(M1-I,0)
             IAR(COUNT)=M0+MAX(I-M1,0)
	     IF (IAC(COUNT).EQ.IAR(COUNT)) THEN
	       TYP(COUNT)=1
             ELSE
	       TYP(COUNT)=2
             ENDIF
             DIAIND(COUNT)=I+LMASK*(P-1)+LMASK*NJUMP*(MYPROC-1)
           ENDIF
   10  CONTINUE

       PROC=LL9MAP(PROC+JUMP(P),NPROC)

  100 CONTINUE
      PRCBLK(NJUMP+1)=COUNT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM730----------------------------------------------------
      E    N    D
