C:::::      ,,,,,VEM731...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM731(LSKY,ND,L,TYP,ADDMAT,NINDEX,PRCBLK,
     &                  NUPD,NPD,NSS,NVT,NJUMP,JUMP)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM731  counts the shape types in the global matrix          ***
C**            where short diagonals are joint to starry sky        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           LSKY,ND,NINDEX,NUPD,NPD,NSS,NVT,NJUMP

      INTEGER           L(ND),TYP(ND),ADDMAT(ND),PRCBLK(NJUMP+1),
     &                  JUMP(NJUMP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C LSKY   I  I   I in  I diagonals with a packed length lower than
C        I      I     I LSKY are joint to skarry sky opertion
C--------I------I-----I------------------------------------------------
C L      I  I   I in  I length of the occupied diagonals
C        I      I     I array: L(ND)
C--------I------I-----I------------------------------------------------
C TYP    I  I   I in  I typ of the diagonals
C        I      I     I =1 => main diagonal
C        I      I     I =2 => unpacked diagonal
C        I      I     I =3 => packed diagonal (may be changed to 6)
C        I      I     I =6 => starry sky
C        I      I     I array: TYP(ND)
C--------I------I-----I------------------------------------------------
C ADDMAT I  I   I in  I +1 is pointer to diagonal entries
C        I      I     I array: ADDMAT(ND)
C--------I------I-----I------------------------------------------------
C NINDEX I  I   I i/o I needed length for the index
C        I      I     I the additional storage for starry sky is added.
C--------I------I-----I------------------------------------------------
C PRCBLK I  I   I out I PRCBLK(P) notify the first diagonal on
C        I      I     I processor P, PRCBLK(NJUMP+1)=ND
C        I      I     I array: PRCBLK(NJUMP+1)
C--------I------I-----I------------------------------------------------
C NUPD   I  I   I out I number of unpacked diagonal
C--------I------I-----I------------------------------------------------
C NPD    I  I   I out I number of packed diagonal
C--------I------I-----I------------------------------------------------
C NSS    I  I   I out I number of starry sky
C--------I------I-----I------------------------------------------------
C NVT    I  I   I out I number of shapes
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           LASTM,P,I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      NUPD=0
      NPD=0
      NSS=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      DO 100 P=1,NJUMP

        LASTM=-1
        DO 110 I=PRCBLK(P)+1,PRCBLK(P+1)
C**                                                                 ***
C****** the short diagonals are gather to starry sky. to avoid a    ***
C**     rearraging of the storage only consequtive short diagonals  ***
C**     are gathered :                                              ***
C**                                                                 ***
	  IF ((TYP(I).EQ.3).AND.(L(I).LE.LSKY)) THEN
	    TYP(I)=6
	    IF (LASTM.NE.ADDMAT(I)) THEN
	      LASTM=ADDMAT(I)
	      NSS=NSS+1
            ENDIF
	    LASTM=LASTM+L(I)
	    NINDEX=NINDEX+L(I)
C**                                                                 ***
          ELSE
	    IF ((TYP(I).EQ.1).OR.(TYP(I).EQ.2)) NUPD=NUPD+1
	    IF (TYP(I).EQ.3) NPD=NPD+1
          ENDIF

110     CONTINUE

100   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      NVT=NUPD+NPD+NSS
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM731----------------------------------------------------
      E    N    D
