C:::::      ,,,,,VEM732...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM732(LINDEX,NMATL,INDEX,OFFIND,NINDEX,IL1,IL2,
     &                  INFOL,NVTYP,
     &                  PTRVTS,ND,TYP,L,IAR,IAC,ADDMAT,ADDIND,PRCBLK,
     &                  NJUMP,JUMP,NPROC,MYPROC)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM732  joints starry sky terms marked by vem731 and creates ***
C**            the linsol information table for the matrix          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           LINDEX,OFFIND,NINDEX,IL1,IL2,ND,NVTYP,
     &                  NJUMP,NPROC,MYPROC,NMATL

      INTEGER           INDEX(LINDEX),INFOL(IL1,IL2),TYP(ND),
     &                  L(ND),IAR(ND),IAC(ND),ADDMAT(ND),ADDIND(ND),
     &                  PRCBLK(NJUMP+1),JUMP(NJUMP),PTRVTS(NVTYP,NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C INDEX  I  I   I i/o I the array of the index vectors of the matrix
C        I      I     I on input only the entries INDEX(1),...,
C        I      I     I INDEX(NINDEX) are used. at the output
C        I      I     I index vectors for the starry sky are apended
C        I      I     I array: INDEX(LINDEX)
C--------I------I-----I------------------------------------------------
C OFFIND I  I   I in  I offset for the index addresses
C--------I------I-----I------------------------------------------------
C NINDEX I  I   I i/o I used length of index
C--------I------I-----I------------------------------------------------
C NMATL  I  I   I out I matrix length of this process
C--------I------I-----I------------------------------------------------
C INFOL  I  I   I out I the linsol info table for the matrix
C        I      I     I array: INFOL(IL1,IL2)
C--------I------I-----I------------------------------------------------
C PTRVTS I  I   I in  I PTRVTS(i,p)+1,...,PTRVTS(i+1,p) are the infos
C        I      I     I for shape of typ i on processor p in INFOL
C        I      I     I array: PTRVTS(NVTYP,NPROC)
C--------I------I-----I------------------------------------------------
C TYP    I  I   I in  I typ of the diagonals
C        I      I     I =1 => main diagonal
C        I      I     I =2 => unpacked diagonal
C        I      I     I =3 => packed diagonal
C        I      I     I =6 => starry sky
C        I      I     I array: TYP(ND)
C--------I------I-----I------------------------------------------------
C L      I  I   I in  I length of the occupied diagonals
C        I      I     I array: L(ND)
C--------I------I-----I------------------------------------------------
C IAC    I  I   I in  I first occupied column-1
C        I      I     I array: IAC(ND)
C--------I------I-----I------------------------------------------------
C IAR    I  I   I in  I first occupied row-1
C        I      I     I array: IAR(ND)
C--------I------I-----I------------------------------------------------
C ADDIND I  I   I in  I +1 is pointer to diagonal index
C        I      I     I array: ADDIND(ND)
C--------I------I-----I------------------------------------------------
C ADDMAT I  I   I in  I +1 is pointer to diagonal entries
C        I      I     I array: ADDMAT(ND)
C--------I------I-----I------------------------------------------------
C PRCBLK I  I   I in  I PRCBLK(P) notify the first diagonal on
C        I      I     I processor P, PRCBLK(NJUMP+1)=ND
C        I      I     I array: PRCBLK(NJUMP+1)
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I  number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I  JUMP(I)+MYPROC specify the process for the
C        I      I     I  send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I  process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           PROC,PTR0,P,I,LL9MAP,LASTM,Z,INDC,INDR,IND
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      PTR0=0
      DO 10 I=1,NPROC
       DO 10 Z=1,NVTYP
10       PTRVTS(Z,I)=PTR0
      NMATL=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of processor loop :                                     ***
C**   -----------------------                                       ***
C**                                                                 ***
      PROC=MYPROC
      INDR=NINDEX

      DO 100 P=1,NJUMP
C**                                                                 ***
C****** search for the main diagonals:                              ***
C**                                                                 ***
        PTRVTS(1,PROC)=PTR0
        DO 110 I=PRCBLK(P)+1,PRCBLK(P+1)
           IF (TYP(I).EQ.1) THEN
	     PTR0=PTR0+1
	     INFOL(PTR0,1)=10
	     INFOL(PTR0,2)=ADDMAT(I)
	     INFOL(PTR0,3)=L(I)
	     INFOL(PTR0,4)=IAC(I)
	     INFOL(PTR0,5)=IAR(I)
	     INFOL(PTR0,6)=0
	     INFOL(PTR0,7)=0
             NMATL=NMATL+L(I)
           ENDIF
110     CONTINUE
C**                                                                 ***
C****** search for the diagonals:                                   ***
C**                                                                 ***
        PTRVTS(2,PROC)=PTR0
        DO 120 I=PRCBLK(P)+1,PRCBLK(P+1)
           IF (TYP(I).EQ.2) THEN
	     PTR0=PTR0+1
	     INFOL(PTR0,1)=20
	     INFOL(PTR0,2)=ADDMAT(I)
	     INFOL(PTR0,3)=L(I)
	     INFOL(PTR0,4)=IAC(I)
	     INFOL(PTR0,5)=IAR(I)
	     INFOL(PTR0,6)=0
	     INFOL(PTR0,7)=0
             NMATL=NMATL+L(I)
           ENDIF
120     CONTINUE
C**                                                                 ***
C****** search for the packed diagonals:                            ***
C**                                                                 ***
        PTRVTS(3,PROC)=PTR0
        DO 130 I=PRCBLK(P)+1,PRCBLK(P+1)
           IF (TYP(I).EQ.3) THEN
	     PTR0=PTR0+1
	     INFOL(PTR0,1)=30
	     INFOL(PTR0,2)=ADDMAT(I)
	     INFOL(PTR0,3)=L(I)
	     INFOL(PTR0,4)=IAC(I)
	     INFOL(PTR0,5)=IAR(I)
	     INFOL(PTR0,6)=ADDIND(I)+OFFIND
	     INFOL(PTR0,7)=0
             NMATL=NMATL+L(I)
           ENDIF
130     CONTINUE
C**                                                                 ***
C****** search for the starry sky :                                 ***
C**                                                                 ***
        PTRVTS(4,PROC)=PTR0
        PTRVTS(5,PROC)=PTR0
        PTRVTS(6,PROC)=PTR0

        LASTM=-1
        I=PRCBLK(P)+1
160     IF (I.LE.PRCBLK(P+1)) THEN
          IF (TYP(I).EQ.6) THEN
	    IF (LASTM.NE.ADDMAT(I)) THEN
	      PTR0=PTR0+1
	      INDC=ADDIND(I)
	      LASTM=ADDMAT(I)
	      INFOL(PTR0,1)=60
	      INFOL(PTR0,2)=ADDMAT(I)
	      INFOL(PTR0,3)=0
	      INFOL(PTR0,4)=0
	      INFOL(PTR0,5)=0
	      INFOL(PTR0,6)=INDC+OFFIND
	      INFOL(PTR0,7)=INDR+OFFIND
            ENDIF
	    include "norec.h"
	    DO 161 Z=1,L(I)
	      IND=INDEX(ADDIND(I)+Z)
	      INDEX(INDC+Z)=IND+IAC(I)
	      INDEX(INDR+Z)=IND+IAR(I)
161         CONTINUE
	    INFOL(PTR0,3)=INFOL(PTR0,3)+L(I)
	    LASTM=LASTM+L(I)
	    INDC=INDC+L(I)
	    INDR=INDR+L(I)
            NMATL=NMATL+L(I)
          ENDIF
	  I=I+1
          GOTO 160
        ENDIF
C**                                                                 ***
        DO 170 I=7,NVTYP
170       PTRVTS(I,PROC)=PTR0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
       PROC=LL9MAP(PROC+JUMP(P),NPROC)
100   CONTINUE
      NINDEX=INDC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM732----------------------------------------------------
      E    N    D
