C:::::      ,,,,,VEM750...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM750(NMAT,NINDEX,LINDEX,INDEX,
     &                  ND,LLEN,TYP,IAC,IAR,ADDIND,ADDMAT,
     &                  UDIAG,ODIAG,FPACK,LSHORT,OCCDEG,LUMAPG,
     &                  LADD,ADD,NJUMP,JUMP,NPROC,MYPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM750  packs the diagonals in the current stripe          ***
C**              and assigns the new addresses to the element       ***
C**              matrices. at the end INDEX(1:NINDEX) is the index  ***
C**              vector of the packed diagonals.                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NMAT,NINDEX,LINDEX,LSHORT,
     &                  UDIAG,ODIAG,FPACK,LUMAPG,ND,
     &                  LADD,NJUMP,NPROC,MYPROC,NMSG

      INTEGER           INDEX(LINDEX),LLEN(ND),TYP(ND),
     &                  ADDIND(ND),ADDMAT(ND),IAC(ND),IAR(ND),
     &                  OCCDEG(4),ADD(LADD),JUMP(NJUMP),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NMAT   I  I   I i/o I size of the till now packed matrix
C        I      I     I the same for all processes !!!!
C--------I------I-----I------------------------------------------------
C NINDEX I  I   I i/o I length of the index array containing the
C        I      I     I index of the packed matrix
C--------I------I-----I------------------------------------------------
C INDEX  I  I   I i/o I INDEX file for matrix      array: INDEX(LINDEX)
C        I      I in  I INDEX(1:NINDEX)=index vector for packed matrix
C        I      I     I                 of foregoing stripes
C        I      I in  I INDEX(NINDEX+1:NINDEX+LUMAPG)<0 nonzero entry
C        I      I     I                 in unpacked matrix in stripe
C        I      I out I INDEX(1:NINDEX)=index vector for packed matrix
C        I      I     I                 of the stripes including the
C        I      I     I                 current one.
C        I      I     I the range NINDEX+LUMAPG+1:LINDEX is used for
C        I      I     I communication. if SBT=2 LINDEX-NINDEX>=2*LUMAPG.
C--------I------I-----I------------------------------------------------
C ND     I  I   I in  I number of diagonals
C--------I------I-----I------------------------------------------------
C TYP    I  I   I i/o I typ of the diagonals
C        I      I     I =1 => main diagonal
C        I      I     I =2 => unpacked diagonal
C        I      I     I =3 => packed diagonal
C        I      I     I =6 => starry sky
C        I      I     I array: TYP(ND)
C--------I------I-----I------------------------------------------------
C LLEN   I  I   I in  I length of the unpacked diagonals
C        I      I out I length of the packed diagonal (if TYP(i)=3)
C        I      I     I array: LLEN(ND)
C--------I------I-----I------------------------------------------------
C IAC    I  I   I out I first occupied column-1
C        I      I     I array: IAC(ND)
C--------I------I-----I------------------------------------------------
C IAR    I  I   I out I first occupied row-1
C        I      I     I array: IAR(ND)
C--------I------I-----I------------------------------------------------
C ADDIND I  I   I out I +1 is pointer to dioagonal index
C        I      I     I array: ADDIND(ND)
C--------I------I-----I------------------------------------------------
C ADDMAT I  I   I out I +1 is pointer to diagonal entries
C        I      I     I array: ADDMAT(ND)
C--------I------I-----I------------------------------------------------
C UDIAG  I  I   I in  I  first-1 and last occupied diagonal in the current
C ODIAG  I      I     I  stripe
C--------I------I-----I------------------------------------------------
C FPACK  I  I   I in  I if ratio of packed and unpacked length is lower
C LSHORT I      I     I than FPACK % or the packed length is lower than
C        I      I     I LSHORT the diagonal is packed.
C--------I------I-----I------------------------------------------------
C OCCDEG I  I   I i/o I number of diagonals with certain degree of
C        I      I     I occupation                     array: OCCDEG(4)
C--------I------I-----I------------------------------------------------
C LUMAPG I  I   I in  I maximal length of the unpacked matrix stripe
C--------I------I-----I------------------------------------------------
C ADD    I  I   I in  I addresses of element matrices in the unpacked
C        I      I     I matrix
C        I      I out I addresses of element matrices in the packed
C        I      I     I matrix: only addresses in the range
C        I      I     I NJUMP*NMAT+1 to NJUMP*(NMAT+LUMAPG) are
C        I      I     I (= matrix stripe) are changed
C        I      I     I array : ADD(LADD)
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           L,NMAT2,Z,PLEN,I,LPACK,LENGTH,FIRST,LAST,LUMAT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      L=NINDEX
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** loop over the diagonals :                                     ***
C**   -----------------------                                       ***
C**                                                                 ***
      DO 20 I=UDIAG+1,ODIAG
C**                                                                 ***
C****** is this the main diagonal ?                                 ***
C**     --------------------------                                  ***
C**                                                                 ***
        IF (TYP(I).EQ.1) THEN
           DO 30 Z=1,LLEN(I)
             INDEX(L+Z)=-1
 30        CONTINUE
        ENDIF
C**                                                                 ***
C****** count the number of nonzeros in the diagonal:               ***
C**     --------------------------------------------                ***
C**                                                                 ***
C**     PLEN is the number of nonzero elements                      ***
C**                                                                 ***
        PLEN=0
        ADDIND(I)=LLEN(I)
        ADDMAT(I)=0

        DO 40 Z=1,LLEN(I)
          IF (INDEX(L+Z).EQ.-1) THEN
            ADDMAT(I)=Z
            ADDIND(I)=MIN(Z,ADDIND(I))
            PLEN=PLEN+1
          ENDIF
 40     CONTINUE
C**                                                                 ***
C****** count the degree of occupation:                             ***
C**     ------------------------------                              ***
C**                                                                 ***
        LPACK=(PLEN*100)/(ADDMAT(I)-ADDIND(I)+1)
        Z=(LPACK-1)/25+1
        OCCDEG(Z)=OCCDEG(Z)+1
C**                                                                 ***
C****** pack the diagonal ?                                         ***
C**     -----------------                                           ***
C**                                                                 ***
        IF ((LPACK.LT.FPACK).OR.(PLEN.LE.LSHORT)) THEN
          TYP(I)=3
        ELSE
C**                                                                 ***
C******** unpacked diagonal :                                       ***
C**       ------------------                                        ***
C**                                                                 ***
C**       index is filled !                                         ***
C**                                                                 ***
          DO 60 Z=ADDIND(I),ADDMAT(I)
            INDEX(L+Z)=-1
  60      CONTINUE
        ENDIF
C**                                                                 ***
C****** end of diagonal loop :                                      ***
C**     --------------------                                        ***
C**                                                                 ***
        L=L+LLEN(I)
20    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** assign the new addresses to the element matrices :            ***
C**   ------------------------------------------------              ***
C**                                                                 ***
C**   NMAT2 gives the length of the new packed matrix !             ***
C**                                                                 ***
      LUMAT =L-NINDEX
      CALL VEM776(NMAT,NMAT2,LUMAPG,LUMAT,LINDEX-NINDEX,INDEX(NINDEX+1),
     &            LADD,ADD,NJUMP,JUMP,NPROC,MYPROC,TIDS,NMSG)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create matrix index:                                          ***
C**   -------------------                                           ***
C**                                                                 ***
      L=NINDEX
      DO 70 I=UDIAG+1,ODIAG
        LENGTH=LLEN(I)
        FIRST=ADDIND(I)
        LAST=ADDMAT(I)
        IF (TYP(I).EQ.3) THEN
          PLEN=0
          include "norec.h"
          DO 80 Z=FIRST,LAST
             IF (INDEX(L+Z).LT.0) THEN
               PLEN=PLEN+1
               INDEX(NINDEX+PLEN)=Z-FIRST+1
             ENDIF
  80      CONTINUE
          LLEN(I)=PLEN
	  ADDIND(I)=NINDEX
          NINDEX=NINDEX+LLEN(I)
        ELSE
          LLEN(I)=LAST-FIRST+1
        ENDIF
	ADDMAT(I)=NMAT
	NMAT=NMAT+LLEN(I)
        IAC(I)=IAC(I)+FIRST-1
        IAR(I)=IAR(I)+FIRST-1
        L=L+LENGTH
 70   CONTINUE
      NMAT=NMAT2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM750----------------------------------------------------
      E    N    D
