C:::::      ,,,,,VEM751...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM751(SYM,LFREE,LBUF,UDIAG,UDIAGG,ODIAG,ODIAGG,
     &                  LUMAT,LUMAPG,ND,L,IAC,IAR,DIAIND,DIAG1,NJUMP,
     &                  START,ENDE,SBT,NPROC,MYPROC,TIDS,NMSG,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM751   selects the diagonals for the current stripe and    ***
C**             computes the start addresses of the occupied        ***
C**             diagonals in the matrix mask.                       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           LFREE,LBUF,UDIAG,ODIAG,ND,DIAG1,NJUMP,
     &                  UDIAGG,ODIAGG,LUMAPG,NMSG,SBT,LUMAT,
     &                  ENDE,NPROC,MYPROC,ERR

      INTEGER           L(ND),DIAIND(ND),START(DIAG1*NJUMP),
     &                  IAR(ND),IAC(ND),TIDS(NPROC)
      LOGICAL           SYM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C SYM    I  L   I in  I symmetry flag
C--------I------I-----I------------------------------------------------
C LFREE  I  I   I in  I available storage for matrix stripe
C--------I------I-----I------------------------------------------------
C LBUF   I  I   I out I buffer length for distribution of START vector
C        I      I     I =maximal value of ODIAGG-UDIAGG+3 over all
C        I      I     I processes!
C--------I------I-----I------------------------------------------------
C ODIAG  I  I   I i/o I last occupied diagonal in last stripe
C UDIAG  I      I out I last occupied diagonal in current stripe
C--------I------I-----I------------------------------------------------
C ODIAGG I  I   I i/o I last diagonal in last stripe
C UDIAGG I      I out I last diagonal in current stripe
C--------I------I-----I------------------------------------------------
C LUMAT  I  I   I out I length of unpacked matrix in stripe on the
C        I      I     I process
C--------I------I-----I------------------------------------------------
C LUMAPG I  I   I out I maximal length of unpacked matrix in stripe
C        I      I     I the same for all processes!
C--------I------I-----I------------------------------------------------
C ND     I  I   I in  I number of diagonals
C--------I------I-----I------------------------------------------------
C L      I  I   I in  I length of the occupied diagonals
C        I      I     I array: L(ND)
C--------I------I-----I------------------------------------------------
C IAC    I  I   I in  I first occupied column-1
C        I      I     I array: IAC(ND)
C--------I------I-----I------------------------------------------------
C IAR    I  I   I in  I first occupied row-1
C        I      I     I array: IAR(ND)
C--------I------I-----I------------------------------------------------
C DIAIND I  I   I in  I diagonal index, list of DIAG(DIAIND(I))=1 !
C        I      I     I array: DIAIND(ND)
C--------I------I-----I------------------------------------------------
C START  I  I   I out I start addresses of unpacked diagonals in stripe
C        I      I     I array : DIAG(NJUMP*DIAG1)
C--------I------I-----I------------------------------------------------
C ENDE   I  I   I i/o I =0 there is something to do
C        I      I     I =1 all diagonals are packed on MYPROC
C        I      I     I =2 all diagonals are packed on all processes
C--------I------I-----I------------------------------------------------
C SBT    I  I   I in  I =1 no switching buffer technique is used
C        I      I     I =2 switching buffer technique is used
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error code (is global !)
C        I      I     I =7510=> there is an empty stripe
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           IH1(3),IH2(3),IH3(3),LDIAG,LDR,Z,LFREEG,DRANGE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ERR=0
      UDIAGG=ODIAGG
      UDIAG=ODIAG
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** find the available storage for stripe :                       ***
C**   -------------------------------------                         ***
C**                                                                 ***
      IH1(1)=-LFREE
      IH1(2)=-ENDE
      CALL LL4INM(1,2,1,IH1,IH2,IH3,MYPROC,NPROC,TIDS,NMSG)
      LFREEG=-IH2(1)
      ENDE=-IH2(2)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** all diagonals are packed on all processors ?                  ***
C**   ------------------------------------------                    ***
C**                                                                 ***
      IF (ENDE.EQ.1) THEN
       LUMAPG=0
       LUMAT=0
       LBUF=0
       ENDE=2
       GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** select diagonals for the current stripe till LFREEG is filled ***
C**   to contain the unpacked diagonals :                           ***
C**   ---------------------------------                             ***
C**                                                                 ***
      LUMAT=0
      DRANGE=0
1234  CONTINUE
      IF (ODIAG.LT.ND) THEN
        LDIAG=L(ODIAG+1)
        LDR=DIAIND(ODIAG+1)-UDIAGG
        IF (SBT*((LUMAT+LDIAG)+LDR).LE.LFREEG) THEN
          ODIAG=ODIAG+1
          ODIAGG=DIAIND(ODIAG)
	  DRANGE=LDR
          START(DRANGE)=LUMAT
          LUMAT=LUMAT+LDIAG
          GOTO 1234
        ENDIF
      ELSE
        ENDE=1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** is the stripe empty in spite not all diagonals are packed ?   ***
C**   ---------------------------------------------------------     ***
C**                                                                 ***
      IF ((DRANGE.EQ.0).AND.(ENDE.EQ.0)) THEN
        ERR=7510
      ELSE
	ERR=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the maximal DRANGE and the maximal length of the          ***
C**   unpacked diagonals is computed over all proceses :            ***
C**   ---------------------------------------------------------     ***
C**                                                                 ***
      IH1(1)=(DRANGE+LUMAT)*SBT
      IH1(2)=LUMAT
      IH1(3)=ERR
      CALL LL4INM(1,3,1,IH1,IH2,IH3,MYPROC,NPROC,TIDS,NMSG)
      LBUF=IH2(1)
      LUMAPG=IH2(2)
      ERR=IH2(3)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** correct the start addresses :                                 ***
C**   ----------------------------                                  ***
C**                                                                 ***
C**   this effects, that entries n row ROW  and diagonal D          ***
C**   can be easily addressed by START(D)+ROW.                      ***
C**                                                                 ***
      IF (SYM) THEN
	DO 4000 Z=UDIAG+1,ODIAG
	  START(DIAIND(Z)-UDIAGG)=
     &        START(DIAIND(Z)-UDIAGG)-MIN(IAR(Z),IAC(Z))
4000    CONTINUE
      ELSE
	DO 4010 Z=UDIAG+1,ODIAG
	  START(DIAIND(Z)-UDIAGG)=
     &                  START(DIAIND(Z)-UDIAGG)-IAR(Z)
4010    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
9999  CONTINUE
      R E T U R N
C-----End of VEM751----------------------------------------------------
      E    N    D
