C:::::      ,,,,,VEM776...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM776(NMAT,NMAT2,LUMAPG,LUMAT,LMASK,MASK,
     &                  LADD,ADD,NJUMP,JUMP,NPROC,MYPROC,TIDS,NMSG)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM776   assigns the new addresses in the packed matrix    ***
C**               to the element matrices for a arbitry part of the ***
C**               of the unpacked matrix                            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           LADD,LMASK,NMAT,NMAT2,NMSG,LUMAT,
     &                  NPROC,NJUMP,MYPROC,LUMAPG

      INTEGER           ADD(LADD),MASK(LMASK),JUMP(NJUMP),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NMAT   I  I   I in  I last used entry in the packed matrix
C        I      I     I before adding of the new stripe
C--------I------I-----I------------------------------------------------
C NMAT2  I  I   I out I last used entry in the packed matrix
C        I      I     I after adding of with new stripe
C--------I------I-----I------------------------------------------------
C LUMAPG I  I   I in  I global length of the unpacked matrix stripe
C--------I------I-----I------------------------------------------------
C LUMAT  I  I   I in  I length of the unpacked matrix stripe
C--------I------I-----I------------------------------------------------
C MASK   I  I   I i/o I mask of the occupied elements in the stripe
C        I      I     I <0 marks the occupation
C        I      I     I enties >=0 are desturbed !!
C        I      I     I if SBT=2 LMASK>2*LUMAPG, since LUMAPG+1:LMASK
C        I      I     I is used for communication buffers.
C        I      I     I array : MASK(LMASK)
C--------I------I-----I------------------------------------------------
C ADD    I  I   I in  I addresses of element matrices in the unpacked
C        I      I     I matrix
C        I      I out I addresses of element matrices in the packed
C        I      I     I matrix: only addresses in the range
C        I      I     I NJUMP*NMAT+1 to NJUMP*(NMAT+LUMAPG) are
C        I      I     I (= matrix stripe) are changed
C        I      I     I array : ADD(LADD)
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           P,PROC,TOTID,FRTID,MIDS2,MIDR2,INFO,MATADD,
     &                  LL9MAP,MIDS1,MIDR1,START0,START1,MSG(2,2),
     &                  IH1(2),IH2(2),IH3(2),I,Z,HH,MSGSND,MSGRCV,
     &                  SNDBUF,RCVBUF,HERE
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      PROC=MYPROC
      START0=NMAT*NJUMP
      SNDBUF=1
      RCVBUF=2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of processor loop :                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      START1=START0
      DO 400 P=1,NJUMP
	PROC=LL9MAP(PROC-JUMP(P),NPROC)
	FRTID=TIDS(LL9MAP(MYPROC-JUMP(P),NPROC))
	TOTID=TIDS(LL9MAP(MYPROC+JUMP(P),NPROC))
C**                                                                 ***
C*****  pack entries in the mask:                                   ***
C**                                                                 ***
	MSG(1,SNDBUF)=0
	MSG(2,SNDBUF)=LUMAT
	MSGSND=0
        include"norec.h"
        DO 411 I=1,LUMAT
	  IF (MASK(I).LT.0) THEN
	    MSG(1,SNDBUF)=MSG(1,SNDBUF)+1
	    MASK(MSGSND+MSG(1,SNDBUF))=I
          ENDIF
411     CONTINUE
C**                                                                 ***
C****** compute the maximal length of the additional packed matrix  ***
C**     (MATADD) and the maximal new length of the packed           ***
C**     matrix (NMAT2)                                              ***
C**                                                                 ***
        IF (P.EQ.1) THEN
	  IH1(1)=NMAT+MSG(1,SNDBUF)
	  IH1(2)=MSG(1,SNDBUF)
          CALL LL4INM(1,2,1,IH1,IH2,IH3,MYPROC,NPROC,TIDS,NMSG)
	  NMAT2=IH2(1)
	  MATADD=IH2(2)
        ENDIF
C**                                                                 ***
C****** send index length and index :                               ***
C**                                                                 ***
	IF (NJUMP.GT.1) THEN
	  CALL MPRCVA(FRTID,NMSG+P,IINT*2,MSG(1,RCVBUF),MIDR1,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*2,MSG(1,SNDBUF),MIDS1,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*2,MSG(1,RCVBUF),MIDR1,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IINT*2,MSG(1,SNDBUF),MIDS1,INFO)
          MSGRCV=LMASK-MSG(1,RCVBUF)-1
	  LUMAT=MSG(2,RCVBUF)
	  CALL MPRCVA(FRTID,NMSG+NJUMP+P,IINT*MSG(1,RCVBUF),
     &                               MASK(MSGRCV+1),MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+NJUMP+P,IINT*MSG(1,SNDBUF),
     &                               MASK(MSGSND+1),MIDS2,INFO)
        ELSE
          MSGRCV=MSGSND
	  MSG(1,RCVBUF)=MSG(1,SNDBUF)
	  MSG(2,RCVBUF)=MSG(2,SNDBUF)
        ENDIF
	DO 412 I=MSGSND+MSG(1,SNDBUF)+1,MIN(LUMAPG,MSGRCV)
	    MASK(I)=0
412     CONTINUE
	IF (NJUMP.GT.1) THEN
	  CALL MPRCVW(FRTID,NMSG+NJUMP+P,IINT*MSG(1,RCVBUF),
     &                         MASK(MSGRCV+1),MIDR2,INFO)
	  CALL MPSNDW(TOTID,NMSG+NJUMP+P,IINT*MSG(1,SNDBUF),
     &                         MASK(MSGSND+1),MIDS2,INFO)
        ENDIF
C**                                                                 ***
C****** unpack the mask index and assign addresses unpacked matrix  ***
C**     in the packed matrix for MYPROC. First they address the     ***
C**     space START0+MATADD*(P-1)+1 to START0+MATADD*P.             ***
C**                                                                 ***
	IF (MSGRCV.GT.SNDBUF) THEN
   	  include"norec.h"
	  DO 413 I=1,MSG(1,RCVBUF)
	    HERE=MASK(I+MSGRCV)
	    MASK(HERE)=-(START0+MATADD*(P-1)+I)
413       CONTINUE
	ELSE
	  include"norec.h"
	  DO 414 I=MSG(1,RCVBUF),1,-1
	    HERE=MASK(I+MSGRCV)
	    MASK(HERE)=-(START0+MATADD*(P-1)+I)
414       CONTINUE
        ENDIF
C**                                                                 ***
C****** now the addresses are assigned to the element matrices      ***
C**     only entries in the range START0+LUMAPG*(P-1)+1 to          ***
C**     to START0+LUMAPG*P are considered:                          ***
C**                                                                 ***
        DO 10 Z=1,LADD
	  HH=ADD(Z)-START1
          IF ((0.LT.HH).AND.(HH.LE.LUMAPG)) THEN
            ADD(Z)=-MASK(HH)
          ENDIF
10      CONTINUE
C**                                                                 ***
	START1=START1+LUMAPG
C**                                                                 ***
C**** End of processor loop :                                       ***
C**                                                                 ***
400   CONTINUE
      NMSG=NMSG+2*NJUMP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the new addresses are corrected:                          ***
C**   -----------------------------------                           ***
C**                                                                 ***
C**  the new addresses in the range START0+1 to START0+MATADD*NJUMP ***
C**  and the old addresses in the range 1 to START0=NJUMP*NMAT are  ***
C**  are moved to the range 1 to NJUMP*NMAT2.                       ***
C**                                                                 ***
      DO 20 Z=1,LADD
	 HH=ADD(Z)
	 IF (HH.GT.START0) THEN
	   P=(HH-START0-1)/MATADD
	   ADD(Z)=HH-START0+P*(NMAT2-MATADD)+NMAT
	 ELSEIF (HH.GT.0) THEN
	   P=(HH-1)/NMAT
	   ADD(Z)=HH+P*(NMAT2-NMAT)
	 ENDIF
20    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM776----------------------------------------------------
      E    N    D
