C:::::      ,,,,,VEM780...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM780(FPACK,LSKY,IL2,MYMTBK,PCLASS)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM780   set the limits for change from unpacked to        ***
C**               packed diagonals and for gathering diagonals      ***
C**               into starry sky operation.                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           PCLASS,FPACK,IL2,MYMTBK,LSKY
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C FPACK  I  I   I out I diagonals with a packed length lower than
C        I      I     I FPACK% of the unpacked length or a length lower
C        I      I     I LSKY are packed
C--------I------I-----I------------------------------------------------
C LSKY   I  I   I out I diagonals with a packed length lower than
C        I      I     I LSKY are joint to skarry sky opertion
C--------I------I-----I------------------------------------------------
C IL2    I  I   I in  I number of informations per term in the
C        I      I     I subdivision of the matrix
C--------I------I-----I------------------------------------------------
C MYMTBK I  I   I in  I number of unknonws on the process
C--------I------I-----I------------------------------------------------
C PCLASS I  I   I in  I pack class
C        I      I     I =0 minimal CPU -time in MVM
C        I      I     I =1 middle
C        I      I     I =2 minimal storage
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           STOPCK,CPUPCK,STOSKY,CPUSKY,DIFF
      include "bytes.h"
      include "archi.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      STOPCK=FLOAT(IREAL)*100./FLOAT(IREAL+IINT)
      CPUPCK=(RPDIA*100)/RDIA
      STOSKY=IL2
      DIFF=RPDIA-RSKY+0.5
      IF (DIFF.GT.0) THEN
        CPUSKY=NHPDIA*RSKY/FLOAT(MAX(DIFF,1))
      ELSE
        CPUSKY=MYMTBK
      ENDIF

C**                                                                 ***
      IF (PCLASS.LE.0) FPACK=CPUPCK
      IF (PCLASS.EQ.1) FPACK=(CPUPCK+STOPCK)/2
      IF (PCLASS.GE.2) FPACK=STOPCK

      IF (PCLASS.LE.0) LSKY=CPUSKY
      IF (PCLASS.EQ.1) LSKY=(CPUSKY+STOSKY)/2
      IF (PCLASS.GE.2) LSKY=STOSKY
C**                                                                 ***
C**** if the processor is a vector processor skarry sky can not be  ***
C**   used :                                                        ***
C**                                                                 ***
      IF ((ARCHI.EQ.9).OR.(ARCHI.EQ.19)) LSKY=0
      LSKY=MIN(LSKY,MYMTBK-1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM780----------------------------------------------------
      E    N    D
