C:::::      ,,,,,VEM900...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM900(AZERO,QUOLIM,EPS,N,A1,A2,NFAIL,LIST)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM900    tests two vectors A1 and A2 to be 'equal'.         ***
C**              If A1(Z) or A2(Z) =0 the otherone have to          ***
C**              be lower then AZERO. In the other cases            ***
C**              the ratio of A1(Z) and A2(Z) has be                ***
C**              between 1.-QUOLIM and 1.+QUOLIM or they must       ***
C**              have a small difference.                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N,NFAIL
      DOUBLE PRECISION  AZERO,QUOLIM,EPS,A1(N),A2(N)
      INTEGER           LIST(N)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C AZERO  I  R   I in  I if A1=0 or A2=0 then A1 and A2 has to be
C        I      I     I lower than AZERO
C--------I------I-----I------------------------------------------------
C QUOLIM I  R   I in  I A1/A2 has to be between 1.+QUOLIM and 1.-QUOLIM
C--------I------I-----I------------------------------------------------
C EPS    I  R   I in  I small machine constant
C--------I------I-----I------------------------------------------------
C A1,A2  I  R   I in  I two vectors of length N      array: A1(N),A2(N)
C--------I------I-----I------------------------------------------------
C NFAIL  I  I   I out I number of unequal components of A1 and A2
C--------I------I-----I------------------------------------------------
C LIST   I  I   I out I list of unequal components of A1 and A2
C        I      I     I                                 array:  LIST(N)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z
      DOUBLE PRECISION  ZERO,AA1,AA2,AMAX,QUOT,ONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ZERO=0.
      ONE=1.
      AMAX=ZERO
      DO 10 Z=1,N
	AMAX=MAX(ABS(A1(Z)),ABS(A2(Z)),AMAX)
10    CONTINUE

      NFAIL=0
      DO 410 Z=1,N
         AA1=A1(Z)
         AA2=A2(Z)
         IF ( (AA1.EQ.ZERO).OR.(AA2.EQ.ZERO) ) THEN
           IF ( (ABS(AA1).GT.AZERO*AMAX).OR.
     &                         (ABS(AA2).GT.AZERO*AMAX) ) THEN
             NFAIL=NFAIL+1
             LIST(NFAIL)=Z
           ENDIF
         ELSE
           QUOT=ABS(AA1/AA2)
           IF ( ((QUOT.LT.ONE-QUOLIM).OR.(QUOT.GT.ONE+QUOLIM)).AND.
     &          (ABS(AA1-AA2).GT.100 * EPS * AMAX ) ) THEN
             NFAIL=NFAIL+1
             LIST(NFAIL)=Z
           ENDIF
         ENDIF
 410  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM900----------------------------------------------------
      E    N    D
