C:::::      ,,,,,VEM902...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM902(N,FIRST,M,NX,X,LLIST,K,LIST,LS,W1,W2,S1,S2)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM902  computes two weighted sums where the terms of      ***
C**              sums are gathered by an index list:                ***
C**                                                                 ***
C**                               k                                 ***
C**                     Sl(z,i)= SUM  Wl(j)*X(LIST(FIRST-1+z,j),i)  ***
C**                              j=1                                ***
C**                                                                 ***
C**               for z=1,N, i=1,M and l=1,2.                       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N, M, K, FIRST, LLIST, NX, LIST(LLIST,K),LS
      DOUBLE PRECISION  X(NX,M), W1(K),W2(K),S1(LS,M),S2(LS,M)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of sums
C--------I------I-----I------------------------------------------------
C FIRST  I  I   I in  I first element in index list
C        I      I     I   FIRST-1+N <= LLIST !
C--------I------I-----I------------------------------------------------
C M      I  I   I in  I dimension of the sums
C--------I------I-----I------------------------------------------------
C X      I  R   I in  I terms of the sum                 array: X(NX,M)
C--------I------I-----I------------------------------------------------
C K      I  I   I in  I number terms in the sum
C--------I------I-----I------------------------------------------------
C LIST   I  I   I in  I index list of terms in the sum
C        I      I     I                           array:  LIST(LLIST,K)
C--------I------I-----I------------------------------------------------
C W1,W2, I  R   I in  I weigths                            array: Wi(K)
C--------I------I-----I------------------------------------------------
C S1,S2  I  R   I out I the sums                        array: Si(LS,M)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z, I, J
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**                                                                 ***
        DO 105 I=1,M
           DO 105 Z=1,N
             S1(Z,I)=0.
             S2(Z,I)=0.
  105   CONTINUE

        DO 202 I=1,M
           DO 202 J=1,K

            DO 300 Z=1,N
              S1(Z,I)=S1(Z,I)+W1(J)*X(LIST(Z+FIRST-1,J),I)
              S2(Z,I)=S2(Z,I)+W2(J)*X(LIST(Z+FIRST-1,J),I)
  300       CONTINUE

 202     CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM902----------------------------------------------------
      E    N    D
