C:::::      ,,,,,VEM908...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM908(N,FIRST,M,X1,TOTX,X,M2,K,TOTK,LS,
     &                  W1,W2,W3,S1,S2,S3)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM908  computes three weighted sums                       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N,M,FIRST,X1,TOTX,LS,M2,TOTK
      INTEGER           K(M2)
      DOUBLE PRECISION  X(X1,TOTX),W1(TOTK),S1(LS,M),W2(TOTK),
     &                  S2(LS,M),W3(TOTK),S3(LS,M)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of sums
C--------I------I-----I------------------------------------------------
C FIRST  I  I   I in  I first element in X, FIRST-1+N <= X1 !
C--------I------I-----I------------------------------------------------
C M      I  I   I in  I dimension of the sums
C--------I------I-----I------------------------------------------------
C X      I  R   I in  I terms of the sum              array: X(X1,TOTX)
C--------I------I-----I------------------------------------------------
C K      I  I   I in  I number terms in the sum where for i=1,M
C        I      I     I the weights Wl(SUMI+1),...,Wl(SUMI+K(i)) and
C        I      I     I vectors X(.,SUMK+1),...,X(i,SUMK+K(i)) are
C        I      I     I used (K(i)=K(M2) if i>M2).
C        I      I     I array: K(M2)
C--------I------I-----I------------------------------------------------
C W1,W2, I  R   I in  I weigths                         array: Wl(TOTK)
C  W3    I      I     I
C--------I------I-----I------------------------------------------------
C S1,S2, I  R   I out I the sums                        array: Sl(LS,M)
C  S3    I      I     I
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,I,J,SUMK,SUMI
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**                                                                 ***
      DO 105 I=1,M
         DO 105 Z=1,N
           S1(Z,I)=0.
           S2(Z,I)=0.
           S3(Z,I)=0.
  105 CONTINUE

      SUMI=0
      SUMK=0
      DO 203 I=1,M
        DO 300 J=1,K(MIN(I,M2))

          DO 300 Z=1,N
            S1(Z,I)=S1(Z,I)+W1(SUMI+J)*X(Z+FIRST-1,SUMK+J)
            S2(Z,I)=S2(Z,I)+W2(SUMI+J)*X(Z+FIRST-1,SUMK+J)
            S3(Z,I)=S3(Z,I)+W3(SUMI+J)*X(Z+FIRST-1,SUMK+J)
  300   CONTINUE

	IF (I.GE.M2) THEN
          SUMK=SUMK+K(M2)
        ELSE
          SUMK=SUMK+K(I)
          SUMI=SUMI+K(I)
        ENDIF

 203  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM908----------------------------------------------------
      E    N    D
