C:::::      ,,,,,VEM911.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM911(N,M,L,MAT,DET)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEM911  computes the absolute values of the determinates    ***
C**             of a large system of M x M matrices (M=1,2,3)       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           M, N, L
      DOUBLE PRECISION  MAT(L,M,M), DET(L)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of matrices
C--------I------I-----I------------------------------------------------
C M      I  I   I in  I dimension of the matrices M=1,2,3
C--------I------I-----I------------------------------------------------
C MAT    I  R   I in  I set of M x M matrices         array: MAT(L,M,M)
C--------I------I-----I------------------------------------------------
C DET    I  R   I out I absolute value of the determinates of the
C        I      I     I matrices                          array: DET(L)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      IF (M.EQ.1) THEN

        DO 100 Z=1,N
           DET(Z)    =ABS(MAT(Z,1,1))
100     CONTINUE

      ENDIF

      IF (M.EQ.2) THEN

          DO 200 Z=1,N
            DET(Z) = ABS(MAT(Z,1,1)*MAT(Z,2,2)-MAT(Z,1,2)*MAT(Z,2,1))
  200    CONTINUE

      ENDIF

      IF (M.EQ.3) THEN

        DO 300 Z=1,N
          DET(Z)= ABS((MAT(Z,2,2)*MAT(Z,3,3)-MAT(Z,2,3)*MAT(Z,3,2))
     &                * MAT(Z,1,1) +
     &                (MAT(Z,3,1)*MAT(Z,2,3)-MAT(Z,2,1)*MAT(Z,3,3))
     &                * MAT(Z,1,2) +
     &                (MAT(Z,2,1)*MAT(Z,3,2)-MAT(Z,3,1)*MAT(Z,2,2))
     &                * MAT(Z,1,3)                                 )
  300   CONTINUE

      ENDIF

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM911----------------------------------------------------
      E    N    D
